/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.test;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.frame.core.locking.Util;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.lib.util.concurrent.CountDown;
import com.sap.engine.services.locking.test.BaseLockingContextTest;
import com.sap.engine.services.locking.test.LockRunner;
import com.sap.engine.services.locking.test.TestResult;
import java.util.Properties;
import java.util.Random;

public class CreateLocksMultiThreadedTest
extends BaseLockingContextTest {
    public static final int NUMBER_OF_THREADS = 10;
    public static final int NUMBER_OF_LOCKS = 400;
    public static final int NUMBER_OF_LOCKS_TO_SUCCEED = 400;
    public static final int NUMBER_OF_LOCKS_TO_FAIL = 3600;
    private static final Util UTIL = new Util();
    private static final Random RANDOM = new Random();

    public String getName() {
        return "Create locks multi threaded";
    }

    public String getDescription() {
        return "1) Creates locks N locks by T threads (total of N*T locks)\n   Every thread trys to make the same locks,\n   so only N locks must succeed and (N-1)*T locks must fail.";
    }

    protected void test(ThreadSystem threadSystem, Properties properties, TestResult logging, AdministrativeLocking locking, String owner1, String owner2) throws Exception {
        boolean success;
        logging.log("Create T threads which name prepared to create N locks");
        String owner = owner1;
        String name = "X$$_TESTNAME_$$name";
        char mode = 'X';
        CountDown countDown = new CountDown(10);
        LockRunner[] runners = new LockRunner[10];
        int i = 0;
        while (i < runners.length) {
            String[] arguments = this.createArguments();
            runners[i] = new LockRunner(countDown, locking, owner, name, arguments, mode);
            ++i;
        }
        logging.log("Start the threads");
        if (threadSystem != null) {
            int i2 = 0;
            while (i2 < runners.length) {
                threadSystem.startThread(runners[i2], false);
                ++i2;
            }
        } else {
            Thread[] t = new Thread[runners.length];
            int i3 = 0;
            while (i3 < t.length) {
                t[i3] = new Thread(runners[i3]);
                ++i3;
            }
            int i4 = 0;
            while (i4 < t.length) {
                t[i4].start();
                ++i4;
            }
        }
        logging.log("Wait until threads finished");
        countDown.acquire();
        logging.log("All threads finished");
        int i5 = 0;
        while (i5 < runners.length) {
            if (runners[i5]._resultException != null) {
                throw new TechnicalLockException("Thread " + i5 + " finished with Exception", runners[i5]._resultException);
            }
            ++i5;
        }
        int totalSucceeded = 0;
        int totalFailed = 0;
        int i6 = 0;
        while (i6 < runners.length) {
            totalSucceeded += runners[i6]._resultLocksSucceeded;
            totalFailed += runners[i6]._resultLocksFailed;
            ++i6;
        }
        boolean bl = success = totalSucceeded == 400 && totalFailed == 3600;
        if (success) {
            logging.log("Success: 400 locks succeed and 3600 locks failed");
            logging.log("Details:");
            int i7 = 0;
            while (i7 < runners.length) {
                logging.log("Thread " + i7 + ": (success/fail) = " + runners[i7]._resultLocksSucceeded + " / " + runners[i7]._resultLocksFailed);
                ++i7;
            }
        } else {
            String message = "Wrong results:\nExpected: 400 locks succeed and 3600 locks failed\nReceived: " + totalSucceeded + " locks succeed and " + totalFailed + " locks failed";
            logging.log(message);
            logging.log("Details:");
            int i8 = 0;
            while (i8 < runners.length) {
                logging.log("Thread " + i8 + ": (success/fail) = " + runners[i8]._resultLocksSucceeded + " / " + runners[i8]._resultLocksFailed);
                ++i8;
            }
            throw new TechnicalLockException(message);
        }
    }

    private String[] createArguments() {
        String[] result = new String[400];
        String argumentStart = "$$_TESTARGUMENT_$$argument";
        int numberLength = Integer.toString(400).length();
        int i = 0;
        while (i < result.length) {
            String number = UTIL.adjustStringLengthLeft(Integer.toString(i), numberLength, '0');
            result[i] = argumentStart + number;
            ++i;
        }
        int i2 = 0;
        while (i2 < result.length) {
            int pos1 = RANDOM.nextInt(result.length);
            int pos2 = RANDOM.nextInt(result.length);
            String temp = result[pos1];
            result[pos1] = result[pos2];
            result[pos2] = temp;
            ++i2;
        }
        return result;
    }
}

