/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.test;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.frame.core.locking.LockEntry;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.services.locking.test.BaseLockingContextTest;
import com.sap.engine.services.locking.test.TestResult;
import java.util.Properties;

public class CreateLocksArrayTest
extends BaseLockingContextTest {
    public String getName() {
        return "Create locks in array-operation";
    }

    public String getDescription() {
        return "1) Create several locks for owner1 and owner2\n2) Create conflicting locks to check transactional behaviour\n3) Repeat the step 1)\n\nAfter every step the locks are always checked for consistency.";
    }

    protected void test(ThreadSystem threadSystem, Properties properties, TestResult logging, AdministrativeLocking locking, String owner1, String owner2) throws Exception {
        String name1 = "X$$_TESTNAME_$$name1";
        String argument1 = "$$_TESTARGUMENT_$$argument1";
        String argument2 = "$$_TESTARGUMENT_$$argument2";
        String argument3 = "$$_TESTARGUMENT_$$argument3";
        logging.log("CREATE LOCKS");
        logging.log("Create locks for owner1");
        String[] names1 = new String[]{name1, name1, name1, name1, name1, name1};
        String[] arguments1 = new String[]{argument1, argument1, argument1, argument3, argument3, argument3};
        char[] modes1 = new char[]{'S', 'S', 'S', 'E', 'E', 'E'};
        locking.lock(owner1, names1, arguments1, modes1);
        logging.log("Create locks for owner2");
        String[] names2 = new String[]{name1, name1, name1, name1, name1, name1};
        String[] arguments2 = new String[]{argument1, argument1, argument1, argument2, argument2, argument2};
        char[] modes2 = new char[]{'S', 'S', 'S', 'E', 'E', 'E'};
        locking.lock(owner2, names2, arguments2, modes2);
        this.checkLocks(logging, locking, name1, 3);
        logging.log("Repeat locks for owner1");
        locking.lock(owner1, names1, arguments1, modes1);
        logging.log("Repeat locks for owner2");
        locking.lock(owner2, names2, arguments2, modes2);
        this.checkLocks(logging, locking, name1, 6);
        logging.log("");
        logging.log("CHECK TRANSACTIONAL CONSISTENCY");
        logging.log("Redo locks of owner1 for owner2 => expect exception");
        this.lockExpectException(locking, owner2, names1, arguments1, modes1);
        this.checkLocks(logging, locking, name1, 6);
        logging.log("Redo locks of owner2 for owner1 => expect exception");
        this.lockExpectException(locking, owner1, names2, arguments2, modes2);
        this.checkLocks(logging, locking, name1, 6);
        logging.log("");
        logging.log("CREATE LOCKS");
        logging.log("Repeat locks for owner1");
        locking.lock(owner1, names1, arguments1, modes1);
        logging.log("Repeat locks for owner2");
        locking.lock(owner2, names2, arguments2, modes2);
        this.checkLocks(logging, locking, name1, 9);
    }

    private void checkLocks(TestResult logging, AdministrativeLocking locking, String name, int count) throws Exception {
        logging.log("Check locks");
        LockEntry[] entries = locking.getLocks(name, null);
        this.checkLockEntries(entries, new Integer(4), null, name, null, null, new Integer(count));
    }
}

