/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.test;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.frame.core.locking.LockEntry;
import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.Util;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.services.locking.exception.LockingTechnicalLockException;
import com.sap.engine.services.locking.test.ILockingContextTest;
import com.sap.engine.services.locking.test.TestResult;
import java.util.Properties;

public abstract class BaseLockingContextTest
implements ILockingContextTest {
    protected static final Util UTIL = new Util();

    protected abstract void test(ThreadSystem var1, Properties var2, TestResult var3, AdministrativeLocking var4, String var5, String var6) throws Exception;

    public TestResult start(ThreadSystem threadSystem, AdministrativeLocking locking, Properties properties) {
        TestResult result = new TestResult();
        try {
            result.log("START TEST " + this.getName());
            result.log("-------------------------------------------------------");
            result.log("DESCRIPTION:");
            result.log(this.getDescription());
            result.log("-------------------------------------------------------");
            this.test(threadSystem, locking, properties, result);
            result.close(null);
        }
        catch (Exception e) {
            result.close(e);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void test(ThreadSystem threadSystem, AdministrativeLocking locking, Properties properties, TestResult logging) throws Exception {
        String owner1 = locking.createUniqueOwner();
        String owner2 = locking.createUniqueOwner();
        try {
            this.test(threadSystem, properties, logging, locking, owner1, owner2);
            Object var8_7 = null;
            boolean success = true;
            success &= this.cleanupOwner(locking, logging, owner1);
            if (success &= this.cleanupOwner(locking, logging, owner2)) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            boolean success = true;
            success &= this.cleanupOwner(locking, logging, owner1);
            if (success &= this.cleanupOwner(locking, logging, owner2)) throw throwable;
            throw new LockingTechnicalLockException("locking_2000", new Object[]{owner1, owner2});
        }
        throw new LockingTechnicalLockException("locking_2000", new Object[]{owner1, owner2});
    }

    public String toString() {
        return this.getName();
    }

    private boolean cleanupOwner(AdministrativeLocking administrativeLocking, TestResult logging, String owner) {
        try {
            administrativeLocking.unlockAll(owner, false);
            return true;
        }
        catch (Exception e) {
            logging.log("-------------------------------------------------------");
            logging.log("CRITICAL ERROR: CLEANUP FAILED");
            logging.log("SOME OF THE CREATED LOCKS COULD NOT BE REMOVED");
            logging.log("OWNER = [" + owner + "]");
            logging.log("-------------------------------------------------------");
            return false;
        }
    }

    protected void lockExpectException(AdministrativeLocking locking, String owner, String name, String argument, char mode) throws Exception {
        try {
            locking.lock(owner, name, argument, mode);
        }
        catch (LockException e) {
            return;
        }
        throw new Exception("Expected LockException did not occur for " + this.getLockDescription(owner, name, argument, mode));
    }

    protected void lockExpectException(AdministrativeLocking locking, String owner, String[] name, String[] argument, char[] mode) throws Exception {
        try {
            locking.lock(owner, name, argument, mode);
        }
        catch (LockException e) {
            return;
        }
        throw new Exception("Expected LockException did not occur for [" + owner + "]");
    }

    protected void lockExpectIllegalArgumentException(AdministrativeLocking locking, String owner, String name, String argument, char mode) throws Exception {
        try {
            locking.lock(owner, name, argument, mode);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        throw new Exception("Expected IllegalArgumentException did not occur for " + this.getLockDescription(owner, name, argument, mode));
    }

    protected void lockExpectIllegalArgumentException(AdministrativeLocking locking, String owner, String[] name, String[] argument, char[] mode) throws Exception {
        try {
            locking.lock(owner, name, argument, mode);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        throw new Exception("Expected IllegalArgumentException did not occur for [owner=" + owner + "]");
    }

    protected void unlockExpectIllegalArgumentException(AdministrativeLocking locking, String owner, String name, String argument, char mode) throws Exception {
        try {
            locking.unlock(owner, name, argument, mode, false);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        throw new Exception("Expected IllegalArgumentException did not occur for " + this.getLockDescription(owner, name, argument, mode));
    }

    protected void unlockExpectIllegalArgumentException(AdministrativeLocking locking, String owner, String[] name, String[] argument, char[] mode) throws Exception {
        try {
            locking.unlock(owner, name, argument, mode, false);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        throw new Exception("Expected IllegalArgumentException did not occur for [owner=" + owner + "]");
    }

    protected void checkLockEntries(LockEntry[] entries, Integer expectedLength, String owner, String name, String argument, Character mode, Integer count) throws Exception {
        if (name != null) {
            name = UTIL.adjustStringLengthRight(name, 30, ' ');
        }
        if (argument != null) {
            argument = UTIL.adjustStringLengthRight(argument, 150, ' ');
        }
        if (expectedLength != null && entries.length != expectedLength) {
            throw new Exception("Received " + entries.length + " LockEntries, but expected " + expectedLength + " LockEntries");
        }
        int i = 0;
        while (i < entries.length) {
            LockEntry entry = entries[i];
            int differences = 0;
            if (owner != null && !owner.equals(entry.getOwner())) {
                ++differences;
            }
            if (name != null && !name.equals(entry.getName())) {
                ++differences;
            }
            if (argument != null && !argument.equals(entry.getArgument())) {
                ++differences;
            }
            if (mode != null && mode.charValue() != entry.getMode()) {
                ++differences;
            }
            if (count != null && count.intValue() != entry.getCount()) {
                ++differences;
            }
            if (differences > 0) {
                throw new Exception("Received wrong LockEntry (" + differences + " differences):\n" + "expected: [owner=" + owner + ", name=" + name + ", argument=" + argument + ", mode=" + mode + ", count=" + count + "]\n" + "received: [owner=" + entry.getOwner() + ", name=" + entry.getName() + ", argument=" + entry.getArgument() + ", mode=" + entry.getMode() + ", count=" + entry.getCount() + "]\n");
            }
            ++i;
        }
    }

    protected String getLockDescription(String owner, String name, String argument, char mode) {
        return "[owner=" + owner + ", name=" + name + ", argument=" + argument + ", mode=" + mode + "]";
    }

    public abstract String getDescription();

    public abstract String getName();
}

