/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.gui;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.services.locking.gui.BasePanel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import com.sap.engine.services.locking.test.AllTests;
import com.sap.engine.services.locking.test.ILockingContextTest;
import com.sap.engine.services.locking.test.TestResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;

public class RunTestsPanel
extends BasePanel
implements ActionListener {
    private AdministrativeLocking _locking;
    private JPanel _runTestsPanel;
    private JButton _runFunctionalTestsButton;
    private JButton _runLoadTestsButton;
    private JTextArea _runTestsResultName;

    public RunTestsPanel(AdministrativeLocking locking) {
        this._locking = locking;
        this._runFunctionalTestsButton = ComponentFactory.createButton("Execute functional tests", this, "Executes several tests, which check if the locking is working correctly");
        this._runLoadTestsButton = ComponentFactory.createButton("Execute load tests", this, "Executes several tests, which perform load-tests (e.g. create thousands of locks)");
        JPanel buttons = ComponentFactory.createHorizontalGridPanel(new JComponent[]{this._runFunctionalTestsButton, this._runLoadTestsButton});
        this._runTestsResultName = ComponentFactory.createTextArea(null);
        JScrollPane scrollableResultName = new JScrollPane(this._runTestsResultName);
        CompoundBorder border = BorderFactory.createCompoundBorder(ComponentFactory.STANDARD_LINE_BORDER, BorderFactory.createEtchedBorder(1));
        scrollableResultName.setBorder(border);
        this._runTestsPanel = ComponentFactory.createVerticalPanel(buttons, scrollableResultName, null);
        this.setLayout(new BorderLayout());
        this.add((Component)this._runTestsPanel, "Center");
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this._runFunctionalTestsButton) {
                this.runTests(AllTests.getFunctionalLockingContextTests());
            } else if (source == this._runLoadTestsButton) {
                this.runTests(AllTests.getLoadLockingContextTests());
            }
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }

    private void runTests(ILockingContextTest[] test2) {
        Properties properties = new Properties();
        long start = System.currentTimeMillis();
        StringBuffer logBuffer = new StringBuffer(4096);
        int successfulTests = 0;
        int i = 0;
        while (i < test2.length) {
            TestResult result = test2[i].start(null, this._locking, properties);
            logBuffer.append(result.getLog());
            logBuffer.append("\n\n\n\n");
            if (result.getException() == null) {
                ++successfulTests;
            }
            ++i;
        }
        long end = System.currentTimeMillis();
        String log = BasePanel.UTIL.replaceChars(logBuffer.toString(), '\t', "    ");
        this._runTestsResultName.setText(log);
        if (successfulTests == test2.length) {
            this.displayMessage("Success", "All " + test2.length + " tests finished successfully (" + (end - start) + " milliseconds)");
        } else {
            this.displayMessage("Error", "ERROR:\nOnly " + successfulTests + " of " + test2.length + " tests finished successfully (" + (end - start) + " milliseconds)");
        }
    }
}

