/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.gui;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class MaxColumnsTextField
extends JTextField {
    private int _maxColumns;

    public MaxColumnsTextField(int visibleColumns, int maxColumns) {
        this._maxColumns = maxColumns;
        if (visibleColumns > this._maxColumns) {
            visibleColumns = this._maxColumns;
        }
        this.setColumns(visibleColumns);
    }

    protected Document createDefaultModel() {
        return new MaxColumnsDocument();
    }

    class MaxColumnsDocument
    extends PlainDocument {
        MaxColumnsDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() > MaxColumnsTextField.this._maxColumns) {
                str = str.substring(0, MaxColumnsTextField.this._maxColumns - this.getLength());
            }
            super.insertString(offs, str, a);
        }
    }
}

