/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.gui;

import com.sap.engine.frame.core.locking.LockEntry;
import com.sap.engine.frame.core.locking.LockEntryInfo;
import com.sap.engine.services.locking.gui.BasePanel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LockEntryDetailPanel
extends BasePanel {
    private static final int VISIBLE_COLUMNS = 58;
    private JPanel _detailPanel;
    private JLabel _detailUserLabel;
    private JTextField _detailUserField;
    private JLabel _detailOwnerLabel;
    private JTextField _detailOwnerField;
    private JLabel _detailNameLabel;
    private JTextField _detailNameField;
    private JLabel _detailArgumentLabel;
    private JTextField _detailArgumentField;
    private JLabel _detailModeLabel;
    private JTextField _detailModeField;
    private JLabel _detailCountLabel;
    private JTextField _detailCountField;
    private JLabel _detailNamespaceLabel;
    private JTextField _detailNamespaceField;

    public LockEntryDetailPanel(LockEntry lockEntry, LockEntryInfo lockEntryInfo) {
        this.initializeDetailPanel();
        this.display(lockEntry, lockEntryInfo);
    }

    private void initializeDetailPanel() {
        this._detailUserField = ComponentFactory.createTextField(58, -1, "The user who holds the lock");
        this._detailOwnerField = ComponentFactory.createTextField(58, -1, "The owner of the lock");
        this._detailNameField = ComponentFactory.createTextField(58, -1, "The name which is locked");
        this._detailArgumentField = ComponentFactory.createTextField(58, -1, "The argument which is locked");
        this._detailModeField = ComponentFactory.createTextField(58, -1, "The mode of the lock");
        this._detailCountField = ComponentFactory.createTextField(58, -1, "The count of the lock");
        this._detailNamespaceField = ComponentFactory.createTextField(58, -1, "The namespace of the lock");
        this._detailUserField.setEditable(false);
        this._detailOwnerField.setEditable(false);
        this._detailNameField.setEditable(false);
        this._detailArgumentField.setEditable(false);
        this._detailModeField.setEditable(false);
        this._detailCountField.setEditable(false);
        this._detailNamespaceField.setEditable(false);
        this._detailUserLabel = new JLabel("User:");
        this._detailOwnerLabel = new JLabel("Owner:");
        this._detailNameLabel = new JLabel("Name:");
        this._detailArgumentLabel = new JLabel("Argument:");
        this._detailModeLabel = new JLabel("Mode:");
        this._detailCountLabel = new JLabel("Count:");
        this._detailNamespaceLabel = new JLabel("Namespace:");
        JLabel[] labels = new JLabel[]{this._detailUserLabel, this._detailOwnerLabel, this._detailNameLabel, this._detailArgumentLabel, this._detailModeLabel, this._detailCountLabel, this._detailNamespaceLabel};
        JComponent[] components = new JComponent[]{this._detailUserField, this._detailOwnerField, this._detailNameField, this._detailArgumentField, this._detailModeField, this._detailCountField, this._detailNamespaceField};
        this._detailPanel = ComponentFactory.createLabeledGridPanel(labels, components);
        this.setLayout(new BorderLayout());
        this.add((Component)this._detailPanel, "North");
    }

    private void display(LockEntry lockEntry, LockEntryInfo lockEntryInfo) {
        this._detailUserField.setText(lockEntry.getUser());
        this._detailOwnerField.setText(lockEntry.getOwner());
        this._detailNameField.setText(lockEntry.getName());
        this._detailArgumentField.setText(lockEntry.getArgument());
        this._detailModeField.setText(BasePanel.getDescriptionForMode(lockEntry.getMode()));
        this._detailCountField.setText(Integer.toString(lockEntry.getCount()));
        if (lockEntryInfo.getNamespace() != null) {
            this._detailNamespaceField.setText(lockEntryInfo.getNamespace() + " [" + lockEntryInfo.getNamespaceDescription() + "]");
        } else {
            this._detailNamespaceField.setText("<none>");
        }
        this._detailUserField.setCaretPosition(0);
        this._detailOwnerField.setCaretPosition(0);
        this._detailNameField.setCaretPosition(0);
        this._detailArgumentField.setCaretPosition(0);
        this._detailModeField.setCaretPosition(0);
        this._detailCountField.setCaretPosition(0);
        this._detailNamespaceField.setCaretPosition(0);
    }
}

