/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.gui;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.frame.core.locking.LockEntry;
import com.sap.engine.frame.core.locking.LockEntryInfo;
import com.sap.engine.gui.SortTable;
import com.sap.engine.services.locking.gui.BasePanel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import com.sap.engine.services.locking.gui.LockEntryDetailPanel;
import com.sap.engine.services.locking.gui.LockEntryTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DisplayLocksPanel
extends BasePanel
implements ActionListener,
ListSelectionListener {
    private AdministrativeLocking _locking;
    private JPanel _displayLocksPanel;
    private JTextField _displayLocksForNameField;
    private JTextField _displayLocksForArgumentField;
    private JButton _displayLocksButton;
    private JButton _displayRemainingTestLocksButton;
    private SortTable _displayLocksTable;
    private LockEntryTableModel _displayLocksTableModel;
    private JButton _displayLocksDetailSelectedButton;
    private JButton _displayLocksDeleteSelectedButton;
    private String _lastDisplayLocksName;
    private String _lastDisplayLocksArgument;

    public DisplayLocksPanel(AdministrativeLocking locking) {
        this._locking = locking;
        this._displayLocksForNameField = ComponentFactory.createTextField(15, 30, "The name-filter for which to list the current locks");
        JPanel displayLocksForName = ComponentFactory.createLabelForComponent("Name:", this._displayLocksForNameField);
        this._displayLocksForArgumentField = ComponentFactory.createTextField(30, 150, "The argument-filter for which to list the current locks");
        JPanel displayLocksForArgument = ComponentFactory.createLabelForComponent("Argument:", this._displayLocksForArgumentField);
        this._displayLocksButton = ComponentFactory.createButton("Refresh", this, "Refreshes/displays the locks for the specified filter-criteria");
        this._displayRemainingTestLocksButton = ComponentFactory.createButton("Testlocks", this, "Display all locks, which match the filter-criteria for internal tests (typically there are none). Probably those locks were remaining after a previous test-run and can be deleted.");
        JPanel filterPanel = ComponentFactory.createHorizontalPanel(displayLocksForName, displayLocksForArgument, this._displayLocksButton);
        filterPanel.setBorder(ComponentFactory.STANDARD_LINE_BORDER);
        JPanel remainingLocksPanel = ComponentFactory.createHorizontalPanel(null, null, this._displayRemainingTestLocksButton);
        JPanel displayLocksInputPanel = ComponentFactory.createHorizontalPanel(null, filterPanel, remainingLocksPanel);
        this._displayLocksTableModel = new LockEntryTableModel();
        this._displayLocksTable = ComponentFactory.createSortableTable(this._displayLocksTableModel);
        this._displayLocksTable.getSelectionModel().addListSelectionListener(this);
        this._displayLocksTableModel.setColumnModel(this._displayLocksTable.getColumnModel());
        this._displayLocksTable.getTableHeader().setReorderingAllowed(false);
        this._displayLocksTable.getSelectionModel().setSelectionMode(2);
        JScrollPane scrollableTable = new JScrollPane((Component)this._displayLocksTable, 20, 30);
        this._displayLocksDetailSelectedButton = ComponentFactory.createButton("Show details", this, "Show all details for the selected lock");
        this._displayLocksDetailSelectedButton.setEnabled(false);
        this._displayLocksDeleteSelectedButton = ComponentFactory.createButton("Delete selected locks", this, "Delete the selected lock (deletes all counts)");
        this._displayLocksDeleteSelectedButton.setEnabled(false);
        JPanel buttons = ComponentFactory.createHorizontalGridPanel(new JComponent[]{this._displayLocksDetailSelectedButton, this._displayLocksDeleteSelectedButton});
        this._displayLocksPanel = ComponentFactory.createVerticalPanel(displayLocksInputPanel, scrollableTable, buttons);
        this.setLayout(new BorderLayout());
        this.add((Component)this._displayLocksPanel, "Center");
    }

    private LockEntry[] getSelectedLocks() {
        if (this._displayLocksTable.getSelectedRowCount() == 0) {
            return new LockEntry[0];
        }
        int[] selectedRows = this._displayLocksTable.getSelectedRows();
        LockEntry[] allRows = this._displayLocksTableModel.getValues();
        LockEntry[] result = new LockEntry[selectedRows.length];
        int i = 0;
        while (i < selectedRows.length) {
            result[i] = allRows[this._displayLocksTable.getDataIndex(selectedRows[i])];
            ++i;
        }
        return result;
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        if (this._displayLocksTable.getSelectedRowCount() == 0) {
            this._displayLocksDeleteSelectedButton.setEnabled(false);
        } else {
            this._displayLocksDeleteSelectedButton.setEnabled(true);
        }
        if (this._displayLocksTable.getSelectedRowCount() != 1) {
            this._displayLocksDetailSelectedButton.setEnabled(false);
        } else {
            this._displayLocksDetailSelectedButton.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent event) {
        block13: {
            try {
                Object source = event.getSource();
                if (source == this._displayLocksButton) {
                    String argument;
                    String name = this._displayLocksForNameField.getText();
                    if (name != null && name.length() == 0) {
                        name = null;
                    }
                    if ((argument = this._displayLocksForArgumentField.getText()) != null && argument.length() == 0) {
                        argument = null;
                    }
                    LockEntry[] lockEntry = this._locking.getLocks(name, argument);
                    this._displayLocksTableModel.setValues(lockEntry);
                    this._lastDisplayLocksName = name;
                    this._lastDisplayLocksArgument = argument;
                    break block13;
                }
                if (source == this._displayRemainingTestLocksButton) {
                    this._displayLocksForNameField.setText("X$$_TESTNAME_$$*");
                    this._displayLocksForArgumentField.setText("$$_TESTARGUMENT_$$*");
                    this._displayLocksButton.doClick();
                    break block13;
                }
                if (source == this._displayLocksDeleteSelectedButton) {
                    int result = JOptionPane.showConfirmDialog(this, "You are about to delete the selected locks.\nIf this is done carelessly it can cause inconsistencies.\nDo you really want to proceed?", "Really delete?", 2, 3);
                    if (result != 0) {
                        return;
                    }
                    try {
                        LockEntry[] selected = this.getSelectedLocks();
                        int i = 0;
                        while (i < selected.length) {
                            this._locking.unlockAllCumulativeCounts(selected[i].getOwner(), selected[i].getName(), selected[i].getArgument(), selected[i].getMode(), false);
                            ++i;
                        }
                        Object var7_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_14 = null;
                        LockEntry[] lockEntry = this._locking.getLocks(this._lastDisplayLocksName, this._lastDisplayLocksArgument);
                        this._displayLocksTableModel.setValues(lockEntry);
                        throw throwable;
                    }
                    LockEntry[] lockEntry = this._locking.getLocks(this._lastDisplayLocksName, this._lastDisplayLocksArgument);
                    this._displayLocksTableModel.setValues(lockEntry);
                    {
                        break block13;
                    }
                }
                if (source == this._displayLocksDetailSelectedButton) {
                    LockEntry[] selected = this.getSelectedLocks();
                    if (selected.length == 0) {
                        return;
                    }
                    LockEntry lockEntry = selected[0];
                    LockEntryInfo lockEntryInfo = this._locking.getLockEntryInfo(lockEntry);
                    LockEntryDetailPanel detailPanel = new LockEntryDetailPanel(lockEntry, lockEntryInfo);
                    JOptionPane.showMessageDialog(this, detailPanel, "Details", -1);
                }
            }
            catch (Exception e) {
                this.displayException(e);
            }
        }
    }
}

