/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.gui;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.frame.core.locking.DescribedFile;
import com.sap.engine.frame.core.locking.DescribedFileContent;
import com.sap.engine.services.locking.gui.BasePanel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;

public class DisplayFilesPanel
extends BasePanel
implements ActionListener {
    private static final int MAX_FILE_LENGTH = 100000;
    private JPanel _displayFilesPanel;
    private JComboBox _displayFilesSelection;
    private JButton _displayFilesButton;
    private JTextArea _displayFileContentArea;
    private AdministrativeLocking _locking;
    private DescribedFile[] _describedFiles;

    public DisplayFilesPanel(AdministrativeLocking locking) {
        this._locking = locking;
        this._describedFiles = this._locking.getDescribedFiles();
        this._displayFilesButton = ComponentFactory.createButton("Display", this, "Display the selected file");
        if (this._describedFiles != null && this._describedFiles.length != 0) {
            this._displayFilesSelection = ComponentFactory.createComboBox(this._describedFiles, 0, this, "Select the file to display");
        } else {
            this._displayFilesSelection = ComponentFactory.createComboBox(new String[]{"<no files specified>"}, 0, this, "There are no files specified to display");
            this._displayFilesSelection.setEnabled(false);
            this._displayFilesButton.setEnabled(false);
        }
        JPanel selectionPanel = ComponentFactory.createHorizontalPanel(null, this._displayFilesSelection, this._displayFilesButton);
        this._displayFileContentArea = ComponentFactory.createTextArea(null);
        JScrollPane scrollableResultName = new JScrollPane(this._displayFileContentArea);
        CompoundBorder border = BorderFactory.createCompoundBorder(ComponentFactory.STANDARD_LINE_BORDER, BorderFactory.createEtchedBorder(1));
        scrollableResultName.setBorder(border);
        this._displayFilesPanel = ComponentFactory.createVerticalPanel(selectionPanel, scrollableResultName, null);
        this.setLayout(new BorderLayout());
        this.add((Component)this._displayFilesPanel, "Center");
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this._displayFilesButton) {
                DescribedFile describedFile = (DescribedFile)this._displayFilesSelection.getSelectedItem();
                if (describedFile.getFile() == null) {
                    this.displayMessage("No filename assigned", "There is no filename assigned to this item.\nProbably this is due to an error on the server.\n\nTry to view the file with an texteditor on the server-machine.");
                    return;
                }
                DescribedFileContent describedFileContent = this._locking.getDescribedFileContent(describedFile, 100000, -100000);
                this.displayFile(describedFileContent, describedFile.getFile());
            }
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }

    private void displayFile(DescribedFileContent describedFileContent, File file) {
        this._displayFileContentArea.setText("");
        if (describedFileContent != null) {
            try {
                if ((describedFileContent.getErrorFlag() & 1) != 0) {
                    this.displayMessage("File does not exist", "The file '" + file + "' does not exist");
                    return;
                }
                if ((describedFileContent.getErrorFlag() & 2) != 0) {
                    this.displayMessage("Not a file", "The file '" + file + "' points to a directory and not a file");
                    return;
                }
                if ((describedFileContent.getErrorFlag() & 3) != 0) {
                    this.displayMessage("Can not read", "The file '" + file + "' is not readable");
                    return;
                }
                StringBuffer buffer = new StringBuffer(4096);
                buffer.append(new String(describedFileContent.getFileContent()));
                this._displayFileContentArea.setText(buffer.toString());
                if (describedFileContent.getFileLength() > 100000) {
                    this.displayMessage("File too big", "The file is too big to display completely. It has a length of " + describedFileContent.getFileLength() + " bytes, but only the last " + 100000 + " bytes are displayed");
                }
            }
            catch (Exception e) {
                this.displayException(e);
            }
        }
    }
}

