/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.gui;

import com.sap.engine.frame.core.locking.Util;
import com.sap.engine.gui.SortTable;
import com.sap.engine.services.locking.gui.MaxColumnsTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class ComponentFactory {
    private static final Util UTIL = new Util();
    public static final int STANDARD_BORDER_WIDTH = 6;
    public static final Insets STANDARD_INSETS = new Insets(6, 6, 6, 6);
    public static final Dimension STANDARD_DIMENSION = new Dimension(6, 6);
    public static final Border STANDARD_EMPTY_BORDER = BorderFactory.createEmptyBorder(6, 6, 6, 6);
    public static final Border STANDARD_LINE_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), STANDARD_EMPTY_BORDER);

    public static JComponent createTextView(String text) {
        text = UTIL.replaceChars(text, '\t', "    ");
        JTextArea name = new JTextArea(text);
        name.setEditable(false);
        name.setOpaque(false);
        JScrollPane scrollableName = new JScrollPane(name);
        scrollableName.setBorder(null);
        return scrollableName;
    }

    public static JTextArea createTextArea(String text) {
        JTextArea name = new JTextArea(text);
        name.setEditable(false);
        return name;
    }

    public static JButton createButton(String text, ActionListener listener, String tooltip) {
        return ComponentFactory.createButton(text, null, listener, tooltip);
    }

    public static JButton createButton(String text, Icon icon, ActionListener listener, String tooltip) {
        JButton result = new JButton();
        if (text != null) {
            result.setText(text);
        }
        if (icon != null) {
            result.setIcon(icon);
        }
        if (listener != null) {
            result.addActionListener(listener);
        }
        result.setToolTipText(tooltip);
        return result;
    }

    public static JComboBox createComboBox(Object[] items, int selectedIndex, ActionListener listener, String tooltip) {
        JComboBox<Object> result = new JComboBox<Object>(items);
        if (listener != null) {
            result.addActionListener(listener);
        }
        result.setSelectedIndex(selectedIndex);
        result.setToolTipText(tooltip);
        return result;
    }

    public static JPanel createLabelForComponent(String text, JComponent field) {
        JLabel label = new JLabel(text);
        label.setLabelFor(field);
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout(6, 6));
        result.add((Component)label, "West");
        result.add((Component)field, "Center");
        result.setToolTipText(field.getToolTipText());
        return result;
    }

    public static JTextField createTextField(int visibleColumns, int maxColumns, String tooltip) {
        JTextField result = maxColumns < 0 ? new JTextField(visibleColumns) : new MaxColumnsTextField(visibleColumns, maxColumns);
        result.setToolTipText(tooltip);
        return result;
    }

    public static JPanel createHorizontalGridPanel(JComponent[] components) {
        JPanel result = new JPanel();
        result.setLayout(new GridLayout(1, 0, 6, 0));
        if (components != null) {
            int i = 0;
            while (i < components.length) {
                result.add(components[i]);
                ++i;
            }
        }
        result.setBorder(STANDARD_EMPTY_BORDER);
        return result;
    }

    public static JPanel createHorizontalPanel(JComponent west, JComponent center, JComponent east) {
        return ComponentFactory.createHorizontalPanel(west, center, east, STANDARD_EMPTY_BORDER);
    }

    public static JPanel createHorizontalPanel(JComponent west, JComponent center, JComponent east, Border border) {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout(6, 6));
        if (east != null) {
            result.add((Component)east, "East");
        }
        if (center != null) {
            result.add((Component)center, "Center");
        }
        if (west != null) {
            result.add((Component)west, "West");
        }
        if (border != null) {
            result.setBorder(border);
        }
        return result;
    }

    public static JPanel createLabeledGridPanel(JLabel[] label, JComponent[] component) {
        if (label != null && component != null && label.length == component.length) {
            int i = 0;
            while (i < label.length) {
                label[i].setLabelFor(component[i]);
                label[i].setHorizontalAlignment(4);
                ++i;
            }
        }
        return ComponentFactory.createTwoColumnGridPanel(label, component);
    }

    public static JPanel createTwoColumnGridPanel(JComponent[] left, JComponent[] right) {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(STANDARD_EMPTY_BORDER);
        if (left == null || right == null || left.length != right.length) {
            return result;
        }
        GridBagConstraints leftC = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, STANDARD_INSETS, 0, 0);
        GridBagConstraints rightC = new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, STANDARD_INSETS, 0, 0);
        int i = 0;
        while (i < left.length) {
            leftC.gridy = i;
            rightC.gridy = i;
            result.add((Component)left[i], leftC);
            result.add((Component)right[i], rightC);
            ++i;
        }
        return result;
    }

    public static JPanel createVerticalGridPanel(JComponent[] components) {
        JPanel result = new JPanel();
        result.setLayout(new GridLayout(0, 1, 0, 6));
        if (components != null) {
            int i = 0;
            while (i < components.length) {
                result.add(components[i]);
                ++i;
            }
        }
        result.setBorder(STANDARD_EMPTY_BORDER);
        return result;
    }

    public static JPanel createVerticalPanel(JComponent north, JComponent center, JComponent south) {
        return ComponentFactory.createVerticalPanel(north, center, south, STANDARD_EMPTY_BORDER);
    }

    public static JPanel createVerticalPanel(JComponent north, JComponent center, JComponent south, Border border) {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout(6, 6));
        if (north != null) {
            result.add((Component)north, "North");
        }
        if (center != null) {
            result.add((Component)center, "Center");
        }
        if (south != null) {
            result.add((Component)south, "South");
        }
        if (border != null) {
            result.setBorder(border);
        }
        return result;
    }

    public static JPanel createVerticalFlowPanel(JComponent[] components) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        int i = 0;
        while (i < components.length) {
            if (i != 0) {
                result.add(Box.createRigidArea(STANDARD_DIMENSION));
            }
            result.add(components[i]);
            ++i;
        }
        result.setBorder(STANDARD_EMPTY_BORDER);
        return result;
    }

    public static Window getWindowForComponent(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Frame || component instanceof Dialog) {
            return (Window)component;
        }
        return ComponentFactory.getWindowForComponent(component.getParent());
    }

    public static JDialog createDialog(Component parentComponent, Component content, String title, boolean modal) {
        Window window = ComponentFactory.getWindowForComponent(parentComponent);
        JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, modal) : new JDialog((Dialog)window, title, modal);
        dialog.getContentPane().add(content);
        dialog.pack();
        dialog.setLocationRelativeTo(window);
        return dialog;
    }

    public static SortTable createSortableTable(AbstractTableModel model) {
        SortTable result = new SortTable((TableModel)model);
        result.setModel(model);
        return result;
    }
}

