/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.gui;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.services.locking.gui.BasePanel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ChangeLocksPanel
extends BasePanel
implements ActionListener {
    private static final String OPERATION_LOCK = "lock";
    private static final String OPERATION_UNLOCK = "unlock";
    private static final String OPERATION_UNLOCKALL = "unlock all";
    private static final String OPERATION_UNLOCKALLCOUNTS = "unlock all counts";
    private static final String OPERATION_UNLOCKALLGENERIC = "unlock all with wildcards";
    private static final String[] CHANGE_LOCK_OPERATIONS = new String[]{"lock", "unlock", "unlock all", "unlock all counts", "unlock all with wildcards"};
    private AdministrativeLocking _locking;
    private JPanel _changeLocksPanel;
    private JLabel _changeLocksForOwnerLabel;
    private JTextField _changeLocksForOwnerField;
    private JLabel _changeLocksForNameLabel;
    private JTextField _changeLocksForNameField;
    private JLabel _changeLocksForArgumentLabel;
    private JTextField _changeLocksForArgumentField;
    private JLabel _changeLocksOperationLabel;
    private JComboBox _changeLocksOperationSelection;
    private JLabel _changeLocksModeLabel;
    private JComboBox _changeLocksModeSelection;
    private JButton _changeLocksButton;

    public ChangeLocksPanel(AdministrativeLocking locking) {
        this._locking = locking;
        this._changeLocksOperationSelection = ComponentFactory.createComboBox(CHANGE_LOCK_OPERATIONS, 0, this, "Select the operation to perform");
        this._changeLocksForOwnerField = ComponentFactory.createTextField(15, 58, "The owner of the lock");
        this._changeLocksForNameField = ComponentFactory.createTextField(15, 30, "The name which to lock/unlock");
        this._changeLocksForArgumentField = ComponentFactory.createTextField(30, 150, "The argument which to lock/unlock");
        this._changeLocksModeSelection = ComponentFactory.createComboBox(BasePanel.ALL_LOCK_MODES, 0, this, "The mode of the lock");
        this._changeLocksOperationLabel = new JLabel("Operation:");
        this._changeLocksForOwnerLabel = new JLabel("Owner:");
        this._changeLocksForNameLabel = new JLabel("Name:");
        this._changeLocksForArgumentLabel = new JLabel("Argument:");
        this._changeLocksModeLabel = new JLabel("Mode:");
        JLabel[] label = new JLabel[]{this._changeLocksOperationLabel, this._changeLocksForOwnerLabel, this._changeLocksForNameLabel, this._changeLocksForArgumentLabel, this._changeLocksModeLabel};
        JComponent[] component = new JComponent[]{this._changeLocksOperationSelection, this._changeLocksForOwnerField, this._changeLocksForNameField, this._changeLocksForArgumentField, this._changeLocksModeSelection};
        JPanel changeLocksAllInputsPanel = ComponentFactory.createLabeledGridPanel(label, component);
        this._changeLocksButton = ComponentFactory.createButton("Execute", this, "Execute the operation");
        this._changeLocksPanel = ComponentFactory.createVerticalPanel(changeLocksAllInputsPanel, null, this._changeLocksButton);
        this.setLayout(new BorderLayout());
        this.add((Component)this._changeLocksPanel, "Center");
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this._changeLocksButton) {
                String owner = this._changeLocksForOwnerField.getText();
                String name = this._changeLocksForNameField.getText();
                String argument = this._changeLocksForArgumentField.getText();
                char mode = BasePanel.getModeForDescription((String)this._changeLocksModeSelection.getSelectedItem());
                String operation = (String)this._changeLocksOperationSelection.getSelectedItem();
                if (OPERATION_LOCK.equals(operation)) {
                    this._locking.lock(owner, name, argument, mode);
                } else if (OPERATION_UNLOCK.equals(operation)) {
                    this._locking.unlock(owner, name, argument, mode, false);
                } else if (OPERATION_UNLOCKALL.equals(operation)) {
                    this._locking.unlockAll(owner, false);
                } else if (OPERATION_UNLOCKALLCOUNTS.equals(operation)) {
                    this._locking.unlockAllCumulativeCounts(owner, name, argument, mode, false);
                } else if (OPERATION_UNLOCKALLGENERIC.equals(operation)) {
                    this._locking.unlockAllGeneric(owner, false);
                }
                this.displayMessage("Success", "Successfully performed the operation.");
            } else if (source == this._changeLocksOperationSelection) {
                String operation = (String)this._changeLocksOperationSelection.getSelectedItem();
                if (OPERATION_UNLOCKALL.equals(operation) || OPERATION_UNLOCKALLGENERIC.equals(operation)) {
                    this._changeLocksForNameLabel.setVisible(false);
                    this._changeLocksForNameField.setVisible(false);
                    this._changeLocksForArgumentLabel.setVisible(false);
                    this._changeLocksForArgumentField.setVisible(false);
                    this._changeLocksModeLabel.setVisible(false);
                    this._changeLocksModeSelection.setVisible(false);
                } else {
                    this._changeLocksForNameLabel.setVisible(true);
                    this._changeLocksForNameField.setVisible(true);
                    this._changeLocksForArgumentLabel.setVisible(true);
                    this._changeLocksForArgumentField.setVisible(true);
                    this._changeLocksModeLabel.setVisible(true);
                    this._changeLocksModeSelection.setVisible(true);
                }
            }
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }
}

