/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.gui;

import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.frame.core.locking.Util;
import com.sap.engine.services.locking.gui.ComponentFactory;
import com.sap.exception.standard.SAPIllegalArgumentException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class BasePanel
extends JPanel {
    protected static final Util UTIL = new Util();
    protected static final String MODE_SHARED = "shared";
    protected static final String MODE_EXCLUSIVE_CUMULATIVE = "exclusive cumulative";
    protected static final String MODE_EXCLUSIVE_NONCUMULATIVE = "exclusive non-cumulative";
    protected static final String[] ALL_LOCK_MODES = new String[]{"shared", "exclusive cumulative", "exclusive non-cumulative"};

    protected static String getDescriptionForMode(char mode) {
        if (mode == 'S') {
            return MODE_SHARED;
        }
        if (mode == 'E') {
            return MODE_EXCLUSIVE_CUMULATIVE;
        }
        if (mode == 'X') {
            return MODE_EXCLUSIVE_NONCUMULATIVE;
        }
        return null;
    }

    protected static char getModeForDescription(String mode) {
        if (MODE_SHARED.equals(mode)) {
            return 'S';
        }
        if (MODE_EXCLUSIVE_CUMULATIVE.equals(mode)) {
            return 'E';
        }
        if (MODE_EXCLUSIVE_NONCUMULATIVE.equals(mode)) {
            return 'X';
        }
        return '\u0000';
    }

    protected void displayException(Exception e) {
        String text = e instanceof LockException || e instanceof SAPIllegalArgumentException ? "Error: " + e.getMessage() : (e instanceof TechnicalLockException ? "Error: " + e.getMessage() + "\n\nSee log for details." : "Error: " + e.getMessage() + "\n\nDetails:\n" + UTIL.getStackTrace(e));
        JOptionPane.showMessageDialog(this, ComponentFactory.createTextView(text), "Error", 0);
    }

    protected void displayMessage(String title, String text) {
        JOptionPane.showMessageDialog(this, text, title, 1);
    }
}

