/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.gui;

import com.sap.engine.frame.core.locking.TimeStatisticsEntry;
import com.sap.engine.gui.SortTable;
import com.sap.engine.services.locking.gui.BasePanel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import com.sap.engine.services.locking.gui.TimeStatisticsEntryTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractDisplayTimeStatisticsPanel
extends BasePanel
implements ActionListener,
ListSelectionListener {
    private JPanel _timeStatisticsPanel;
    private SortTable _timeStatisticsTable;
    private TimeStatisticsEntryTableModel _timeStatisticsEntryTableModel = new TimeStatisticsEntryTableModel();
    private JButton _timeStatisticsRefreshButton;
    private JButton _timeStatisticsResetButton;

    public AbstractDisplayTimeStatisticsPanel() {
        this._timeStatisticsTable = ComponentFactory.createSortableTable(this._timeStatisticsEntryTableModel);
        this._timeStatisticsTable.getSelectionModel().addListSelectionListener(this);
        this._timeStatisticsEntryTableModel.setColumnModel(this._timeStatisticsTable.getColumnModel());
        this._timeStatisticsTable.getTableHeader().setReorderingAllowed(false);
        this._timeStatisticsTable.getSelectionModel().setSelectionMode(2);
        JScrollPane scrollableTable = new JScrollPane((Component)this._timeStatisticsTable, 20, 30);
        this._timeStatisticsRefreshButton = ComponentFactory.createButton("Refresh", this, "Refresh the statistics");
        this._timeStatisticsResetButton = ComponentFactory.createButton("Reset", this, "Reset the statistics");
        JPanel buttons = ComponentFactory.createHorizontalGridPanel(new JComponent[]{this._timeStatisticsRefreshButton, this._timeStatisticsResetButton});
        this._timeStatisticsPanel = ComponentFactory.createVerticalPanel(null, scrollableTable, buttons);
        this.setLayout(new BorderLayout());
        this.add((Component)this._timeStatisticsPanel, "Center");
    }

    private TimeStatisticsEntry[] getSelectedEntries() {
        if (this._timeStatisticsTable.getSelectedRowCount() == 0) {
            return new TimeStatisticsEntry[0];
        }
        int[] selectedRows = this._timeStatisticsTable.getSelectedRows();
        TimeStatisticsEntry[] allRows = this._timeStatisticsEntryTableModel.getValues();
        TimeStatisticsEntry[] result = new TimeStatisticsEntry[selectedRows.length];
        int i = 0;
        while (i < selectedRows.length) {
            result[i] = allRows[this._timeStatisticsTable.getDataIndex(selectedRows[i])];
            ++i;
        }
        return result;
    }

    public abstract TimeStatisticsEntry[] getTimeStatisticsEntries();

    public abstract void resetTimeStatistics();

    public void valueChanged(ListSelectionEvent event) {
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this._timeStatisticsRefreshButton) {
                TimeStatisticsEntry[] values = this.getTimeStatisticsEntries();
                this._timeStatisticsEntryTableModel.setValues(values);
            } else if (source == this._timeStatisticsResetButton) {
                this.resetTimeStatistics();
                TimeStatisticsEntry[] values = this.getTimeStatisticsEntries();
                this._timeStatisticsEntryTableModel.setValues(values);
            }
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }
}

