/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.command;

import com.sap.engine.services.locking.LockingApplicationFrame;
import com.sap.engine.services.locking.command.AbstractSimpleCommand;

public class UnlockCumulativeCommand
extends AbstractSimpleCommand {
    private static final String NAME = "remove_lock_completely";
    private static final String DESCRIPTION = "Removes one lock completely (sets the cumulative count to 0).";
    private static final String USAGE = "Usage: remove_lock_completely <owner> <name> <argument> <mode>\n    <owner>     The owner for which to remove the lock\n    <name>      The name of the lock\n    <argument>  The argument of the lock\n    <mode>      The mode of the lock\n                valid modes are  S = shared\n                                 E = exclusive cummulative\n                                 X = exclusive non-cummulative\n\n";
    private static final boolean[] EXEC_PARAMETERS = new boolean[]{true, true, true, true};

    public UnlockCumulativeCommand(LockingApplicationFrame lockingApplicationFrame) {
        super(lockingApplicationFrame);
    }

    public final String getName() {
        return NAME;
    }

    public final String getUsage() {
        return USAGE;
    }

    public final String getDescription() {
        return DESCRIPTION;
    }

    public final boolean[] getExecParameters() {
        return EXEC_PARAMETERS;
    }

    public final void exec(String owner, String name, String argument, char mode) throws Exception {
        this.getLockingRuntime().getAdministrativeLocking().unlockAllCumulativeCounts(owner, name, argument, mode, false);
    }
}

