/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.command;

import com.sap.engine.services.locking.exception.SAPOptionsIllegalArgumentException;
import java.util.HashMap;

public class OptionParser {
    public static char OPTION_PREFIX = (char)45;

    public static String[] parse(String[] arguments, Option[] options) throws IllegalArgumentException {
        if (arguments == null || options == null || arguments.length == 0 || options.length == 0) {
            return new String[0];
        }
        HashMap<String, Option> optionsForNames = new HashMap<String, Option>();
        int i = 0;
        while (i < options.length) {
            String[] names = options[i].getNames();
            if (names != null && names.length != 0) {
                int j = 0;
                while (j < names.length) {
                    Option existing = optionsForNames.put(names[j], options[i]);
                    if (existing != null) {
                        throw new SAPOptionsIllegalArgumentException("locking_2200", new Object[]{OPTION_PREFIX + names[j]});
                    }
                    ++j;
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < arguments.length) {
            if (arguments[i2].charAt(0) != OPTION_PREFIX) break;
            String optionName = arguments[i2].substring(1);
            Object option = optionsForNames.get(optionName);
            if (option == null) {
                throw new SAPOptionsIllegalArgumentException("locking_2201", new Object[]{OPTION_PREFIX + optionName});
            }
            if (option instanceof FlagOption) {
                ((FlagOption)option)._value = true;
            } else {
                ValueOption vo = (ValueOption)option;
                if (vo._value != null) {
                    throw new SAPOptionsIllegalArgumentException("locking_2202", new Object[]{OPTION_PREFIX + optionName});
                }
                if (++i2 == arguments.length) {
                    throw new SAPOptionsIllegalArgumentException("locking_2203", new Object[]{OPTION_PREFIX + optionName});
                }
                vo._value = arguments[i2];
            }
            ++i2;
        }
        String[] result = new String[arguments.length - i2];
        System.arraycopy(arguments, i2, result, 0, result.length);
        return result;
    }

    public static class FlagOption
    implements Option {
        private String[] _names;
        private boolean _value = false;

        public FlagOption(String[] names) {
            if (names == null || names.length == 0) {
                throw new SAPOptionsIllegalArgumentException("locking_2204");
            }
            this._names = names;
        }

        public FlagOption(String name) {
            this(new String[]{name});
        }

        public String[] getNames() {
            return this._names;
        }

        public boolean getValue() {
            return this._value;
        }
    }

    public static class ValueOption
    implements Option {
        private String[] _names;
        private String _value = null;

        public ValueOption(String[] names) {
            if (names == null || names.length == 0) {
                throw new SAPOptionsIllegalArgumentException("locking_2204");
            }
            this._names = names;
        }

        public ValueOption(String name) {
            this(new String[]{name});
        }

        public String[] getNames() {
            return this._names;
        }

        public String getValue() {
            return this._value;
        }
    }

    public static interface Option {
        public String[] getNames();
    }
}

