/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.command;

import com.sap.engine.frame.core.locking.LockEntry;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.locking.LockingApplicationFrame;
import com.sap.engine.services.locking.command.AbstractCommand;
import com.sap.engine.services.locking.command.OptionParser;
import com.sap.exception.standard.SAPIllegalArgumentException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class GetLocksCommand
extends AbstractCommand {
    private static final String NAME = "show_locks";
    private static final String DESCRIPTION = "Shows a list of all currently existing locks.";
    private static final String USAGE = "Usage: show_locks [options]\n\nwhere options include:\n    -n NAME     -name NAME            The name, for which to display the locks\n    -a ARGUMENT -argument ARGUMENT    The argument, for which to display the locks\n\n";

    public GetLocksCommand(LockingApplicationFrame lockingApplicationFrame) {
        super(lockingApplicationFrame);
    }

    public final String getName() {
        return NAME;
    }

    public final String getUsage() {
        return USAGE;
    }

    public final String getDescription() {
        return DESCRIPTION;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        OptionParser.ValueOption name = new OptionParser.ValueOption(new String[]{"n", "name"});
        OptionParser.ValueOption argument = new OptionParser.ValueOption(new String[]{"a", "argument"});
        OptionParser.Option[] options = new OptionParser.Option[]{name, argument};
        try {
            String[] remaining = OptionParser.parse(params, options);
            if (remaining.length > 0) {
                throw new SAPIllegalArgumentException("com.sap.exception.standard_0006");
            }
        }
        catch (Exception e) {
            out.println("Syntax error in command " + this.getName());
            out.println(this.getUsage());
            return;
        }
        try {
            LockEntry[] locks = this.getLockingRuntime().getAdministrativeLocking().getLocks(name.getValue(), argument.getValue());
            this.displayLocks(out, locks);
        }
        catch (Exception e) {
            this.displayException(out, e);
        }
    }

    private void displayLocks(PrintStream out, LockEntry[] locks) {
        int i = 0;
        while (i < locks.length) {
            LockEntry next = locks[i];
            out.println(next.getUser() + " | " + next.getOwner() + " | " + next.getMode() + " | " + next.getCount());
            out.println("  | " + next.getName());
            out.println("  | " + next.getArgument());
            ++i;
        }
    }
}

