/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.command;

import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.locking.LockingApplicationFrame;
import com.sap.engine.services.locking.command.AbstractCommand;
import com.sap.engine.services.locking.command.OptionParser;
import com.sap.exception.standard.SAPIllegalArgumentException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class DisplayUniqueNumberCommand
extends AbstractCommand {
    private static final String NAME = "gen_unique_number";
    private static final String DESCRIPTION = "Generates a unique increasing number. This command is mainly for test- and debugging-purposes.";
    private static final String USAGE = "Usage: gen_unique_number\n";

    public DisplayUniqueNumberCommand(LockingApplicationFrame lockingApplicationFrame) {
        super(lockingApplicationFrame);
    }

    public final String getName() {
        return NAME;
    }

    public final String getUsage() {
        return USAGE;
    }

    public final String getDescription() {
        return DESCRIPTION;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        OptionParser.Option[] options = new OptionParser.Option[]{};
        try {
            String[] remaining = OptionParser.parse(params, options);
            if (remaining.length > 0) {
                throw new SAPIllegalArgumentException("com.sap.exception.standard_0006");
            }
        }
        catch (Exception e) {
            out.println("Syntax error in command " + this.getName());
            out.println(this.getUsage());
            return;
        }
        try {
            long number = this.getLockingRuntime().getAdministrativeLocking().getUniqueIncreasingNumber();
            out.println(number);
        }
        catch (Exception e) {
            this.displayException(out, e);
        }
    }
}

