/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.command;

import com.sap.engine.frame.core.locking.TimeStatisticsEntry;
import com.sap.engine.frame.core.locking.TimeStatisticsHelper;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.locking.LockingApplicationFrame;
import com.sap.engine.services.locking.command.AbstractCommand;
import com.sap.engine.services.locking.command.OptionParser;
import com.sap.exception.standard.SAPIllegalArgumentException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class DisplayTimeStatisticsCommand
extends AbstractCommand {
    private static final TimeStatisticsHelper HELPER = new TimeStatisticsHelper();
    private static final String NAME = "show_locking_stat";
    private static final String DESCRIPTION = "Shows statistics for the performance of Locking Manager.";
    private static final String USAGE = "Usage: show_locking_stat [options]\n\nwhere options include:\n    -d -detail   For more detailed statistics\n\n";

    public DisplayTimeStatisticsCommand(LockingApplicationFrame lockingApplicationFrame) {
        super(lockingApplicationFrame);
    }

    public final String getName() {
        return NAME;
    }

    public final String getUsage() {
        return USAGE;
    }

    public final String getDescription() {
        return DESCRIPTION;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        OptionParser.FlagOption detail = new OptionParser.FlagOption(new String[]{"d", "detail"});
        OptionParser.Option[] options = new OptionParser.Option[]{detail};
        try {
            String[] remaining = OptionParser.parse(params, options);
            if (remaining.length > 0) {
                throw new SAPIllegalArgumentException("com.sap.exception.standard_0006");
            }
        }
        catch (Exception e) {
            out.println("Syntax error in command " + this.getName());
            out.println(this.getUsage());
            return;
        }
        try {
            TimeStatisticsEntry[] entries = this.getLockingRuntime().getAdministrativeLocking().getTimeStatisticsEntries();
            out.println(HELPER.formatTimeStatisticsEntry(entries, detail.getValue()));
        }
        catch (Exception e) {
            this.displayException(out, e);
        }
    }
}

