/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking.command;

import com.sap.engine.frame.core.locking.Util;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.locking.LockingApplicationFrame;
import com.sap.engine.services.locking.command.AbstractCommand;
import com.sap.exception.standard.SAPIllegalArgumentException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class AbstractSimpleCommand
extends AbstractCommand {
    private static final Util UTIL = new Util();

    public AbstractSimpleCommand(LockingApplicationFrame lockingApplicationFrame) {
        super(lockingApplicationFrame);
    }

    public abstract boolean[] getExecParameters();

    public abstract void exec(String var1, String var2, String var3, char var4) throws Exception;

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        String owner = null;
        String name = null;
        String argument = null;
        char mode = '\u0000';
        try {
            boolean[] p = this.getExecParameters();
            int pos = 0;
            if (p[0]) {
                owner = params[pos++];
            }
            if (p[1]) {
                name = params[pos++];
            }
            if (p[2]) {
                argument = params[pos++];
            }
            if (p[3]) {
                mode = UTIL.getMode(params[pos++]);
            }
            if (params.length > pos) {
                throw new SAPIllegalArgumentException("com.sap.exception.standard_0006");
            }
        }
        catch (Exception e) {
            out.println("Syntax error in command " + this.getName());
            out.println(this.getUsage());
            return;
        }
        try {
            this.exec(owner, name, argument, mode);
            out.println("... done");
        }
        catch (Exception e) {
            this.displayException(out, e);
        }
    }
}

