/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.locking;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.CommunicationServiceFrame;
import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.container.registry.ObjectRegistry;
import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.SAPLockingIllegalArgumentException;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.frame.core.locking.Util;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.locking.LockingRuntimeInterface;
import com.sap.engine.services.locking.LockingRuntimeInterfaceImpl;
import com.sap.engine.services.locking.command.DisplayTimeStatisticsCommand;
import com.sap.engine.services.locking.command.DisplayUniqueNumberCommand;
import com.sap.engine.services.locking.command.GetLocksCommand;
import com.sap.engine.services.locking.command.LockCommand;
import com.sap.engine.services.locking.command.ResetTimeStatisticsCommand;
import com.sap.engine.services.locking.command.RunTestsCommand;
import com.sap.engine.services.locking.command.UnlockAllCommand;
import com.sap.engine.services.locking.command.UnlockCommand;
import com.sap.engine.services.locking.command.UnlockCumulativeCommand;
import com.sap.engine.services.locking.test.AllTests;
import com.sap.engine.services.locking.test.ILockingContextTest;
import com.sap.engine.services.locking.test.TestResult;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;

public class LockingApplicationFrame
implements CommunicationServiceFrame,
ApplicationServiceFrame,
ContainerEventListener {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$locking$LockingApplicationFrame == null ? (class$com$sap$engine$services$locking$LockingApplicationFrame = LockingApplicationFrame.class$("com.sap.engine.services.locking.LockingApplicationFrame")) : class$com$sap$engine$services$locking$LockingApplicationFrame));
    private static final Category CATEGORY = LoggingHelper.SYS_SERVER;
    private static final String JNDI_SERVICE_NAME = "naming";
    private static final String OWN_NAME = "Locking service";
    private static final String PROPERTY_TESTLEVEL = "testlevel";
    private static final Util UTIL = new Util();
    private ServiceContext _serviceContext;
    LockingContext _lockingContext;
    private ObjectRegistry _objectRegistry;
    private ThreadSystem _threadSystem;
    private LockingRuntimeInterface _lockingRuntimeInterface;
    private ShellInterface _shellInterface;
    private int _commandId;
    private int _testlevel;
    static /* synthetic */ Class class$com$sap$engine$services$locking$LockingApplicationFrame;

    public LockingRuntimeInterface getRuntimeInterface() {
        return this._lockingRuntimeInterface;
    }

    public ThreadSystem getThreadSystem() {
        return this._threadSystem;
    }

    public void start(CommunicationServiceContext serviceContext) throws ServiceException {
        String METHOD = "start(communicationServiceContext)";
        this._serviceContext = serviceContext;
        try {
            this._objectRegistry = serviceContext.getContainerContext().getObjectRegistry();
            this._threadSystem = serviceContext.getCoreContext().getThreadSystem();
            this._lockingContext = serviceContext.getCoreContext().getLockingContext();
            this._lockingRuntimeInterface = new LockingRuntimeInterfaceImpl(this, this._lockingContext);
            this.startIndependent();
        }
        catch (Exception e) {
            CATEGORY.fatalT(LOCATION, METHOD, "{0} can not start. {0} cannot be used to adminstrate locks. Please try to start the service manually.", new Object[]{OWN_NAME});
            LoggingHelper.logThrowable(500, CATEGORY, LOCATION, METHOD, e);
            try {
                this.stop();
            }
            catch (Exception x) {
                // empty catch block
            }
            throw new ServiceException("kernel_6000", new Object[]{OWN_NAME}, null);
        }
    }

    public void start(ApplicationServiceContext serviceContext) throws ServiceException {
        String METHOD = "start(applicationServiceContext)";
        this._serviceContext = serviceContext;
        try {
            this._objectRegistry = serviceContext.getContainerContext().getObjectRegistry();
            this._threadSystem = serviceContext.getCoreContext().getThreadSystem();
            this._lockingContext = serviceContext.getCoreContext().getLockingContext();
            this._lockingRuntimeInterface = new LockingRuntimeInterfaceImpl(this, this._lockingContext);
            this.startIndependent();
        }
        catch (Exception e) {
            CATEGORY.fatalT(LOCATION, METHOD, "{0} can not start. {0} cannot be used to adminstrate locks. Please try to start the service manually.", new Object[]{OWN_NAME});
            LoggingHelper.logThrowable(500, CATEGORY, LOCATION, METHOD, e);
            try {
                this.stop();
            }
            catch (Exception x) {
                // empty catch block
            }
            throw new ServiceException("kernel_6000", new Object[]{OWN_NAME}, null);
        }
    }

    public void stop() throws ServiceRuntimeException {
        String METHOD = "stop()";
        try {
            LOCATION.pathT(METHOD, "begin");
            this._objectRegistry.unregisterInterface();
            this._serviceContext.getServiceState().unregisterContainerEventListener();
            this.unsetShellInterface();
            LOCATION.pathT(METHOD, "success");
        }
        catch (Exception e) {
            CATEGORY.errorT(LOCATION, METHOD, "can not cleanup {0} correctly when trying to stop it", new Object[]{OWN_NAME});
            LoggingHelper.logThrowable(500, CATEGORY, LOCATION, METHOD, e);
            throw new ServiceRuntimeException("kernel_6050", new Object[]{OWN_NAME}, null);
        }
        CATEGORY.infoT(LOCATION, METHOD, "{0} stopped successfully", new Object[]{OWN_NAME});
    }

    public void containerStarted() {
    }

    public void beginContainerStop() {
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
    }

    public void serviceStopped(String serviceName) {
    }

    public boolean setServiceProperty(String key, String value) {
        Properties currentProperties = this._serviceContext.getServiceState().getProperties();
        Properties properties = (Properties)((Hashtable)currentProperties).clone();
        ((Hashtable)properties).put(key, value);
        return this.parseProperties(properties);
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        return this.parseProperties(serviceProperties);
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        String METHOD = "interfaceAvailable(interfaceName, interfaceImpl)";
        LOCATION.pathT(METHOD, "interfaceName={0}", new Object[]{interfaceName});
        if (interfaceName.equals("shell")) {
            this.setShellInterface((ShellInterface)interfaceImpl);
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        String METHOD = "interfaceNotAvailable(interfaceName)";
        LOCATION.pathT(METHOD, "interfaceName={0}", new Object[]{interfaceName});
        if (interfaceName.equals("shell")) {
            this.unsetShellInterface();
        }
    }

    public void markForShutdown(long timeout) {
    }

    private void setShellInterface(ShellInterface shellInterface) {
        String METHOD = "setShellInterface(shellInterface)";
        LOCATION.pathT(METHOD, "begin");
        this._shellInterface = shellInterface;
        Command[] shellcommands = new Command[]{new LockCommand(this), new UnlockCommand(this), new UnlockCumulativeCommand(this), new UnlockAllCommand(this), new GetLocksCommand(this), new DisplayTimeStatisticsCommand(this), new ResetTimeStatisticsCommand(this), new RunTestsCommand(this), new DisplayUniqueNumberCommand(this)};
        this._commandId = this._shellInterface.registerCommands(shellcommands);
        LOCATION.pathT(METHOD, "success");
    }

    private void unsetShellInterface() {
        String METHOD = "unsetShellInterface()";
        LOCATION.pathT(METHOD, "begin");
        if (this._shellInterface != null) {
            this._shellInterface.unregisterCommands(this._commandId);
        }
        this._shellInterface = null;
        LOCATION.pathT(METHOD, "success");
    }

    private void runTests(int testlevel) throws Exception {
        String METHOD = "runTests(testlevel)";
        LOCATION.pathT(METHOD, "testlevel={0}", new Object[]{new Integer(testlevel)});
        if (testlevel <= 0) {
            return;
        }
        long start = System.currentTimeMillis();
        if (testlevel >= 2) {
            this.runLockingContextTests(AllTests.getAllLockingContextTests());
        } else {
            this.runLockingContextTests(AllTests.getFunctionalLockingContextTests());
        }
        long end = System.currentTimeMillis();
        CATEGORY.infoT(LOCATION, METHOD, "All tests finished successfully ({0} milliseconds)", new Object[]{new Long(end - start)});
    }

    private void runLockingContextTests(ILockingContextTest[] test2) throws Exception {
        String METHOD = "runLockingContextTests(test)";
        CATEGORY.infoT(LOCATION, METHOD, "Start execution of {0} tests", new Object[]{new Integer(test2.length)});
        AdministrativeLocking administrativeLocking = this._lockingRuntimeInterface.getAdministrativeLocking();
        int i = 0;
        while (i < test2.length) {
            LOCATION.pathT(METHOD, "start test {0}", new Object[]{test2[i]});
            TestResult result = test2[i].start(this._threadSystem, administrativeLocking, null);
            if (result.getException() != null) {
                CATEGORY.errorT(LOCATION, METHOD, result.getLog());
                throw new TechnicalLockException("kernel_1026", new Object[]{new Integer(i), test2[i].getName()}, result.getException());
            }
            LOCATION.pathT(METHOD, "Test {0} finished successfully", new Object[]{test2[i].getName()});
            LOCATION.pathT(METHOD, result.getLog());
            ++i;
        }
    }

    private boolean parseProperties(Properties properties) throws IllegalArgumentException {
        String METHOD = "changeProperties(properties)";
        try {
            boolean propertiesActiveWithoutRestart = true;
            LOCATION.debugT(METHOD, "properties={0}", new Object[]{properties});
            LOCATION.pathT(METHOD, "begin");
            this._testlevel = UTIL.getIntegerProperty(properties, PROPERTY_TESTLEVEL, 0, Integer.MAX_VALUE, false);
            CATEGORY.infoT(LOCATION, METHOD, "Properties of {0} changed successfully", new Object[]{OWN_NAME});
            return propertiesActiveWithoutRestart;
        }
        catch (Exception e) {
            SAPLockingIllegalArgumentException wrappedException = new SAPLockingIllegalArgumentException("kernel_1059", new Object[]{OWN_NAME, e.toString()});
            LoggingHelper.logThrowable(500, CATEGORY, LOCATION, METHOD, (Throwable)((Object)wrappedException));
            throw wrappedException;
        }
    }

    private void startIndependent() throws Exception {
        String METHOD = "startIndependent()";
        Properties properties = this._serviceContext.getServiceState().getProperties();
        this.parseProperties(properties);
        LOCATION.pathT(METHOD, "begin");
        int mask = 192;
        HashSet<String> names = new HashSet<String>(1);
        names.add("shell");
        this._serviceContext.getServiceState().registerContainerEventListener(mask, names, this);
        this._objectRegistry.registerInterface(this._lockingRuntimeInterface);
        this._serviceContext.getServiceState().registerManagementInterface(this._lockingRuntimeInterface);
        LOCATION.pathT(METHOD, "registered in server");
        CATEGORY.infoT(LOCATION, METHOD, "{0} started successfully", new Object[]{OWN_NAME});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

