/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.server.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.keystore.interfaces.KeyStoreProvider;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class Write
implements Command {
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream errorStream = new PrintStream(env.getErrorStream());
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length > 0 && (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help"))) {
            pw.println(this.getHelpMessage());
            return;
        }
        if (params.length != 4) {
            pw.println(this.getHelpMessage());
            return;
        }
        try {
            KeyStore keystore = KeyStoreProvider.getKeyStore(params[0]);
            File f = new File(params[3]);
            RandomAccessFile raf = new RandomAccessFile(f, "rw");
            if (params[1].equals("-key")) {
                raf.write(keystore.getKey(params[2], null).toString().getBytes());
            } else if (params[1].equals("-certificate")) {
                raf.write(keystore.getCertificate(params[2]).toString().getBytes());
            } else if (params[1].equals("-chain")) {
                Certificate[] cert = keystore.getCertificateChain(params[2]);
                int i = 0;
                while (i < cert.length) {
                    raf.write((((X509Certificate)cert[i]).toString() + "\r\n").getBytes());
                    ++i;
                }
            } else {
                pw.println(this.getHelpMessage());
            }
            raf.close();
        }
        catch (Exception e) {
            errorStream.println(e.getMessage());
        }
    }

    public String getName() {
        return "WRITE";
    }

    public String getGroup() {
        return "keystore";
    }

    public String getHelpMessage() {
        return "Stores a keystore entry with the specified alias from the keystore view to a specified file.\nUsage: " + this.getName() + " <viewAlias> <entryType> <alias> <fileName>\nParameters:\n       " + "<viewAlias> - The name of the view to check.\n       " + "<entryType> - The type of the entry to store:\n              " + "-key         - Stores a key entry.\n              " + "-certificate - Stores a certificate entry.\n              " + "-chain       - Stores a certificate chain.\n       " + "<alias>     - The name to store the entry under.\n       " + "<fileName>  - The full path and name of the file to store the entry in.\n";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

