/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.patch;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.interfaces.security.AuthorizationContext;
import com.sap.engine.interfaces.security.ResourceContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.SecurityRoleContext;
import com.sap.engine.interfaces.security.resource.ResourceAccessControlHandle;
import com.sap.engine.interfaces.security.resource.ResourceHandle;
import com.sap.engine.services.keystore.exceptions.KeystoreResourceAccessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Patch {
    SecurityContext context = null;
    SecurityContext securityContext = null;
    AuthorizationContext authContext = null;
    ResourceContext resourceContext = null;
    SecurityRoleContext roleContext = null;
    ConfigurationHandlerFactory configurationHandlerFactory = null;
    static final int MAX_ATTEMPTS = 1000;
    static final String PATCH_VERSION_ENTRY_NAME = "PatchVersion";
    int currentVersion = -1;
    static final int NEW_VERSION = 1;
    static final int NOT_PATCHED = -1;
    public static final int EMPTY_DB = -2;
    static final int PATCHED = -3;
    String workDir = null;
    boolean isInitialized = true;
    private static final String PATCH_PROBLEM = "patch_problem";

    public Patch(SecurityContext context, ConfigurationHandlerFactory configurationHandlerFactory, String workDir) throws Exception {
        try {
            this.securityContext = context;
            this.configurationHandlerFactory = configurationHandlerFactory;
            this.authContext = this.securityContext.getAuthorizationContext();
            this.resourceContext = this.authContext.getSecurityResourceContext();
            this.roleContext = this.authContext.getSecurityRoleContext();
            this.workDir = workDir;
        }
        catch (Exception e) {
            this.logError(" Security context are not available!", e);
            throw e;
        }
        try {
            this.logNotice("Patch  {");
            try {
                FileInputStream fis = new FileInputStream(workDir + File.separator + "version.bin");
                this.currentVersion = fis.read();
                fis.close();
            }
            catch (Exception e) {
                this.currentVersion = this.readCurrentPatchStatus();
            }
            if (this.currentVersion == -2) {
                this.isInitialized = false;
                this.createPatchLevelEntry();
            } else {
                if (this.currentVersion == 1) {
                    this.logNotice("Patch  } OK - version is the latest");
                    return;
                }
                this.execPatch();
                this.writeNewPatchVersion(1);
            }
            this.logNotice("Patch  } OK");
        }
        catch (Exception e) {
            this.logError("Patch  } Error", e);
            throw e;
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int readCurrentPatchStatus() throws Exception {
        int ne222;
        ConfigurationHandler handler;
        block10: {
            int ne222;
            block9: {
                int ne222;
                block8: {
                    handler = null;
                    Configuration rootCfg = null;
                    int result = -1;
                    try {
                        try {
                            handler = this.getHandler();
                            try {
                                rootCfg = handler.openConfiguration("keystore", 0);
                            }
                            catch (NameNotFoundException ne222) {
                                this.logNotice(" PatchStatus - empty DB");
                                int n = -2;
                                Object var7_10 = null;
                                this.close(handler);
                                return n;
                            }
                            if (rootCfg.existsConfigEntry(PATCH_VERSION_ENTRY_NAME)) {
                                result = Integer.parseInt((String)rootCfg.getConfigEntry(PATCH_VERSION_ENTRY_NAME));
                                if (result == 1) {
                                    this.logNotice(" PatchStatus - version is up to date");
                                    ne222 = -3;
                                    Object var7_11 = null;
                                    break block8;
                                }
                                this.logNotice(" PatchStatus - minor version found - patching ... ");
                                ne222 = result;
                                break block9;
                            }
                            this.logNotice(" PatchStatus - version record not found - patching ...  ");
                            ne222 = 0;
                            break block10;
                        }
                        catch (Exception e) {
                            this.logError("readCurrentPatchVersion():", e);
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_14 = null;
                        this.close(handler);
                        throw throwable;
                    }
                }
                this.close(handler);
                return ne222;
            }
            Object var7_12 = null;
            this.close(handler);
            return ne222;
        }
        Object var7_13 = null;
        this.close(handler);
        return ne222;
    }

    void writeNewPatchVersion(int i) throws Exception {
        ConfigurationHandler handler = null;
        Configuration rootCfg = null;
        try {
            try {
                handler = this.getHandler();
                rootCfg = this.getWriteConfiguration(handler, new String[]{"keystore"});
                if (!rootCfg.existsConfigEntry(PATCH_VERSION_ENTRY_NAME)) {
                    rootCfg.addConfigEntry(PATCH_VERSION_ENTRY_NAME, Integer.toString(i));
                } else {
                    rootCfg.modifyConfigEntry(PATCH_VERSION_ENTRY_NAME, Integer.toString(i));
                }
                this.commit(handler);
                this.logNotice("NewPatchVersion = " + i);
            }
            catch (Exception e) {
                this.logError("writeNewPatchVersion(" + i + "):", e);
                throw e;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
        try {
            File file = new File(this.workDir + File.separator + "version.bin");
            file.delete();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(i);
            fos.close();
        }
        catch (Exception e) {
            this.logError("save new version file failed", e);
        }
    }

    void createPatchLevelEntry() throws Exception {
        ConfigurationHandler handler = null;
        Configuration rootCfg = null;
        try {
            try {
                handler = this.getHandler();
                rootCfg = handler.createRootConfiguration("keystore");
                rootCfg.addConfigEntry(PATCH_VERSION_ENTRY_NAME, Integer.toString(1));
                this.logNotice("Set initial PatchLevel entry = 1");
                this.commit(handler);
            }
            catch (Exception e) {
                this.logError("Cannot create the PatchLevel config entry:", e);
                throw e;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
        try {
            File file = new File(this.workDir + File.separator + "version.bin");
            file.delete();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(1);
            fos.close();
        }
        catch (Exception e) {
            this.logError("save new version file failed", e);
        }
    }

    private void execPatch() throws Exception {
        this.logNotice(" found version: " + this.currentVersion);
        if (this.currentVersion == 1) {
            this.logNotice(" Version is the latest - no need for patching!");
        }
        switch (this.currentVersion) {
            case 0: {
                this.update_0_to_1();
            }
        }
    }

    private static String[] getNewResourceName(String oldResourceName) {
        String[] name_parts = Patch.parseName(oldResourceName);
        String[] result = new String[2];
        if (name_parts.length == 1) {
            result[0] = "SAP-J2EE-Engine";
            result[1] = "keystore-views";
        } else {
            result[0] = "keystore-view." + name_parts[1];
            if (name_parts[0].equals("entries_of_view:")) {
                result[1] = "entry-actions";
            } else if (name_parts[0].equals("properties_of_view:")) {
                result[1] = "property-actions";
            } else if (name_parts[0].equals("views:")) {
                result[1] = "view-actions";
            }
        }
        return result;
    }

    private void resources_processing() throws Exception {
        this.logNotice("resource_processing {");
        if (this.securityContext.getPolicyConfigurationContext("service.keystore") == null) {
            return;
        }
        ResourceContext oldKeystoreResources = this.securityContext.getPolicyConfigurationContext("service.keystore").getAuthorizationContext().getSecurityResourceContext();
        String[] oldResourceAliases = oldKeystoreResources.getResourceAliases();
        String oldPolicyCfgName = "service.keystore";
        String newPolicyCfgName = null;
        int i = 0;
        while (i < oldResourceAliases.length) {
            this.logNotice("  old_resource : [" + oldResourceAliases[i] + "]");
            String oldResourceName = oldResourceAliases[i];
            String[] fullNewResourceName = Patch.getNewResourceName(oldResourceName);
            this.logNotice("[" + oldResourceName + "] -> [" + fullNewResourceName[0] + ", " + fullNewResourceName[1] + "]");
            newPolicyCfgName = fullNewResourceName[0];
            String newResourceName = fullNewResourceName[1];
            this.logNotice("  new_policy   : [" + newPolicyCfgName + "]");
            this.logNotice("  new_resource : [" + newResourceName + "]");
            this.copyResource(oldPolicyCfgName, oldResourceName, newPolicyCfgName, newResourceName);
            ++i;
        }
        this.logNotice("resource_processing } OK");
    }

    private void copyResource(String oldPolicyContextName, String oldResourceName, String newPolicyCfgName, String newResourceName) throws Exception {
        ResourceContext oldResources = this.securityContext.getPolicyConfigurationContext(oldPolicyContextName).getAuthorizationContext().getSecurityResourceContext();
        ResourceContext newResources = this.getViewPolicyContext(newPolicyCfgName).getAuthorizationContext().getSecurityResourceContext();
        ResourceHandle oldResourceHandle = oldResources.getResourceHandle(oldResourceName);
        ResourceHandle newResourceHandle = newResources.getResourceHandle(newResourceName);
        if (newResourceHandle == null) {
            newResources.createResource(newResourceName);
            newResourceHandle = newResources.getResourceHandle(newResourceName);
        }
        String[] actions = oldResourceHandle.getActions();
        String[] instances = oldResourceHandle.getInstances();
        this.logNotice("  actions {");
        int j = 0;
        while (j < actions.length) {
            if (!actions[j].equals("ALL")) {
                newResourceHandle.createAction(actions[j]);
                this.logNotice("    : " + actions[j]);
            }
            ++j;
        }
        this.logNotice("  }");
        this.logNotice("  instances {");
        int k = 0;
        while (k < instances.length) {
            if (!instances[k].equals("ALL")) {
                newResourceHandle.createInstance(instances[k]);
                this.logNotice("   : " + instances[k]);
            }
            ++k;
        }
        this.logNotice("  }");
        this.logNotice("  instance_tree copy { ");
        Object[] parents = new String[]{"ALL"};
        Vector<String> newParents = new Vector<String>();
        String[] children = null;
        do {
            newParents.clear();
            int j2 = 0;
            while (j2 < parents.length) {
                String parentInstance = parents[j2].toString();
                children = oldResourceHandle.getChildren(parentInstance);
                int k2 = 0;
                while (k2 < children.length) {
                    String childInstance = children[k2].toString();
                    newParents.add(childInstance);
                    newResourceHandle.groupInstance(childInstance, parentInstance);
                    this.logNotice("    linked [" + parentInstance + " <-- " + childInstance + "]");
                    ++k2;
                }
                ++j2;
            }
        } while ((parents = newParents.toArray()).length > 0);
        this.logNotice("  }");
    }

    private void roles_processing() throws Exception {
        if (this.securityContext.getPolicyConfigurationContext("service.keystore") == null) {
            return;
        }
        this.logNotice("roles_processing {");
        Hashtable<String, String> flag = new Hashtable<String, String>();
        SecurityContext oldKeystoreContext = this.securityContext.getPolicyConfigurationContext("service.keystore");
        SecurityRoleContext oldKeystoreRoles = oldKeystoreContext.getAuthorizationContext().getSecurityRoleContext();
        SecurityRole oldKSAdmin = oldKeystoreRoles.getSecurityRole("KEYSTORE_ADMINISTRATOR");
        this.create_role("SAP-J2EE-Engine", "KeystoreAdministrator", false, null, null, oldKSAdmin.getGroups(), oldKSAdmin.getUsers(), "Used from Keystore provider system role - the users from this role have all user based security permissions!");
        SecurityRole newKSAdmin = this.securityContext.getPolicyConfigurationContext("SAP-J2EE-Engine").getAuthorizationContext().getSecurityRoleContext().getSecurityRole("KeystoreAdministrator");
        this.create_role("SAP-J2EE-Engine", "KeystoreViewsCreator", false, null, null, oldKSAdmin.getGroups(), oldKSAdmin.getUsers(), "Used from Keystore provider system role - the users from this role have user based security permission to create a new views!");
        SecurityRole[] oldRoles = oldKeystoreRoles.listSecurityRoles();
        int i = 0;
        while (i < oldRoles.length) {
            String oldRoleName = oldRoles[i].getName();
            this.logNotice("  >>>>>>>>>>> role: " + oldRoleName + "");
            String[] newSystemRoleFullName = Patch.getNewSystemRole(oldRoleName);
            if (newSystemRoleFullName == null) {
                this.logNotice("    [undefined view]");
            } else {
                String new_policy_cfg_name = newSystemRoleFullName[0];
                String newSystemRoleName = newSystemRoleFullName[1];
                if (flag.get(new_policy_cfg_name) == null) {
                    this.logNotice("    [INIT_global_roles] for view: " + new_policy_cfg_name);
                    flag.put(new_policy_cfg_name, "");
                    SecurityRole refAdmins = this.securityContext.getAuthorizationContext().getSecurityRoleContext().getSecurityRole("administrators");
                    this.create_role(new_policy_cfg_name, newKSAdmin.getName(), true, "SAP-J2EE-Engine", newKSAdmin.getName(), null, null, newKSAdmin.getDescription());
                    this.create_role(new_policy_cfg_name, "ReferenceAdministrators", true, "SAP-J2EE-Engine", "administrators", refAdmins.getGroups(), refAdmins.getUsers(), refAdmins.getDescription());
                }
                this.create_role(new_policy_cfg_name, newSystemRoleName, newSystemRoleFullName[2].equals("is_reference"), newSystemRoleFullName[3], newSystemRoleFullName[4], oldRoles[i].getGroups(), oldRoles[i].getUsers(), "");
            }
            ++i;
        }
        this.logNotice("roles_processing } OK");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] getNewSystemRole(String oldRoleName) {
        String[] name_parts = Patch.parseName(oldRoleName);
        String[] result = new String[5];
        if (name_parts.length == 1) {
            if (!oldRoleName.equals("find_alias")) return null;
            result[0] = "keystore-view.DBMS_User_Store";
            result[1] = oldRoleName;
            result[2] = "is_reference";
            result[3] = "SAP-J2EE-Engine";
            result[4] = "all";
            return result;
        } else {
            result[0] = "keystore-view." + name_parts[1];
            if (name_parts[0].equals("ENTRY_CREATOR:")) {
                result[1] = "entry-creator." + name_parts[2];
            } else if (name_parts[0].equals("PROPERTY_CREATOR:")) {
                result[1] = "property-creator." + name_parts[2];
            } else if (name_parts[0].equals("VIEW_CREATOR:")) {
                result[1] = "view-creator";
            }
            result[2] = "not_reference";
        }
        return result;
    }

    private void create_role(String policy_cfg_name, String role_name, boolean isReference, String ref_policy_name, String ref_role_name, String[] granted_groups, String[] granted_users, String description) throws Exception {
        this.logNotice("      create_role { " + role_name);
        SecurityRoleContext targetRoleContext = this.getViewPolicyContext(policy_cfg_name).getAuthorizationContext().getSecurityRoleContext();
        if (targetRoleContext.getSecurityRole(role_name) != null) {
            this.logNotice("      } RoleExists !!!");
            return;
        }
        if (isReference) {
            targetRoleContext.addSecurityRoleReference(role_name, ref_policy_name, ref_role_name);
            this.logNotice("          added_role_refence [" + policy_cfg_name + ", " + role_name + "] to [" + ref_policy_name + ", " + ref_role_name + "]");
        } else {
            targetRoleContext.addSecurityRole(role_name);
            this.logNotice("         added_role         [" + policy_cfg_name + ", " + role_name + "]");
            SecurityRole newRole = targetRoleContext.getSecurityRole(role_name);
            int i = 0;
            while (i < granted_groups.length) {
                this.logNotice("          <- group " + granted_groups[i]);
                newRole.addGroup(granted_groups[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < granted_users.length) {
                this.logNotice("          <- user " + granted_users[i2]);
                newRole.addUser(granted_users[i2]);
                ++i2;
            }
            newRole.setDescription(description);
        }
        this.logNotice("      }");
    }

    private void permissions_processing() throws Exception {
        if (this.securityContext.getPolicyConfigurationContext("service.keystore") == null) {
            return;
        }
        this.logNotice("\npermissions_processing {");
        ResourceContext oldResourceContext = this.securityContext.getPolicyConfigurationContext("service.keystore").getAuthorizationContext().getSecurityResourceContext();
        SecurityRoleContext oldRoleContext = this.securityContext.getPolicyConfigurationContext("service.keystore").getAuthorizationContext().getSecurityRoleContext();
        String[] resourceAliases = oldResourceContext.getResourceAliases();
        int i = 0;
        while (i < resourceAliases.length) {
            String oldResourceName = resourceAliases[i];
            this.copy_resource_permissions(oldResourceName, oldResourceContext, oldRoleContext);
            ++i;
        }
        this.logNotice(" }");
    }

    private void copy_resource_permissions(String oldResourceName, ResourceContext oldResourceContext, SecurityRoleContext oldRoleContext) throws Exception {
        this.logNotice("  copy_resource_permissions {");
        this.logNotice("    old -> [" + oldResourceName + "]");
        String[] oldResourceActions = oldResourceContext.getResourceHandle(oldResourceName).getActions();
        String[] oldResourceInstances = oldResourceContext.getResourceHandle(oldResourceName).getInstances();
        ResourceAccessControlHandle old_acl_handle = oldResourceContext.getResourceAccessControlHandle(oldResourceName);
        String[] fullNewResourceName = Patch.getNewResourceName(oldResourceName);
        String newPolicyCfgName = fullNewResourceName[0];
        String newResourceName = fullNewResourceName[1];
        ResourceContext newResourceContext = this.getViewPolicyContext(newPolicyCfgName).getAuthorizationContext().getSecurityResourceContext();
        ResourceAccessControlHandle new_acl_handle = newResourceContext.getResourceAccessControlHandle(newResourceName);
        if (oldResourceName.equals("views:")) {
            this.logNotice("   views -> KeystoreViewCreator role :::::::::::::::::::::::::::::::");
            new_acl_handle.grantSecurityRole("KeystoreViewsCreator", "ALL", "ALL");
        } else {
            new_acl_handle.grantSecurityRole("ReferenceAdministrators", "ALL", "ALL");
        }
        new_acl_handle.grantSecurityRole("KeystoreAdministrator", "ALL", "ALL");
        this.logNotice("    new -> [" + newPolicyCfgName + ", " + newResourceName + "]");
        int j = 0;
        while (j < oldResourceInstances.length) {
            String instance = oldResourceInstances[j];
            int k = 0;
            while (k < oldResourceActions.length) {
                String action = oldResourceActions[k];
                String[] grantedRoles = old_acl_handle.listGrantedSecurityRoles(action, instance);
                String[] deniedRoles = old_acl_handle.listDeniedSecurityRoles(action, instance);
                int l = 0;
                while (l < grantedRoles.length) {
                    String oldRoleName = grantedRoles[l];
                    this.copy_acl_permissions(oldRoleName, oldRoleContext, newPolicyCfgName, new_acl_handle, action, instance, true);
                    ++l;
                }
                int l2 = 0;
                while (l2 < deniedRoles.length) {
                    String oldRoleName = deniedRoles[l2];
                    this.copy_acl_permissions(oldRoleName, oldRoleContext, newPolicyCfgName, new_acl_handle, action, instance, false);
                    ++l2;
                }
                ++k;
            }
            ++j;
        }
        this.logNotice("  }");
    }

    private void copy_acl_permissions(String oldRoleName, SecurityRoleContext oldRoleContext, String newPolicyCfgName, ResourceAccessControlHandle new_acl_handle, String action, String instance, boolean shouldGrant) throws Exception {
        if (oldRoleName.equals("KEYSTORE_ADMINISTRATOR") || oldRoleName.equals("REFERENCE_ADMINISTRATORS")) {
            return;
        }
        String[] newRoleFullName = Patch.getNewSystemRole(oldRoleName);
        String newRoleName = null;
        if (newRoleFullName == null) {
            this.logNotice("      not_system_role [" + oldRoleName + "]");
            SecurityRole oldRole = oldRoleContext.getSecurityRole(oldRoleName);
            this.create_role(newPolicyCfgName, oldRoleName, false, null, null, oldRole.getGroups(), oldRole.getUsers(), oldRole.getDescription());
            newRoleName = oldRoleName;
        } else {
            this.logNotice("      system_role [" + newRoleFullName[1] + "]");
            newRoleName = newRoleFullName[1];
        }
        if (shouldGrant) {
            new_acl_handle.grantSecurityRole(newRoleName, action, instance);
            this.logNotice("     ++ [" + newRoleName + ", " + action + ", " + instance + "]");
        } else {
            this.logNotice("     ---- [" + newRoleName + ", " + action + ", " + instance + "]");
            new_acl_handle.denySecurityRole(newRoleName, action, instance);
        }
    }

    private void update_0_to_1() throws Exception {
        this.logNotice(" Patching: Level[0] -> Level[1] { ");
        this.resources_processing();
        this.roles_processing();
        this.permissions_processing();
        this.securityContext.unregisterPolicyConfiguration("service.keystore");
        this.logNotice(" Patching: Level[0] -> Level[1] } OK ");
    }

    private static String[] parseName(String alias) {
        StringTokenizer tokenizer = new StringTokenizer(alias, ".", false);
        String[] result = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = tokenizer.nextToken();
            ++i;
        }
        return result;
    }

    private void update_1_to_2() throws Exception {
        try {
            this.logNotice("Patch ver[1] -> [2] OK ");
        }
        catch (Exception e) {
            this.logError("Patch ver[1] -> [2] failed!", e);
            throw e;
        }
    }

    private ConfigurationHandler getHandler() throws Exception {
        try {
            return this.configurationHandlerFactory.getConfigurationHandler();
        }
        catch (Exception e) {
            throw new Exception("Cannot get a handler: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SecurityContext getViewPolicyContext(String policyConfigurationName) throws Exception {
        SecurityContext securityContext;
        if (policyConfigurationName.equals("SAP-J2EE-Engine")) {
            return this.securityContext;
        }
        SecurityContext result = this.securityContext.getPolicyConfigurationContext(policyConfigurationName);
        if (result != null) {
            this.logNotice("   [existing Policy CFG]: " + policyConfigurationName);
            return result;
        }
        ConfigurationHandler handler = null;
        Configuration policy_cfg = null;
        try {
            try {
                handler = this.getHandler();
                policy_cfg = this.ensureWriteConfiguration(handler, new String[]{"keystore", "$$$user-based-security-root$$$", policyConfigurationName});
                this.securityContext.getModificationContext().beginModifications(policy_cfg).registerPolicyConfiguration(policyConfigurationName);
                this.commit(handler);
                result = this.securityContext.getPolicyConfigurationContext(policyConfigurationName);
                this.logNotice("   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!![new Policy CFG]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!: " + policy_cfg);
                securityContext = result;
                Object var7_7 = null;
            }
            catch (Exception e) {
                this.logError("getViewPolicyContext", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
        return securityContext;
    }

    private Configuration getWriteConfiguration(ConfigurationHandler handler, String[] path) throws Exception {
        try {
            int counter = 0;
            ConfigurationLockedException temp = null;
            Configuration result = null;
            while (counter++ <= 1000) {
                int i = 0;
                try {
                    result = handler.openConfiguration(path[0], 1);
                    i = 1;
                    while (i < path.length) {
                        result = result.getSubConfiguration(path[i]);
                        ++i;
                    }
                    return result;
                }
                catch (ConfigurationLockedException _) {
                    temp = _;
                    try {
                        Patch patch = this;
                        synchronized (patch) {
                            this.wait(100L);
                        }
                    }
                    catch (InterruptedException __) {}
                }
                catch (NameNotFoundException ne) {
                    throw ne;
                }
            }
            throw new RuntimeException("Cannot get root configuration: " + temp.getMessage());
        }
        catch (RuntimeException re) {
            throw new Exception(re.getMessage());
        }
        catch (Exception e) {
            throw new Exception("Unexpected: " + e.getMessage());
        }
    }

    private Configuration ensureWriteConfiguration(ConfigurationHandler handler, String[] path) throws Exception {
        try {
            int counter = 0;
            ConfigurationLockedException temp = null;
            Configuration result = null;
            while (counter++ <= 1000) {
                int i = 0;
                try {
                    try {
                        result = handler.openConfiguration(path[0], 1);
                    }
                    catch (NameNotFoundException ne) {
                        result = handler.createRootConfiguration(path[0]);
                    }
                    i = 1;
                    while (i < path.length) {
                        try {
                            result = result.getSubConfiguration(path[i]);
                        }
                        catch (NameNotFoundException ne) {
                            result = result.createSubConfiguration(path[i]);
                        }
                        ++i;
                    }
                    return result;
                }
                catch (ConfigurationLockedException _) {
                    temp = _;
                    try {
                        Patch patch = this;
                        synchronized (patch) {
                            this.wait(100L);
                        }
                    }
                    catch (InterruptedException __) {}
                }
                catch (NameNotFoundException ne) {
                    throw ne;
                }
            }
            throw new RuntimeException("Cannot ensure a configuration: " + temp.getMessage());
        }
        catch (RuntimeException re) {
            throw new Exception(re.getMessage());
        }
        catch (Exception e) {
            throw new Exception("Unexpected: " + e.getMessage());
        }
    }

    private void commit(ConfigurationHandler handler) throws Exception {
        if (handler != null) {
            try {
                handler.commit();
            }
            catch (Exception _) {
                throw new Exception("Cannot commit a handler: " + _.getMessage());
            }
        }
    }

    private void close(ConfigurationHandler handler) throws Exception {
        if (handler != null) {
            try {
                handler.rollback();
            }
            catch (Exception _) {
                this.logNotice("Non Fatal Warning: rollback handler at close: " + _);
            }
            try {
                handler.closeAllConfigurations();
            }
            catch (Exception _) {
                throw new Exception("Cannot close all configurations: " + _.getMessage());
            }
        }
    }

    void logNotice(String msg) {
        KeystoreResourceAccessor.trace(300, msg);
    }

    void logError(String msg) {
        KeystoreResourceAccessor.log(500, msg, PATCH_PROBLEM);
        KeystoreResourceAccessor.trace(500, msg);
    }

    void logNotice(String msg, Throwable t) {
        KeystoreResourceAccessor.traceThrowable(300, msg, t);
    }

    void logError(String msg, Throwable t) {
        KeystoreResourceAccessor.log(600, msg, PATCH_PROBLEM);
        KeystoreResourceAccessor.traceThrowable(600, msg, t);
    }
}

