/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.interfaces;

import com.sap.engine.services.keystore.interfaces.KeyStoreConstants;
import com.sap.engine.services.keystore.spi.EBSDKSKeyStoreSpiImpl;
import iaik.security.provider.IAIK;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;

public class KeyStoreProvider
extends Provider
implements KeyStoreConstants {
    private static final String KEYSTORE_INFO = "SAP J2EE Engine KeyStore provider version 4.0.3 ( key store types: EBSDKS, Backup; coders: PKCS#8, X.509, EBSDKS )";
    private static KeyStoreProvider defaultProvider;
    static /* synthetic */ Class class$com$sap$engine$services$keystore$spi$EBSDKSKeyStoreSpiImpl;

    public KeyStoreProvider() {
        this("KeyStore");
    }

    protected KeyStoreProvider(String name) {
        super(name, 4.0, KEYSTORE_INFO);
        this.put("KeyStore.EBSDKS", "com.sap.engine.services.keystore.spi.EBSDKSKeyStoreSpiImpl");
        this.put("KeyStore.Backup", "com.sap.engine.services.keystore.spi.BackupKeyStoreSpiImpl");
        this.put("KeyStoreEntryCoder.BASE64_PKCS8", "com.sap.engine.services.keystore.impl.coder.Base64PKCS8PrivateKeyCoder");
        this.put("KeyStoreEntryCoder.BASE64_PKCS#8", "com.sap.engine.services.keystore.impl.coder.Base64PKCS8PrivateKeyCoder");
        this.put("KeyStoreEntryCoder.PKCS8", "com.sap.engine.services.keystore.impl.coder.PKCS8PrivateKeyCoder");
        this.put("KeyStoreEntryCoder.PKCS#8", "com.sap.engine.services.keystore.impl.coder.PKCS8PrivateKeyCoder");
        this.put("KeyStoreEntryCoder.EBSDKS", "com.sap.engine.services.keystore.impl.coder.RepositoryCoder");
        this.put("KeyStoreEntryCoder.BASE64_BER", "com.sap.engine.services.keystore.impl.coder.RepositoryCoder");
        this.put("KeyStoreEntryCoder.BER", "com.sap.engine.services.keystore.impl.coder.RepositoryCoder");
        this.put("KeyStoreEntryCoder.BASE64_X509", "com.sap.engine.services.keystore.impl.coder.Base64X509CertificateCoder");
        this.put("KeyStoreEntryCoder.BASE64_X.509", "com.sap.engine.services.keystore.impl.coder.Base64X509CertificateCoder");
        this.put("KeyStoreEntryCoder.X509", "com.sap.engine.services.keystore.impl.coder.X509CertificateCoder");
        this.put("KeyStoreEntryCoder.X.509", "com.sap.engine.services.keystore.impl.coder.X509CertificateCoder");
        this.put("KeyStoreEntryCoder.BASE64_PKCS12", "com.sap.engine.services.keystore.impl.coder.PKCS12Coder");
        this.put("KeyStoreEntryCoder.BASE64_PKCS#12", "com.sap.engine.services.keystore.impl.coder.PKCS12Coder");
        this.put("KeyStoreEntryCoder.PKCS12", "com.sap.engine.services.keystore.impl.coder.PKCS12Coder");
        this.put("KeyStoreEntryCoder.PKCS#12", "com.sap.engine.services.keystore.impl.coder.PKCS12Coder");
    }

    public synchronized void shutdown() {
        this.remove("KeyStore.EBSDKS");
        this.remove("KeyStore.Backup");
        this.remove("KeyStoreEntryCoder.PKCS8");
        this.remove("KeyStoreEntryCoder.PKCS#8");
        this.remove("KeyStoreEntryCoder.EBSDKS");
        this.remove("KeyStoreEntryCoder.BER");
        this.remove("KeyStoreEntryCoder.X509");
        this.remove("KeyStoreEntryCoder.X.509");
        this.remove("KeyStoreEntryCoder.PKCS12");
        this.remove("KeyStoreEntryCoder.PKCS#12");
        Security.removeProvider("KeyStore");
        defaultProvider = null;
    }

    public int install() {
        return this.install(Security.getProviders().length + 1);
    }

    public int install(int position) {
        return Security.insertProviderAt(this, position);
    }

    public static synchronized KeyStoreProvider getProvider() {
        if (defaultProvider == null) {
            defaultProvider = new KeyStoreProvider();
            defaultProvider.install();
        }
        return defaultProvider;
    }

    public static synchronized KeyStore getKeyStore(String keystoreViewAlias) throws KeyStoreException {
        if (keystoreViewAlias == null) {
            throw new KeyStoreException("A keystore view with null alias do not exists!");
        }
        KeyStoreProvider.getProvider().install();
        KeyStoreProvider.install_IAIK_provider();
        KeyStore ks = KeyStore.getInstance("EBSDKS");
        String selectAliasToken = null;
        try {
            selectAliasToken = "KEY_VIEW_ALIAS=" + keystoreViewAlias + ';';
            ks.load(null, selectAliasToken.toCharArray());
        }
        catch (Exception e) {
            throw new KeyStoreException("keystore.load(null, {" + selectAliasToken + "}) failed: " + e);
        }
        return ks;
    }

    public static KeyStore getKeyStore(String keystoreViewAlias, Properties p) throws KeyStoreException {
        Class clazz = class$com$sap$engine$services$keystore$spi$EBSDKSKeyStoreSpiImpl == null ? (class$com$sap$engine$services$keystore$spi$EBSDKSKeyStoreSpiImpl = KeyStoreProvider.class$("com.sap.engine.services.keystore.spi.EBSDKSKeyStoreSpiImpl")) : class$com$sap$engine$services$keystore$spi$EBSDKSKeyStoreSpiImpl;
        synchronized (clazz) {
            if (keystoreViewAlias == null) {
                throw new KeyStoreException("A keystore view with null alias do not exists!");
            }
            KeyStoreProvider.getProvider().install();
            KeyStoreProvider.install_IAIK_provider();
            EBSDKSKeyStoreSpiImpl.setInitialContextProperties(p);
            KeyStore ks = KeyStore.getInstance("EBSDKS");
            String selectAliasToken = null;
            try {
                selectAliasToken = "KEY_VIEW_ALIAS=" + keystoreViewAlias + ';';
                ks.load(null, selectAliasToken.toCharArray());
            }
            catch (Exception e) {
                throw new KeyStoreException("keystore.load(null, {" + selectAliasToken + "}) failed: " + e);
            }
            KeyStore keyStore = ks;
            return keyStore;
        }
    }

    private static void install_IAIK_provider() throws KeyStoreException {
        String provider_name = "iaik.security.provider.IAIK";
        try {
            if (Security.getProvider("IAIK") == null) {
                IAIK.addAsJDK14Provider();
            }
        }
        catch (Error err) {
            throw new KeyStoreException("The required provider[" + provider_name + "] is not instaled: " + err);
        }
        catch (Exception e) {
            throw new KeyStoreException("The required provider[" + provider_name + "] is not instaled: " + e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

