/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.interfaces;

import com.sap.engine.services.keystore.interfaces.KeyStoreSpiEntry;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public abstract class KeyStoreEntryCoder {
    protected static Properties properties = null;

    public static void setProperties(Properties props) {
        properties = props;
    }

    public abstract KeyStoreSpiEntry decode(byte[] var1, int var2, int var3) throws KeyStoreException;

    public abstract KeyStoreSpiEntry decode(InputStream var1) throws KeyStoreException;

    public abstract void encode(KeyStoreSpiEntry var1, OutputStream var2) throws KeyStoreException;

    public abstract void encode(KeyStoreSpiEntry var1, byte[] var2, int var3) throws KeyStoreException;

    public static KeyStoreEntryCoder getCoder(String format) throws KeyStoreException {
        Provider[] providers = Security.getProviders();
        String key = "KeyStoreEntryCoder." + format;
        int i = 0;
        while (i < providers.length) {
            if (providers[i].getName().indexOf("InQMy") >= 0) {
                Provider temp = providers[0];
                providers[0] = providers[i];
                providers[i] = temp;
                break;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < providers.length) {
            if (((Hashtable)providers[i2]).containsKey(key)) {
                try {
                    return (KeyStoreEntryCoder)Class.forName(((Properties)providers[i2]).getProperty(key)).newInstance();
                }
                catch (Exception e) {
                    throw new KeyStoreException("ID21105: " + e);
                }
            }
            ++i2;
        }
        throw new KeyStoreException("ID21106: No coder of the format '" + format + "' is found.");
    }

    public static Enumeration getCoderFormats() {
        Provider[] providers = Security.getProviders();
        String next = null;
        Vector<String> coders = new Vector<String>();
        int i = 0;
        while (i < providers.length) {
            if (providers[i].getName().indexOf("InQMy") >= 0) {
                Provider temp = providers[0];
                providers[0] = providers[i];
                providers[i] = temp;
                break;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < providers.length) {
            Enumeration<?> e = providers[i2].propertyNames();
            while (e.hasMoreElements()) {
                next = (String)e.nextElement();
                if (!next.startsWith("KeyStoreEntryCoder.")) continue;
                coders.add(next.substring(19));
            }
            ++i2;
        }
        return coders.elements();
    }

    public static void registerCoder(String format, Class coder) {
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            if (providers[i].getName().indexOf("InQMy") >= 0) {
                Provider temp = providers[0];
                providers[0] = providers[i];
                providers[i] = temp;
                break;
            }
            ++i;
        }
        if (providers.length > 0) {
            providers[0].setProperty("KeyStoreEntryCoder." + format, coder.getName());
        }
    }
}

