/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl.security;

import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.services.keystore.exceptions.BaseKeystoreException;
import com.sap.engine.services.keystore.exceptions.KeystoreResourceAccessor;
import java.security.PrivilegedAction;
import java.util.Iterator;
import javax.security.auth.Subject;

final class GetAdminSubject
implements PrivilegedAction {
    private SecurityContext securityContext = null;

    GetAdminSubject(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public Object run() {
        try {
            Subject adminUser = new Subject();
            UserInfo someAdminUser = this.getUserFromRole(this.securityContext.getAuthorizationContext().getSecurityRoleContext().getSecurityRole("administrators"));
            KeystoreResourceAccessor.trace(300, " Used administrator principal: " + someAdminUser.getName());
            if (someAdminUser == null) {
                throw new BaseKeystoreException("rc_012");
            }
            this.securityContext.getUserStoreContext().getActiveUserStore().getUserContext().fillSubject(someAdminUser, adminUser);
            KeystoreResourceAccessor.trace(300, " after fillSubject(): " + adminUser.getPrincipals());
            return adminUser;
        }
        catch (BaseKeystoreException _) {
            return _;
        }
        catch (Throwable e) {
            return new BaseKeystoreException("rc_012", e);
        }
    }

    private UserInfo getUserFromRole(SecurityRole role) {
        if (role.getUsers().length != 0) {
            String userName = role.getUsers()[0];
            return this.securityContext.getUserStoreContext().getActiveUserStore().getUserContext().getUserInfo(userName);
        }
        String[] groups = role.getGroups();
        if (groups.length == 0) {
            return null;
        }
        int i = 0;
        while (i < groups.length) {
            String userName = this.getUserFromGroup(groups[i]);
            if (userName != null) {
                return this.securityContext.getUserStoreContext().getActiveUserStore().getUserContext().getUserInfo(userName);
            }
            ++i;
        }
        return null;
    }

    private String getUserFromGroup(String group) {
        Iterator users = this.securityContext.getUserStoreContext().getActiveUserStore().getGroupContext().getUsersOfGroup(group);
        if (users.hasNext()) {
            return (String)users.next();
        }
        Iterator groups = this.securityContext.getUserStoreContext().getActiveUserStore().getGroupContext().getChildGroups(group);
        while (groups.hasNext()) {
            String user = this.getUserFromGroup((String)groups.next());
            if (user == null) continue;
            return user;
        }
        return null;
    }
}

