/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl.security;

import com.sap.engine.interfaces.security.ProtectionDomainContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.lib.security.EnginePermission;
import com.sap.engine.lib.security.ProtectedProtectionDomain;
import com.sap.engine.services.keystore.exceptions.BaseKeystoreException;
import com.sap.engine.services.keystore.exceptions.KeystoreResourceAccessor;
import com.sap.engine.services.keystore.impl.security.SecurityConnector;
import com.sap.engine.services.keystore.interfaces.KeyStoreConstants;
import java.security.AccessController;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.ProtectionDomain;

public class CodeBasedSecurityConnector
implements SecurityConnector {
    private static CodeBasedSecurityConnector connector = null;
    public static ProtectionDomainContext domains = null;
    private static final String ALL_ACTIONS = "*";
    private static final String PERMISSION_NAME = "com.sap.engine.lib.security.EnginePermission";
    public static final int VIEW_ACTION = 0;
    public static final int PROPERTY_ACTION = 1;
    public static final int ENTRY_ACTION = 2;
    public static final int CREATE_VIEW_ACTION = 3;

    public static void setSecurityContext(SecurityContext securityContext) {
        domains = securityContext.getAuthorizationContext().getProtectionDomainContext();
    }

    public static CodeBasedSecurityConnector getConnector() {
        if (connector == null) {
            connector = new CodeBasedSecurityConnector();
        }
        return connector;
    }

    public static final int getCmdType(String cmd) {
        int i = 0;
        while (i < KeyStoreConstants.RESOURCE_VIEW_ACTIONS.length) {
            if (cmd.equals(KeyStoreConstants.RESOURCE_VIEW_ACTIONS[i])) {
                return 0;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < KeyStoreConstants.RESOURCE_PROPERTIES_ACTIONS.length) {
            if (cmd.equals(KeyStoreConstants.RESOURCE_PROPERTIES_ACTIONS[i2])) {
                return 1;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < KeyStoreConstants.RESOURCE_ENTRY_ACTIONS.length) {
            if (cmd.equals(KeyStoreConstants.RESOURCE_ENTRY_ACTIONS[i3])) {
                return 2;
            }
            ++i3;
        }
        if (cmd.equals("CREATE_VIEW")) {
            return 3;
        }
        return -1;
    }

    public Permission getPermission(String[] params) throws Exception {
        int type = CodeBasedSecurityConnector.getCmdType(params[0]);
        switch (type) {
            case 0: {
                return this.getViewPermission(params[0], params[1]);
            }
            case 1: {
                return this.getPropertyPermission(params[0], params[1], params[2]);
            }
            case 2: {
                return this.getEntryPermission(params[0], params[1], params[2]);
            }
            case 3: {
                return new EnginePermission("keystore", "view:CREATE_VIEW");
            }
        }
        throw new Exception("getPermission() - Unknown ACTION_TYPE: " + params[0]);
    }

    public Permission getViewPermission(String action, String viewAlias) throws Exception {
        String result = null;
        if (action == null) {
            throw new Exception("Null action passed as a parameter!");
        }
        if (viewAlias == null) {
            throw new Exception("Null view alias passed as a parameter!");
        }
        result = "view:" + action + ":" + viewAlias;
        return new EnginePermission("keystore", result);
    }

    public Permission getPropertyPermission(String action, String viewAlias, String propertyAlias) throws Exception {
        String result = null;
        if (action == null) {
            throw new Exception("Null action passed as a parameter!");
        }
        if (viewAlias == null) {
            throw new Exception("Null view alias passed as a parameter!");
        }
        if (propertyAlias == null) {
            throw new Exception("Null property alias passed as a parameter!");
        }
        result = "property:" + action + ":" + viewAlias + ":" + propertyAlias;
        return new EnginePermission("keystore", result);
    }

    public Permission getEntryPermission(String action, String viewAlias, String entryAlias) throws Exception {
        String result = null;
        if (action == null) {
            throw new Exception("Null action passed as a parameter!");
        }
        if (viewAlias == null) {
            throw new Exception("Null view alias passed as a parameter!");
        }
        if (entryAlias == null) {
            throw new Exception("Null entry alias passed as a parameter!");
        }
        result = "entry:" + action + ":" + viewAlias + ":" + entryAlias;
        return new EnginePermission("keystore", result);
    }

    public void createViewPermission(String alias) throws Exception {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        domains.grantPermission(appDomain, PERMISSION_NAME, "keystore", "*:*:" + alias + ":" + ALL_ACTIONS);
    }

    public void removeViewPermission(String alias) throws Exception {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        ProtectionDomain[] allDomains = domains.getProtectionDomains();
        String name = null;
        int i = 0;
        while (i < allDomains.length) {
            name = ((ProtectedProtectionDomain)allDomains[i]).getName();
            if (name.startsWith("sap.com")) {
                domains.clearPermission(name, PERMISSION_NAME, "keystore", "*:*:" + alias + ":" + ALL_ACTIONS);
            }
            ++i;
        }
    }

    public void createEntryPermission(String viewAlias, String entryAlias) throws Exception {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        domains.grantPermission(appDomain, PERMISSION_NAME, "keystore", "entry:*:" + viewAlias + ":" + entryAlias);
    }

    public void destroyEntryPermission(String viewAlias, String entryAlias) throws Exception {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        ProtectionDomain[] allDomains = domains.getProtectionDomains();
        String name = null;
        int i = 0;
        while (i < allDomains.length) {
            name = ((ProtectedProtectionDomain)allDomains[i]).getName();
            if (name.startsWith("sap.com")) {
                domains.clearPermission(appDomain, PERMISSION_NAME, "keystore", "entry:*:" + viewAlias + ":" + entryAlias);
            }
            ++i;
        }
    }

    public void renameEntryPermission(String viewAlias, String oldEntryAlias, String newEntryAlias) throws Exception {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        domains.clearPermission(appDomain, PERMISSION_NAME, "keystore", "entry:*:" + viewAlias + ":" + oldEntryAlias);
        domains.grantPermission(appDomain, PERMISSION_NAME, "keystore", "entry:*:" + viewAlias + ":" + newEntryAlias);
    }

    public void createPropertyPermission(String viewAlias, String key) throws Exception {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        domains.grantPermission(appDomain, PERMISSION_NAME, "keystore", "property:*:" + viewAlias + ":" + key);
    }

    public void destroyPropertyPermission(String viewAlias, String key) throws Exception {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        ProtectionDomain[] allDomains = domains.getProtectionDomains();
        int i = 0;
        while (i < allDomains.length) {
            String name = ((ProtectedProtectionDomain)allDomains[i]).getName();
            if (name.startsWith("sap.com")) {
                domains.clearPermission(name, PERMISSION_NAME, "keystore", "property:*:" + viewAlias + ":" + key);
            }
            ++i;
        }
    }

    public void checkPermissions_createView() throws KeyStoreException {
    }

    public void checkPermissions_removeView(String viewAlias) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getViewPermission("DESTROY_VIEW", viewAlias);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_removeView(" + viewAlias + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at:  " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_createEntry(String viewAlias) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getViewPermission("CREATE_ENTRY_AT_VIEW", viewAlias);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_createEntry(" + viewAlias + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new KeyStoreException(e.toString());
        }
    }

    public void checkPermissions_removeEntry(String viewAlias, String entryAlias) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getEntryPermission("REMOVE_ENTRY", viewAlias, entryAlias);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_removeEntry(" + viewAlias + ", " + entryAlias + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_createProperty(String viewAlias) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getViewPermission("SET_VIEW_PROPERTY", viewAlias);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_createProperty(" + viewAlias + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_removeProperty(String viewAlias, String key) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getPropertyPermission("REMOVE_PROPERTY", viewAlias, key);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_removeProperty(" + viewAlias + ", " + key + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_getProperty(String viewAlias, String key) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getPropertyPermission("GET_PROPERTY", viewAlias, key);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_getProperty(" + viewAlias + ", " + key + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_listProperty(String viewAlias, String key) throws KeyStoreException {
    }

    public void checkPermissions_writeProperty(String viewAlias, String key) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getPropertyPermission("UPDATE_PROPERTY", viewAlias, key);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_writeProperty(" + viewAlias + ", " + key + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_getViewProperties(String viewAlias) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getViewPermission("GET_VIEW_PROPERTIES", viewAlias);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_getViewProperties(" + viewAlias + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_aliases(String viewAlias) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getViewPermission("VIEW_ALIASES", viewAlias);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_aliases(" + viewAlias + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_readEntry(String viewAlias, String entryAlias) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getEntryPermission("READ_ENTRY", viewAlias, entryAlias);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_readEntry(" + viewAlias + ", " + entryAlias + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_listEntry(String viewAlias, String entryAlias) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getEntryPermission("LIST_ENTRY", viewAlias, entryAlias);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_listEntry(" + viewAlias + ", " + entryAlias + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_writeEntry(String viewAlias, String entryAlias) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getEntryPermission("WRITE_ENTRY", viewAlias, entryAlias);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_writeEntry(" + viewAlias + ", " + entryAlias + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_size(String viewAlias) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getViewPermission("SIZE_OF_VIEW", viewAlias);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_size(" + viewAlias + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_listView(String viewAlias) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getViewPermission("LIST_VIEW", viewAlias);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_listView(" + viewAlias + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_findAlias(String viewAlias) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getViewPermission("FIND_ALIAS", viewAlias);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_findAlias(" + viewAlias + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_isViewExists(String viewAlias) throws KeyStoreException {
    }

    public void checkPermissions_getView(String viewAlias) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getViewPermission("GET_VIEW", viewAlias);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_getView(" + viewAlias + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_IsKey(String viewAlias, String entryAlias) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getEntryPermission("IS_ENTRY_A_KEY", viewAlias, entryAlias);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_IsKey(" + viewAlias + ", " + entryAlias + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_renameEntry(String viewAlias, String entryAlias) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getEntryPermission("RENAME_ENTRY", viewAlias, entryAlias);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_renameEntry(" + viewAlias + ", " + entryAlias + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    public void checkPermissions_IsExistsEntry(String viewAlias, String entryAlias) throws KeyStoreException {
        String appDomain = this.getApplicationDomain();
        if (appDomain == null) {
            return;
        }
        EnginePermission p = null;
        try {
            p = (EnginePermission)this.getEntryPermission("IS_ENTRY_EXISTS", viewAlias, entryAlias);
            AccessController.checkPermission(p);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermissions_IsExistsEntry(" + viewAlias + ", " + entryAlias + ")", e);
            KeystoreResourceAccessor.trace(300, this.dumpDomains());
            if (p != null) {
                KeystoreResourceAccessor.trace(300, "implies fails at: " + p.getImpliesFailedDomain());
            }
            throw new BaseKeystoreException("rc_001", new Object[]{p.toString(), p.getImpliesFailedDomain()}, (Throwable)e);
        }
    }

    private String dumpDomains() {
        StringBuffer buff = new StringBuffer();
        String offset = "   ";
        buff.append("domain stack: {");
        ProtectionDomain[] stack = domains.getProtectionDomainStack();
        ProtectedProtectionDomain current = null;
        int i = 0;
        while (i < stack.length) {
            current = (ProtectedProtectionDomain)stack[i];
            buff.append(offset);
            buff.append(current.getName());
            buff.append(": ");
            buff.append(current.isApplicationDomain);
            ++i;
        }
        buff.append("}");
        return buff.toString();
    }

    private String getApplicationDomain() {
        ProtectionDomain[] stack = domains.getProtectionDomainStack();
        ProtectedProtectionDomain current = null;
        int i = 0;
        while (i < stack.length) {
            current = (ProtectedProtectionDomain)stack[i];
            if (current.isApplicationDomain) {
                return current.getName();
            }
            ++i;
        }
        return null;
    }
}

