/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl.coder;

import com.sap.engine.services.keystore.impl.KeyStoreEntry;
import com.sap.engine.services.keystore.interfaces.KeyStoreEntryCoder;
import com.sap.engine.services.keystore.interfaces.KeyStoreSpiEntry;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Random;

public class PKCS12Coder
extends KeyStoreEntryCoder {
    public KeyStoreSpiEntry decode(byte[] data, int offset, int length) throws KeyStoreException {
        return this.decode(new ByteArrayInputStream(data, offset, length));
    }

    public KeyStoreSpiEntry decode(InputStream in) throws KeyStoreException {
        try {
            PKCS12 pkcs12 = new PKCS12(in);
            pkcs12.decrypt(KeyStoreEntryCoder.properties.getProperty("password").toCharArray());
            PrivateKey pk = pkcs12.getKeyBag().getPrivateKey();
            CertificateBag[] certs = pkcs12.getCertificateBags();
            return new KeyStoreEntry(pk, (Certificate[])CertificateBag.getCertificates((CertificateBag[])certs));
        }
        catch (Exception e) {
            throw new KeyStoreException("ID21108: " + e.getMessage());
        }
    }

    public void encode(KeyStoreSpiEntry entry, OutputStream out) throws KeyStoreException {
        PrivateKey pk = (PrivateKey)entry.getKey();
        Certificate[] chain = entry.getCertificateChain();
        byte[] keyID = new BigInteger(64, new Random()).toByteArray();
        Object data = null;
        String alias = KeyStoreEntryCoder.properties.getProperty("alias");
        KeyBag keyBag = new KeyBag(pk, alias, keyID);
        CertificateBag[] bagChain = new CertificateBag[chain.length];
        PKCS12 pkcs12 = null;
        bagChain[0] = new CertificateBag((X509Certificate)chain[0], alias + "_cert0", keyID);
        int i = 1;
        while (i < bagChain.length) {
            bagChain[i] = new CertificateBag((X509Certificate)chain[i], alias + "_cert" + i, null);
            ++i;
        }
        try {
            pkcs12 = new PKCS12(keyBag, bagChain);
            pkcs12.encrypt(KeyStoreEntryCoder.properties.getProperty("password").toCharArray());
            pkcs12.writeTo(out);
        }
        catch (Exception ioe) {
            throw new KeyStoreException("ID21108: " + ioe.getMessage());
        }
    }

    public void encode(KeyStoreSpiEntry entry, byte[] out, int offset) throws KeyStoreException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encode(entry, baos);
        try {
            byte[] data = baos.toByteArray();
            System.arraycopy(data, 0, out, offset, data.length);
        }
        catch (Exception e) {
            if (e instanceof KeyStoreException) {
                throw (KeyStoreException)e;
            }
            throw new KeyStoreException("ID21108: " + e.getMessage());
        }
    }
}

