/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl.coder;

import com.sap.engine.lib.security.Base64;
import com.sap.engine.services.keystore.impl.KeyStoreEntry;
import com.sap.engine.services.keystore.interfaces.KeyStoreEntryCoder;
import com.sap.engine.services.keystore.interfaces.KeyStoreSpiEntry;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public class Base64PKCS8PrivateKeyCoder
extends KeyStoreEntryCoder {
    private static final byte[] HEADER = "-----BEGIN PRIVATE KEY-----\n".getBytes();
    private static final byte[] FOOTER = "\n-----END PRIVATE KEY-----\n".getBytes();

    public KeyStoreSpiEntry decode(byte[] data, int offset, int length) throws KeyStoreException {
        try {
            data = Base64.decode(data);
        }
        catch (Exception e) {
            throw new KeyStoreException("ID21112: Not a Base64 encoded key. " + e.getMessage());
        }
        PrivateKey pk = null;
        if (offset != 0 || length != data.length) {
            byte[] b = new byte[length];
            System.arraycopy(data, offset, b, 0, length);
            data = b;
        }
        try {
            pk = PrivateKeyInfo.getPrivateKey((byte[])data);
        }
        catch (Exception e) {
            throw new KeyStoreException("ID21112: Not a PKCS#8 formatted key. " + e.getMessage());
        }
        return new KeyStoreEntry(pk, new Certificate[0]);
    }

    public KeyStoreSpiEntry decode(InputStream in) throws KeyStoreException {
        byte[] read = null;
        int length = 0;
        try {
            length = in.available();
            read = new byte[length];
            in.read(read);
        }
        catch (IOException ioe) {
            throw new KeyStoreException("ID21108: " + ioe.getMessage());
        }
        return this.decode(read, 0, read.length);
    }

    public void encode(KeyStoreSpiEntry entry, OutputStream out) throws KeyStoreException {
        PrivateKey pk = (PrivateKey)entry.getKey();
        byte[] data = null;
        try {
            data = this.headFoot(pk.getEncoded());
        }
        catch (Exception e) {
            throw new KeyStoreException("ID21112: Not a PKCS#8 formatted key entry. " + e.getMessage());
        }
        try {
            out.write(data);
        }
        catch (IOException ioe) {
            throw new KeyStoreException("ID21108: " + ioe.getMessage());
        }
    }

    public void encode(KeyStoreSpiEntry entry, byte[] out, int offset) throws KeyStoreException {
        PrivateKey pk = (PrivateKey)entry.getKey();
        byte[] data = null;
        try {
            data = this.headFoot(pk.getEncoded());
        }
        catch (Exception e) {
            throw new KeyStoreException("ID21112: Not a PKCS#8 formatted key entry. " + e.getMessage());
        }
        System.arraycopy(data, 0, out, offset, data.length);
    }

    private byte[] headFoot(byte[] raw) throws Exception {
        raw = Base64.encode(raw);
        byte[] data = new byte[raw.length + HEADER.length + FOOTER.length];
        System.arraycopy(HEADER, 0, data, 0, HEADER.length);
        System.arraycopy(raw, 0, data, HEADER.length, raw.length);
        System.arraycopy(FOOTER, 0, data, HEADER.length + raw.length, FOOTER.length);
        return data;
    }
}

