/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl;

import com.sap.engine.lib.security.ProtectedProtectionDomain;
import com.sap.engine.lib.security.domain.ProtectionDomainFactory;
import com.sap.engine.services.keystore.exceptions.BaseRemoteException;
import com.sap.engine.services.keystore.exceptions.KeystoreResourceAccessor;
import com.sap.engine.services.keystore.impl.security.CodeBasedSecurityConnector;
import com.sap.engine.services.keystore.impl.security.SecurityRestrictionsChecker;
import com.sap.engine.services.keystore.impl.security.UserBasedSecurityConnector;
import com.sap.engine.services.keystore.interfaces.RemoteSecurityConnector;
import java.rmi.RemoteException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.Vector;
import javax.rmi.PortableRemoteObject;

public class RemoteSecurityConnectorImpl
extends PortableRemoteObject
implements RemoteSecurityConnector {
    private CodeBasedSecurityConnector codeConnector = null;
    UserBasedSecurityConnector userConnector = null;
    SecurityRestrictionsChecker securityChecker = null;

    public RemoteSecurityConnectorImpl(CodeBasedSecurityConnector codeConnector, UserBasedSecurityConnector userConnector, SecurityRestrictionsChecker securityChecker) throws RemoteException {
        this.codeConnector = codeConnector;
        this.userConnector = userConnector;
        this.securityChecker = securityChecker;
    }

    public boolean isCodeGranted(String[] params) throws RemoteException {
        try {
            SecurityRestrictionsChecker.checkCodePermission(params);
            return true;
        }
        catch (Exception e) {
            Object[] parameters = new Object[]{RemoteSecurityConnectorImpl.dumpParams(params)};
            KeystoreResourceAccessor.traceThrowable(300, "rsc_004", parameters, e);
            return false;
        }
    }

    public boolean isUserGranted(String[] params) throws RemoteException {
        try {
            SecurityRestrictionsChecker.checkUserPermission(params);
            return true;
        }
        catch (Exception e) {
            Object[] parameters = new Object[]{RemoteSecurityConnectorImpl.dumpParams(params)};
            KeystoreResourceAccessor.traceThrowable(300, "rsc_003", parameters, e);
            return false;
        }
    }

    public void grantCodePermission(String domainName, String[] params) throws RemoteException {
        if (domainName == null) {
            BaseRemoteException bex = new BaseRemoteException("rsc_000");
            KeystoreResourceAccessor.traceThrowable(300, "rsc_000", null);
            throw bex;
        }
        Permission p = null;
        try {
            p = this.codeConnector.getPermission(params);
            CodeBasedSecurityConnector.domains.grantPermission(domainName, p.getClass().getName(), p.getName(), p.getActions());
        }
        catch (Exception e) {
            Object[] parameters = new Object[]{domainName, RemoteSecurityConnectorImpl.dumpParams(params)};
            BaseRemoteException bex = new BaseRemoteException("rsc_002", parameters, e);
            KeystoreResourceAccessor.log(500, e, "rsc_002", parameters);
            KeystoreResourceAccessor.traceThrowable(500, "rsc_002", parameters, e);
            throw bex;
        }
    }

    public void clearCodePermission(String domainName, String[] params) throws RemoteException {
        if (domainName == null) {
            BaseRemoteException bex = new BaseRemoteException("rsc_000");
            KeystoreResourceAccessor.traceThrowable(300, "rsc_000", null, bex);
            throw bex;
        }
        Permission p = null;
        try {
            p = this.codeConnector.getPermission(params);
            CodeBasedSecurityConnector.domains.clearPermission(domainName, p.getClass().getName(), p.getName(), p.getActions());
        }
        catch (Exception e) {
            Object[] parameters = new Object[]{domainName, RemoteSecurityConnectorImpl.dumpParams(params)};
            BaseRemoteException bex = new BaseRemoteException("rsc_001", parameters, e);
            KeystoreResourceAccessor.log(500, e, "rsc_001", parameters);
            KeystoreResourceAccessor.traceThrowable(500, "rsc_001", parameters, e);
            throw bex;
        }
    }

    public String[] getApplicationDomainNames() throws RemoteException {
        try {
            String[] result = null;
            ProtectionDomain[] domains = CodeBasedSecurityConnector.domains.getProtectionDomains();
            Vector<String> temp = new Vector<String>(domains.length);
            int i = 0;
            while (i < domains.length) {
                String name = ((ProtectedProtectionDomain)domains[i]).getName();
                if (((ProtectedProtectionDomain)domains[i]).isApplicationDomain) {
                    temp.add(name);
                }
                ++i;
            }
            result = new String[temp.size()];
            int i2 = 0;
            while (i2 < temp.size()) {
                result[i2] = (String)temp.get(i2);
                ++i2;
            }
            return result;
        }
        catch (Exception e) {
            KeystoreResourceAccessor.log(400, e, "rsc_005");
            KeystoreResourceAccessor.traceThrowable(400, "rsc_005", null, e);
            return new String[0];
        }
    }

    public String[] getGrantedDomains(String[] params) throws RemoteException {
        String[] domains = null;
        Vector<String> temp = null;
        Permission p = null;
        try {
            domains = this.getApplicationDomainNames();
            temp = new Vector<String>(domains.length);
            p = this.codeConnector.getPermission(params);
            int i = 0;
            while (i < domains.length) {
                PermissionCollection permissionCollection = ProtectionDomainFactory.getFactory().getProtectionDomain(domains[i]).getPermissions();
                if (permissionCollection.implies(p)) {
                    temp.add(domains[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Object[] parameters = new Object[]{RemoteSecurityConnectorImpl.dumpParams(params)};
            BaseRemoteException bex = new BaseRemoteException("rsc_006", parameters, e);
            KeystoreResourceAccessor.log(500, e, "rsc_006", parameters);
            KeystoreResourceAccessor.traceThrowable(500, "rsc_006", parameters, e);
            throw bex;
        }
        Object[] result = new String[temp.size()];
        temp.copyInto(result);
        return result;
    }

    public void grantPermissionForUser(String userName, String roleName, String[] params) throws RemoteException {
        Object[] parameters = new Object[]{userName, roleName, RemoteSecurityConnectorImpl.dumpParams(params)};
        if (roleName == null) {
            BaseRemoteException bex = new BaseRemoteException("rsc_007", parameters);
            KeystoreResourceAccessor.traceThrowable(300, "rsc_007", parameters, bex);
            throw bex;
        }
        try {
            this.userConnector.grantPermissionForUser(userName, roleName, params);
        }
        catch (Exception e) {
            BaseRemoteException bex = new BaseRemoteException("rsc_008", parameters, e);
            KeystoreResourceAccessor.log(500, e, "rsc_008", parameters);
            KeystoreResourceAccessor.traceThrowable(500, "rsc_008", parameters, e);
            throw bex;
        }
    }

    public void clearPermissionForGroup(String groupName, String roleName, String[] params) throws RemoteException {
        Object[] parameters = new Object[]{groupName, roleName, RemoteSecurityConnectorImpl.dumpParams(params)};
        if (roleName == null) {
            BaseRemoteException bex = new BaseRemoteException("rsc_007", parameters);
            KeystoreResourceAccessor.traceThrowable(300, "rsc_007", parameters, bex);
            throw bex;
        }
        try {
            this.userConnector.clearPermissionForGroup(groupName, roleName, params);
        }
        catch (Exception e) {
            BaseRemoteException bex = new BaseRemoteException("rsc_010", parameters, e);
            KeystoreResourceAccessor.log(500, e, "rsc_010", parameters);
            KeystoreResourceAccessor.traceThrowable(500, "rsc_010", parameters, e);
            throw bex;
        }
    }

    public void grantPermissionForGroup(String groupName, String roleName, String[] params) throws RemoteException {
        Object[] parameters = new Object[]{groupName, roleName, RemoteSecurityConnectorImpl.dumpParams(params)};
        if (roleName == null) {
            BaseRemoteException bex = new BaseRemoteException("rsc_007", parameters);
            KeystoreResourceAccessor.traceThrowable(300, "rsc_007", parameters, bex);
            throw bex;
        }
        try {
            this.userConnector.grantPermissionForGroup(groupName, roleName, params);
        }
        catch (Exception e) {
            BaseRemoteException bex = new BaseRemoteException("rsc_009", parameters, e);
            KeystoreResourceAccessor.log(500, e, "rsc_009", parameters);
            KeystoreResourceAccessor.traceThrowable(500, "rsc_009", parameters, e);
            throw bex;
        }
    }

    public void clearPermissionForUser(String userName, String roleName, String[] params) throws RemoteException {
        Object[] parameters = new Object[]{userName, roleName, RemoteSecurityConnectorImpl.dumpParams(params)};
        if (roleName == null) {
            BaseRemoteException bex = new BaseRemoteException("rsc_007", parameters);
            KeystoreResourceAccessor.traceThrowable(300, "rsc_007", parameters, bex);
            throw bex;
        }
        try {
            this.userConnector.clearPermissionForUser(userName, roleName, params);
        }
        catch (Exception e) {
            BaseRemoteException bex = new BaseRemoteException("rsc_011", parameters, e);
            KeystoreResourceAccessor.log(500, e, "rsc_011", parameters);
            KeystoreResourceAccessor.traceThrowable(500, "rsc_011", parameters, e);
            throw bex;
        }
    }

    public String[][] listAllRoles(String[] params) throws RemoteException {
        try {
            return this.userConnector.listAllRoles(params);
        }
        catch (Exception e) {
            Object[] parameters = new Object[]{RemoteSecurityConnectorImpl.dumpParams(params)};
            BaseRemoteException bex = new BaseRemoteException("rsc_012", parameters, e);
            KeystoreResourceAccessor.log(500, e, "rsc_012", parameters);
            KeystoreResourceAccessor.traceThrowable(500, "rsc_012", parameters, e);
            throw bex;
        }
    }

    public static String dumpParams(String[] params) {
        String result = "{";
        int i = 0;
        while (i < params.length) {
            result = result + params[i] + " ";
            ++i;
        }
        return result + "}";
    }
}

