/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl;

import com.sap.engine.lib.security.EnginePermission;
import com.sap.engine.services.keystore.exceptions.BaseParameterException;
import com.sap.engine.services.keystore.exceptions.KeystoreResourceAccessor;
import com.sap.engine.services.keystore.impl.AbstractKeystoreManager;
import com.sap.engine.services.keystore.impl.security.UserBasedSecurityConnector;
import com.sap.engine.services.keystore.interfaces.KeyStoreSpiEntry;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Properties;

public class ParameterChecker
extends AbstractKeystoreManager {
    private AbstractKeystoreManager keystoreManager;

    public void checkPermission(String[] params) throws KeyStoreException {
        this.keystoreManager.checkPermission(params);
    }

    public ParameterChecker(AbstractKeystoreManager keystoreManager) {
        this.keystoreManager = keystoreManager;
    }

    public void stop() {
        this.keystoreManager.stop();
    }

    public KeyStore getKeystore(String keystore_view_name) throws KeyStoreException {
        this.checkViewName(keystore_view_name);
        return this.keystoreManager.getKeystore(keystore_view_name);
    }

    public boolean existKeystoreView(String keystore_view_name) throws KeyStoreException {
        if (keystore_view_name.equals("DEFAULT")) {
            return true;
        }
        this.checkViewName(keystore_view_name);
        return this.keystoreManager.existKeystoreView(keystore_view_name);
    }

    public boolean exists(String keystore_view_name, String alias) throws KeyStoreException {
        this.checkViewName(keystore_view_name);
        this.checkEntryName(alias);
        return this.keystoreManager.exists(keystore_view_name, alias);
    }

    public String[] aliases(String keystore_view_name) throws KeyStoreException {
        this.checkViewName(keystore_view_name);
        return this.keystoreManager.aliases(keystore_view_name);
    }

    public void renameEntry(String keystoreViewAlias, String oldEntryAlias, String newEntryAlias) throws KeyStoreException {
        this.checkViewName(keystoreViewAlias);
        this.checkEntryName(oldEntryAlias);
        this.checkEntryName(newEntryAlias);
        this.keystoreManager.renameEntry(keystoreViewAlias, oldEntryAlias, newEntryAlias);
    }

    public void deleteEntry(String keystore_view_name, String alias) throws KeyStoreException {
        this.checkViewName(keystore_view_name);
        this.checkEntryName(alias);
        this.keystoreManager.deleteEntry(keystore_view_name, alias);
    }

    public String findAlias(String keystore_view_name, KeyStoreSpiEntry entry) throws KeyStoreException {
        if (entry == null) {
            BaseParameterException bex = new BaseParameterException("pc_001");
            KeystoreResourceAccessor.trace(300, "findAlias: " + keystore_view_name + ", " + entry);
            throw bex;
        }
        this.checkViewName(keystore_view_name);
        return this.keystoreManager.findAlias(keystore_view_name, entry);
    }

    public KeyStoreSpiEntry readEntry(String keystore_view_name, String alias) throws KeyStoreException {
        this.checkViewName(keystore_view_name);
        this.checkEntryName(alias);
        return this.keystoreManager.readEntry(keystore_view_name, alias);
    }

    public int size(String keystore_view_name) throws KeyStoreException {
        this.checkViewName(keystore_view_name);
        return this.keystoreManager.size(keystore_view_name);
    }

    public void writeEntry(String keystore_view_name, String alias, KeyStoreSpiEntry entry) throws KeyStoreException {
        if (entry == null) {
            BaseParameterException bex = new BaseParameterException("pc_001");
            KeystoreResourceAccessor.trace(300, "writeEntry: " + keystore_view_name + ", " + alias + ", " + entry);
            throw bex;
        }
        this.checkViewName(keystore_view_name);
        this.checkEntryName(alias);
        this.keystoreManager.writeEntry(keystore_view_name, alias, entry);
    }

    public boolean isKeyEntry(String keystore_view_name, String alias) throws KeyStoreException {
        this.checkViewName(keystore_view_name);
        this.checkEntryName(alias);
        return this.keystoreManager.isKeyEntry(keystore_view_name, alias);
    }

    public String[] getKeystoreViewNames() throws KeyStoreException {
        return this.keystoreManager.getKeystoreViewNames();
    }

    public void createKeystoreViewEntry(String keystore_view_alias, Properties properties) throws KeyStoreException {
        if (properties == null) {
            properties = new Properties();
        }
        this.checkViewName(keystore_view_alias);
        this.keystoreManager.createKeystoreViewEntry(keystore_view_alias, properties);
    }

    public void destroyKeystoreViewEntry(String keystore_view_alias) throws KeyStoreException {
        this.checkViewName(keystore_view_alias);
        this.keystoreManager.destroyKeystoreViewEntry(keystore_view_alias);
    }

    public Properties getKeystoreViewProperties(String keystore_view_name) throws KeyStoreException {
        this.checkViewName(keystore_view_name);
        return this.keystoreManager.getKeystoreViewProperties(keystore_view_name);
    }

    public void removeProperty(String keystore_view, String key) throws KeyStoreException {
        if (key == null) {
            BaseParameterException bex = new BaseParameterException("pc_003", new Object[]{keystore_view});
            KeystoreResourceAccessor.trace(300, "removeProperty:" + keystore_view + ", " + key);
            throw bex;
        }
        this.checkViewName(keystore_view);
        this.checkViewName(key);
        this.keystoreManager.removeProperty(keystore_view, key);
    }

    public void setProperty(String keystore_view, String key, String value) throws KeyStoreException {
        if (key == null) {
            BaseParameterException bex = new BaseParameterException("pc_003", new Object[]{keystore_view, key, value});
            KeystoreResourceAccessor.trace(300, "pc_003", new Object[]{keystore_view});
            throw bex;
        }
        if (value == null) {
            BaseParameterException bex = new BaseParameterException("pc_004", new Object[]{keystore_view, key, value});
            KeystoreResourceAccessor.trace(300, "setProperty: " + keystore_view + ", " + key + ", " + value);
            throw bex;
        }
        this.checkViewName(keystore_view);
        this.checkViewName(key);
        this.keystoreManager.setProperty(keystore_view, key, value);
    }

    public String getProperty(String keystore_view, String key) throws KeyStoreException {
        if (key == null) {
            BaseParameterException bex = new BaseParameterException("pc_003", new Object[]{keystore_view, key});
            KeystoreResourceAccessor.trace(300, "getProperty: " + keystore_view + ", " + key);
            throw bex;
        }
        this.checkViewName(keystore_view);
        this.checkViewName(key);
        return this.keystoreManager.getProperty(keystore_view, key);
    }

    private void checkViewName(String name) throws KeyStoreException {
        if (name == null) {
            BaseParameterException bex = new BaseParameterException("pc_000");
            KeystoreResourceAccessor.trace(300, "checkViewName: " + name);
            throw bex;
        }
        if (name.equals("DEFAULT")) {
            return;
        }
        int i = 0;
        while (i < UserBasedSecurityConnector.SEPARATORS.length) {
            if (name.indexOf(UserBasedSecurityConnector.SEPARATORS[i]) != -1) {
                BaseParameterException bex = new BaseParameterException("pc_005", new Object[]{"'" + UserBasedSecurityConnector.SEPARATORS[i] + "'"});
                KeystoreResourceAccessor.traceThrowable(300, "", bex);
                throw bex;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < EnginePermission.INVALID_ACTIONS_CHARACTERS.length) {
            if (name.indexOf(EnginePermission.INVALID_ACTIONS_CHARACTERS[i2]) != -1) {
                BaseParameterException bex = new BaseParameterException("pc_005", new Object[]{"'" + UserBasedSecurityConnector.SEPARATORS[i2] + "'"});
                KeystoreResourceAccessor.traceThrowable(300, "", bex);
                throw bex;
            }
            ++i2;
        }
        if (name.indexOf(":") != -1) {
            BaseParameterException bex = new BaseParameterException("pc_005", new Object[]{"':'"});
            KeystoreResourceAccessor.traceThrowable(300, "", bex);
            throw bex;
        }
    }

    private void checkEntryName(String name) throws KeyStoreException {
        if (name == null) {
            BaseParameterException bex = new BaseParameterException("pc_002");
            KeystoreResourceAccessor.trace(300, "checkEntryName: " + name);
            throw bex;
        }
        int i = 0;
        while (i < UserBasedSecurityConnector.SEPARATORS.length) {
            if (name.indexOf(UserBasedSecurityConnector.SEPARATORS[i]) != -1) {
                BaseParameterException bex = new BaseParameterException("pc_005", new Object[]{"'" + UserBasedSecurityConnector.SEPARATORS[i] + "'"});
                KeystoreResourceAccessor.traceThrowable(300, "", bex);
                throw bex;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < EnginePermission.INVALID_ACTIONS_CHARACTERS.length) {
            if (name.indexOf(EnginePermission.INVALID_ACTIONS_CHARACTERS[i2]) != -1) {
                BaseParameterException bex = new BaseParameterException("pc_005", new Object[]{"'" + UserBasedSecurityConnector.SEPARATORS[i2] + "'"});
                KeystoreResourceAccessor.traceThrowable(300, "", bex);
                throw bex;
            }
            ++i2;
        }
        if (name.indexOf(":") != -1) {
            BaseParameterException bex = new BaseParameterException("pc_005", new Object[]{"':'"});
            KeystoreResourceAccessor.traceThrowable(300, "", bex);
            throw bex;
        }
    }
}

