/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl;

import com.sap.engine.lib.security.Base64;
import com.sap.engine.services.keystore.impl.util.Util;
import com.sap.engine.services.keystore.interfaces.KeyStoreSpiEntry;
import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.GeneralString;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.cipher.SecretKey;
import iaik.x509.PublicKeyInfo;
import iaik.x509.X509Certificate;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Date;
import java.util.Enumeration;

public class KeyStoreEntry
implements KeyStoreSpiEntry,
Serializable {
    static final long serialVersionUID = 4676667329952683980L;
    private transient SEQUENCE seq = new SEQUENCE();
    public byte[] data;
    public static final INTEGER PRIVATE_KEY_TYPE = new INTEGER(0);
    public static final INTEGER PUBLIC_KEY_TYPE = new INTEGER(1);
    public static final INTEGER SECRET_KEY_TYPE = new INTEGER(2);

    public KeyStoreEntry() throws KeyStoreException {
    }

    public KeyStoreEntry(Certificate certificate) throws KeyStoreException {
        this();
        try {
            this.constructCertificateHandle(certificate);
            this.data = DerCoder.encode((ASN1Object)this.seq);
        }
        catch (Exception e) {
            throw new KeyStoreException("ID21107: Unable to construct entry:\n " + Util.getStackTrace(e));
        }
    }

    public KeyStoreEntry(Key key, Certificate[] chain) throws KeyStoreException {
        this();
        try {
            if (chain == null) {
                chain = new Certificate[]{};
            }
            this.constructKeyHandle(key, chain);
            this.data = DerCoder.encode((ASN1Object)this.seq);
        }
        catch (Exception e) {
            throw new KeyStoreException("ID21107: Unable to construct entry:\n " + Util.getStackTrace(e));
        }
    }

    public static KeyStoreEntry createEntry(byte[] data) throws KeyStoreException {
        KeyStoreEntry entry = new KeyStoreEntry();
        try {
            if (KeyStoreEntry.isBase64Coded(data)) {
                data = Base64.decode(data);
            }
            entry.seq = (SEQUENCE)DerCoder.decode((byte[])data);
            entry.data = data;
        }
        catch (Throwable e) {
            throw new KeyStoreException("ID21107: Unable to construct entry:\n " + Util.getStackTrace(e));
        }
        return entry;
    }

    public byte[] toByteArray() throws KeyStoreException {
        try {
            return this.data;
        }
        catch (Exception e) {
            throw new KeyStoreException("ID21107: Unable to encode entry:\n " + Util.getStackTrace(e));
        }
    }

    public Certificate getCertificate() throws KeyStoreException {
        try {
            if (this.seq == null) {
                this.seq = (SEQUENCE)DerCoder.decode((byte[])this.data);
            }
            SEQUENCE cert = (SEQUENCE)this.seq.getComponentAt(1);
            X509Certificate x509 = new X509Certificate();
            x509.decode((ASN1Object)cert);
            return x509;
        }
        catch (Exception e) {
            throw new KeyStoreException("ID21107: Unable to recover certificate:\n " + Util.getStackTrace(e));
        }
    }

    public Key getKey() throws KeyStoreException {
        try {
            if (this.seq == null) {
                this.seq = (SEQUENCE)DerCoder.decode((byte[])this.data);
            }
            if (this.seq.countComponents() == 2) {
                throw new KeyStoreException("ID21107: Unable to recover a key from an certificate entry!");
            }
            ASN1Object asn = null;
            INTEGER keyType = null;
            GeneralString algName = null;
            asn = this.seq.getComponentAt(1);
            if (this.seq.countComponents() > 3) {
                keyType = (INTEGER)this.seq.getComponentAt(3);
                if (keyType.getValue().equals(PRIVATE_KEY_TYPE.getValue())) {
                    return PrivateKeyInfo.getPrivateKey((ASN1Object)asn);
                }
                if (keyType.getValue().equals(PUBLIC_KEY_TYPE.getValue())) {
                    return PublicKeyInfo.getPublicKey((ASN1Object)asn);
                }
                if (keyType.getValue().equals(SECRET_KEY_TYPE.getValue())) {
                    OCTET_STRING octets = (OCTET_STRING)asn;
                    algName = (GeneralString)this.seq.getComponentAt(4);
                    return new SecretKey((byte[])octets.getValue(), (String)algName.getValue());
                }
                return null;
            }
            return PrivateKeyInfo.getPrivateKey((ASN1Object)asn);
        }
        catch (Exception e) {
            throw new KeyStoreException("ID21107: Unable to recover key:\n " + Util.getStackTrace(e));
        }
    }

    public boolean isKeyEntry() throws KeyStoreException {
        try {
            if (DerCoder.decode((byte[])this.data).countComponents() == 2) {
                return false;
            }
        }
        catch (Exception e) {
            throw new KeyStoreException("ID21107: Unable determine type of key store entry:\n " + Util.getStackTrace(e));
        }
        return true;
    }

    public boolean isCertificateEntry() throws KeyStoreException {
        return !this.isKeyEntry();
    }

    public Certificate[] getCertificateChain() throws KeyStoreException {
        try {
            if (this.seq == null) {
                this.seq = (SEQUENCE)DerCoder.decode((byte[])this.data);
            }
            SEQUENCE chainComponent = (SEQUENCE)this.seq.getComponentAt(2);
            SEQUENCE[] allComponents = new SEQUENCE[chainComponent.countComponents()];
            int i = 0;
            Enumeration e = chainComponent.getComponents();
            while (e.hasMoreElements()) {
                allComponents[i] = (SEQUENCE)e.nextElement();
                ++i;
            }
            X509Certificate[] certChain = new X509Certificate[allComponents.length];
            i = 0;
            while (i < certChain.length) {
                certChain[i] = new X509Certificate();
                certChain[i].decode((ASN1Object)allComponents[i]);
                ++i;
            }
            return certChain;
        }
        catch (Exception e) {
            throw new KeyStoreException("ID21107: Unable to recover a certificate chain:\n " + Util.getStackTrace(e));
        }
    }

    public Date getCreationDate() throws KeyStoreException {
        try {
            if (this.seq == null) {
                this.seq = (SEQUENCE)DerCoder.decode((byte[])this.data);
            }
            String timeAsString = null;
            try {
                timeAsString = (String)this.seq.getComponentAt(0).getValue();
            }
            catch (Exception e) {
                timeAsString = null;
            }
            try {
                return new Date(Long.parseLong(timeAsString));
            }
            catch (Exception er) {
                timeAsString = null;
                return null;
            }
        }
        catch (Exception e) {
            throw new KeyStoreException("getCreationDate() - unexpected: " + Util.getStackTrace(e));
        }
    }

    public boolean consistsCertificate(Certificate certificate) throws KeyStoreException {
        Certificate chainCertificate = null;
        if (this.isKeyEntry()) {
            Certificate[] chain = this.getCertificateChain();
            chainCertificate = chain[0];
        } else {
            chainCertificate = this.getCertificate();
        }
        return KeyStoreEntry.equalCertificates(certificate, chainCertificate);
    }

    private static boolean equalCertificates(Certificate cert1, Certificate cert2) throws KeyStoreException {
        try {
            ASN1Object x1 = ((X509Certificate)cert1).toASN1Object();
            ASN1Object x2 = ((X509Certificate)cert2).toASN1Object();
            byte[] arr1 = DerCoder.encode((ASN1Object)x1);
            byte[] arr2 = DerCoder.encode((ASN1Object)x2);
            int i = 0;
            while (i < arr1.length) {
                try {
                    if (arr1[i] != arr2[i]) {
                        return false;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (ClassCastException cce) {
            throw new KeyStoreException("ID21107: " + cce.toString());
        }
    }

    private void constructKeyHandle(Key key, Certificate[] chain) throws KeyStoreException {
        byte[] array = null;
        X509Certificate x509 = null;
        SEQUENCE chainComponent = null;
        GeneralString creationDate = null;
        INTEGER keyType = null;
        GeneralString algName = null;
        try {
            x509 = new X509Certificate();
            creationDate = new GeneralString(Long.toString(System.currentTimeMillis()));
            this.seq.addComponent((ASN1Object)creationDate);
            array = key.getEncoded();
            if (key instanceof PrivateKey) {
                keyType = PRIVATE_KEY_TYPE;
                this.seq.addComponent(DerCoder.decode((byte[])array));
            } else if (key instanceof PublicKey) {
                keyType = PUBLIC_KEY_TYPE;
                this.seq.addComponent(DerCoder.decode((byte[])array));
            } else {
                keyType = SECRET_KEY_TYPE;
                algName = new GeneralString(key.getAlgorithm());
                this.seq.addComponent((ASN1Object)new OCTET_STRING(array));
            }
            chainComponent = new SEQUENCE();
            try {
                int i = 0;
                while (i < chain.length) {
                    array = chain[i].getEncoded();
                    x509 = new X509Certificate(array);
                    chainComponent.addComponent(x509.toASN1Object());
                    ++i;
                }
            }
            catch (CertificateEncodingException certificateencodingexception) {
                throw new KeyStoreException("certificate is not in format X509");
            }
            this.seq.addComponent((ASN1Object)chainComponent);
            this.seq.addComponent((ASN1Object)keyType);
            if (keyType.getValue().equals(SECRET_KEY_TYPE.getValue())) {
                this.seq.addComponent((ASN1Object)algName);
            }
        }
        catch (Exception e) {
            throw new KeyStoreException("ID21107: constructKeyHandle() - unexpected exception: " + Util.getStackTrace(e));
        }
    }

    private void constructCertificateHandle(Certificate cert) throws KeyStoreException {
        byte[] array = null;
        X509Certificate x509 = null;
        GeneralString creationDate = new GeneralString(Long.toString(System.currentTimeMillis()));
        this.seq.addComponent((ASN1Object)creationDate);
        try {
            array = cert.getEncoded();
            x509 = new X509Certificate(array);
            this.seq.addComponent(x509.toASN1Object());
        }
        catch (Exception cce) {
            throw new KeyStoreException("ID21132: certificate is not in format X509");
        }
    }

    public String toString() {
        if (this.seq == null) {
            try {
                this.seq = (SEQUENCE)DerCoder.decode((byte[])this.data);
            }
            catch (Exception e) {
                return "toString() - unexpected: " + e.toString();
            }
        }
        return this.seq.toString();
    }

    public static boolean isBase64Coded(byte[] data) {
        try {
            int i = 0;
            while (i < 4) {
                if (data[i] != 45) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            KeyStoreEntry entry = (KeyStoreEntry)obj;
            if (entry.isKeyEntry()) {
                if (!this.isKeyEntry()) {
                    return false;
                }
                Key thisKey = this.getKey();
                Key entryKey = entry.getKey();
                if (!thisKey.getAlgorithm().equals(entryKey.getAlgorithm()) || !thisKey.getFormat().equals(entryKey.getFormat())) {
                    return false;
                }
                Certificate[] thisChain = this.getCertificateChain();
                Certificate[] entryChain = entry.getCertificateChain();
                if (thisChain == null && entryChain != null || thisChain != null && entryChain == null) {
                    return false;
                }
                if (thisChain.length != entryChain.length) {
                    return false;
                }
                int i = 0;
                while (i < thisChain.length) {
                    if (!KeyStoreEntry.equalCertificates(thisChain[i], entryChain[i])) {
                        return false;
                    }
                    ++i;
                }
            } else {
                Certificate entryCert;
                if (this.isKeyEntry()) {
                    return false;
                }
                Certificate thisCert = this.getCertificate();
                if (!KeyStoreEntry.equalCertificates(thisCert, entryCert = entry.getCertificate())) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

