/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl;

import com.sap.engine.frame.core.configuration.ChangeEvent;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.keystore.exceptions.KeystoreResourceAccessor;
import com.sap.engine.services.keystore.impl.AbstractKeystoreManager;
import com.sap.engine.services.keystore.interfaces.KeyStoreSpiEntry;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Properties;

public class EntriesReadCache
extends AbstractKeystoreManager
implements ConfigurationChangedListener {
    private AbstractKeystoreManager storageManagerImpl = null;
    private HashMapObjectObject allCaches = new HashMapObjectObject();

    public EntriesReadCache(AbstractKeystoreManager storageManagerImpl) {
        this.storageManagerImpl = storageManagerImpl;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void configurationChanged(ChangeEvent event) {
        block5: {
            viewAlias = null;
            details = event.getDetailedChangeEvents();
            try {
                if (details.length == 1 && details[0].getPath().endsWith("entries")) {
                    viewAlias = details[0].getPath().substring(9, details[0].getPath().length() - 8);
                    if (!viewAlias.startsWith("$$$")) {
                        this.clearViewCache(viewAlias);
                    }
                    break block5;
                }
                if (details.length != 2 || (viewAlias = details[1].getPath().substring(9, details[1].getPath().length() - 1)).startsWith("$$$")) break block5;
                this.removeViewCache(viewAlias);
                break block5;
            }
            catch (Exception e) {
                KeystoreResourceAccessor.traceThrowable(400, "EntriesCache.configurationChanged(): ", null, e);
                i = 0;
                ** while (i < details.length)
            }
lbl-1000:
            // 1 sources

            {
                KeystoreResourceAccessor.trace(400, "details[" + i + "]: " + details[i].getPath());
                ++i;
                continue;
            }
        }
    }

    private KeyStoreSpiEntry getValue(String viewAlias, String entryAlias) {
        HashMapObjectObject viewCache = this.getViewCache(viewAlias);
        if (viewCache == null) {
            return null;
        }
        return (KeyStoreSpiEntry)viewCache.get(entryAlias);
    }

    private void putValue(String viewAlias, String entryAlias, KeyStoreSpiEntry value) {
        HashMapObjectObject viewCache = this.getViewCache(viewAlias);
        if (viewCache == null) {
            viewCache = new HashMapObjectObject();
            this.addViewCache(viewAlias, viewCache);
        }
        viewCache.put(entryAlias, value);
    }

    private void addViewCache(String viewAlias, HashMapObjectObject cache) {
        this.allCaches.put(viewAlias, cache);
    }

    private HashMapObjectObject getViewCache(String viewAlias) {
        return (HashMapObjectObject)this.allCaches.get(viewAlias);
    }

    private void clearViewCache(String viewAlias) {
        HashMapObjectObject cache = (HashMapObjectObject)this.allCaches.get(viewAlias);
        if (cache != null) {
            cache.clear();
        }
    }

    private void removeViewCache(String viewAlias) {
        this.allCaches.remove(viewAlias);
    }

    public void checkPermission(String[] params) throws KeyStoreException {
        this.storageManagerImpl.checkPermission(params);
    }

    public void stop() {
        this.storageManagerImpl.stop();
    }

    public KeyStore getKeystore(String keystore_view_name) throws KeyStoreException {
        return this.storageManagerImpl.getKeystore(keystore_view_name);
    }

    public boolean existKeystoreView(String keystore_view_name) throws KeyStoreException {
        return this.storageManagerImpl.existKeystoreView(keystore_view_name);
    }

    public synchronized boolean exists(String keystore_view_name, String alias) throws KeyStoreException {
        KeyStoreSpiEntry result = this.getValue(keystore_view_name, alias);
        if (result != null) {
            return true;
        }
        return this.storageManagerImpl.exists(keystore_view_name, alias);
    }

    public String[] aliases(String keystore_view_name) throws KeyStoreException {
        return this.storageManagerImpl.aliases(keystore_view_name);
    }

    public void renameEntry(String keystoreViewAlias, String oldEntryAlias, String newEntryAlias) throws KeyStoreException {
        this.storageManagerImpl.renameEntry(keystoreViewAlias, oldEntryAlias, newEntryAlias);
    }

    public void deleteEntry(String keystore_view_name, String alias) throws KeyStoreException {
        this.storageManagerImpl.deleteEntry(keystore_view_name, alias);
    }

    public String findAlias(String keystore_view_name, KeyStoreSpiEntry entry) throws KeyStoreException {
        return this.storageManagerImpl.findAlias(keystore_view_name, entry);
    }

    public synchronized KeyStoreSpiEntry readEntry(String keystore_view_name, String alias) throws KeyStoreException {
        KeyStoreSpiEntry result = this.getValue(keystore_view_name, alias);
        if (result != null) {
            return result;
        }
        result = this.storageManagerImpl.readEntry(keystore_view_name, alias);
        this.putValue(keystore_view_name, alias, result);
        return result;
    }

    public int size(String keystore_view_name) throws KeyStoreException {
        return this.storageManagerImpl.size(keystore_view_name);
    }

    public void writeEntry(String keystore_view_name, String alias, KeyStoreSpiEntry entry) throws KeyStoreException {
        this.storageManagerImpl.writeEntry(keystore_view_name, alias, entry);
    }

    public boolean isKeyEntry(String keystore_view_name, String alias) throws KeyStoreException {
        KeyStoreSpiEntry result = this.getValue(keystore_view_name, alias);
        if (result != null) {
            return result.isKeyEntry();
        }
        result = this.storageManagerImpl.readEntry(keystore_view_name, alias);
        this.putValue(keystore_view_name, alias, result);
        return result.isKeyEntry();
    }

    public String[] getKeystoreViewNames() throws KeyStoreException {
        return this.storageManagerImpl.getKeystoreViewNames();
    }

    public void createKeystoreViewEntry(String keystore_view_alias, Properties properties) throws KeyStoreException {
        this.storageManagerImpl.createKeystoreViewEntry(keystore_view_alias, properties);
    }

    public void destroyKeystoreViewEntry(String keystore_view_alias) throws KeyStoreException {
        this.storageManagerImpl.destroyKeystoreViewEntry(keystore_view_alias);
    }

    public Properties getKeystoreViewProperties(String keystore_view_name) throws KeyStoreException {
        return this.storageManagerImpl.getKeystoreViewProperties(keystore_view_name);
    }

    public void removeProperty(String keystore_view, String key) throws KeyStoreException {
        this.storageManagerImpl.removeProperty(keystore_view, key);
    }

    public void setProperty(String keystore_view, String key, String value) throws KeyStoreException {
        this.storageManagerImpl.setProperty(keystore_view, key, value);
    }

    public String getProperty(String getProperty, String key) throws KeyStoreException {
        return this.storageManagerImpl.getProperty(getProperty, key);
    }
}

