/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.dispatcher.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.keystore.interfaces.KeyStoreProvider;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.KeyStore;

public class Exists
implements Command {
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream errorStream = new PrintStream(env.getErrorStream());
        PrintWriter pw = new PrintWriter(os, true);
        if (params.length > 0 && (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help"))) {
            pw.println(this.getHelpMessage());
            return;
        }
        if (params.length != 2) {
            pw.println(this.getHelpMessage());
            return;
        }
        try {
            KeyStore keyStore = KeyStoreProvider.getKeyStore(params[0]);
            pw.println("" + keyStore.containsAlias(params[1]));
        }
        catch (Exception kse) {
            errorStream.println(kse.getMessage());
        }
    }

    public String getName() {
        return "EXISTS";
    }

    public String getGroup() {
        return "keystore";
    }

    public String getHelpMessage() {
        return "Tests if an entry with the specified alias has been stored.\nUsage: " + this.getName() + " <viewAlias> <entryAlias>\nParameters:\n       " + "<viewAlias>  - The name of the view to get the entry from.\n       " + "<entryAlias> - The name of the entry to check.\n";
    }

    public String[] getSupportedShellProviderNames() {
        return null;
    }
}

