/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.admin.gui;

import com.sap.engine.services.keystore.admin.gui.KeystoreGUIComponent;
import com.sap.engine.services.keystore.admin.gui.KeystoreManagerListener;
import com.sap.engine.services.keystore.impl.util.StringComparator;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerManagement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ViewsListPanel
extends JPanel
implements ListSelectionListener,
KeystoreGUIComponent {
    KeystoreManagerManagement keystoreManager = null;
    KeystoreManagerListener listener = null;
    JList keystores = null;
    private Frame frame = null;

    public ViewsListPanel(KeystoreManagerManagement keystoreManager) {
        this.keystoreManager = keystoreManager;
        this.keystores = new JList();
    }

    public void valueChanged(ListSelectionEvent event) {
        String selectedItem = (String)this.keystores.getSelectedValue();
        if (selectedItem != null) {
            try {
                this.listener.selectedKeystoreView(selectedItem);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.frame, e, "ViewsListPanel.refresh(): ", 0);
            }
        }
    }

    public void registerKeystoreManagerListener(KeystoreManagerListener listener) {
        this.listener = listener;
        this.keystores.addListSelectionListener(this);
    }

    public void refresh() {
        try {
            String[] keystoreViews = this.keystoreManager.getKeystoreViewAliases();
            String[] data = new String[keystoreViews.length];
            System.arraycopy(keystoreViews, 0, data, 0, keystoreViews.length);
            Arrays.sort(data, StringComparator.getInstance());
            this.keystores.setListData(data);
            this.keystores.setSelectedIndex(0);
            String selectedValue = (String)this.keystores.getSelectedValue();
            this.listener.selectedKeystoreView(selectedValue);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, e, "ViewsListPanel.refresh())", 0);
        }
    }

    public void refresh(Object value) {
    }

    public void placeComponents() {
        this.keystores.setSelectionMode(0);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.keystores), "Center");
        this.keystores.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Views "));
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }
}

