/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.admin.gui;

import com.sap.engine.services.keystore.interfaces.KeystoreManagerManagement;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MultipleEntriesSelector
extends JDialog
implements ActionListener,
ItemListener {
    public static final int SHOW_KEYS_ONLY = 0;
    public static final int SHOW_CERTS_ONLY = 1;
    public static final int SHOW_KEYS_AND_CERTS = 2;
    private KeystoreManagerManagement keystoreManager = null;
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JComboBox views = null;
    private JList entries = null;
    private String selectedView = null;
    private String[] selectedEntries = null;
    private int filter = 2;

    public MultipleEntriesSelector(Frame frame, String title, String currentViewAlias, KeystoreManagerManagement keystoreManager, boolean allowMultipleSelection, int filter) throws Exception {
        super(frame, title, true);
        this.keystoreManager = keystoreManager;
        this.filter = filter;
        JPanel mainPanel = new JPanel();
        JPanel listPanel = new JPanel();
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridBagLayout());
        buttonsPanel.add((Component)this.okButton, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 13, 2, new Insets(5, 1, 5, 1), 0, 0));
        buttonsPanel.add((Component)this.cancelButton, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 13, 2, new Insets(5, 1, 5, 1), 0, 0));
        this.okButton.setActionCommand("OK");
        this.okButton.setEnabled(false);
        this.cancelButton.setActionCommand("CANCEL");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.entries = new JList();
        this.entries.setSelectionMode(allowMultipleSelection ? 2 : 0);
        listPanel.setLayout(new GridBagLayout());
        listPanel.add((Component)new JScrollPane(this.entries), new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        listPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Select entries:  "));
        this.views = new JComboBox();
        String[] viewAliases = keystoreManager.getKeystoreViewAliases();
        int i = 0;
        while (i < viewAliases.length) {
            if (currentViewAlias == null || !currentViewAlias.equals(viewAliases[i])) {
                this.views.addItem(viewAliases[i]);
            }
            ++i;
        }
        this.views.setEditable(false);
        this.selectedView = (String)this.views.getItemAt(0);
        this.loadEntries();
        this.entries.setVisibleRowCount(5);
        this.entries.setMinimumSize(this.views.getSize());
        this.views.addItemListener(this);
        JLabel label = new JLabel("Select view: ");
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.01, 0.01, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)this.views, new GridBagConstraints(1, 0, 1, 1, 0.01, 0.01, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)buttonsPanel, new GridBagConstraints(0, 1, 1, 2, 0.01, 0.01, 11, 0, new Insets(5, 0, 5, 0), 0, 0));
        mainPanel.add((Component)listPanel, new GridBagConstraints(1, 1, 1, 2, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add(mainPanel);
        ((Component)this).setSize(500, 200);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int posX = (int)((double)d.width - this.getSize().getWidth());
        int posY = (int)((double)d.height - this.getSize().getHeight());
        ((Component)this).setLocation(posX / 2, posY / 2);
        ((Component)this).setVisible(true);
    }

    public synchronized void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            this.selectedView = (String)this.views.getSelectedItem();
            Object[] positions = this.entries.getSelectedValues();
            this.selectedEntries = new String[positions.length];
            int i = 0;
            while (i < positions.length) {
                this.selectedEntries[i] = (String)positions[i];
                ++i;
            }
            if (positions.length == 0) {
                this.selectedView = null;
                this.selectedEntries = null;
            }
        } else if (e.getActionCommand().equals("CANCEL")) {
            this.selectedView = null;
            this.selectedEntries = null;
        }
        ((Component)this).setVisible(false);
    }

    public synchronized String getSelectedView() {
        return this.selectedView;
    }

    public synchronized String[] getSelectedEntries() {
        return this.selectedEntries;
    }

    public synchronized void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.selectedView = (String)e.getItem();
            try {
                this.loadEntries();
            }
            catch (Exception re) {
                throw new RuntimeException(re.toString());
            }
        }
    }

    private void loadEntries() throws Exception {
        if (this.selectedView == null) {
            return;
        }
        String[] entryAliases = this.keystoreManager.aliases(this.selectedView);
        Vector<String> values = new Vector<String>();
        this.entries.removeAll();
        this.entries.setListData(values);
        int i = 0;
        while (i < entryAliases.length) {
            block7: {
                block8: {
                    block6: {
                        if (this.filter != 0) break block6;
                        boolean isKey = this.keystoreManager.isKeyEntry(this.selectedView, entryAliases[i]);
                        if (!isKey) break block7;
                        Key key = this.keystoreManager.readEntry(this.selectedView, entryAliases[i]).getKey();
                        String keyAlg = key.getAlgorithm();
                        if (key instanceof PrivateKey && !keyAlg.equals("DH")) break block8;
                        break block7;
                    }
                    if (this.filter == 1 && this.keystoreManager.isKeyEntry(this.selectedView, entryAliases[i])) break block7;
                }
                values.add(entryAliases[i]);
                this.okButton.setEnabled(true);
            }
            ++i;
        }
    }
}

