/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.admin.gui;

import com.sap.engine.services.keystore.admin.gui.EntriesButtonPanel;
import com.sap.engine.services.keystore.admin.gui.EntryViewer;
import com.sap.engine.services.keystore.admin.gui.KeystoreGUIComponent;
import com.sap.engine.services.keystore.admin.gui.KeystoreManagerListener;
import com.sap.engine.services.keystore.impl.KeyStoreEntry;
import com.sap.engine.services.keystore.impl.util.StringComparator;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerManagement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class KeystoreContentPanel
extends JSplitPane
implements KeystoreGUIComponent,
ListSelectionListener {
    EntriesButtonPanel buttons = null;
    EntryViewer entryViewer = null;
    JList entries = null;
    JPanel rightComponent = null;
    KeystoreManagerListener listener = null;
    KeystoreManagerManagement keystoreManager = null;
    String keystoreViewAlias = null;
    private Frame frame = null;

    public EntriesButtonPanel getEntriesButtonPanel() {
        return this.buttons;
    }

    KeystoreContentPanel(KeystoreManagerManagement keystoreManager) {
        this.keystoreManager = keystoreManager;
        this.buttons = new EntriesButtonPanel(keystoreManager);
        this.entryViewer = new EntryViewer();
        this.entries = new JList();
        this.entries.setSelectionMode(0);
        this.entries.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Entries "));
        this.rightComponent = new JPanel();
    }

    public void placeComponents() {
        this.rightComponent.setLayout(new BorderLayout());
        this.setLeftComponent(new JScrollPane(this.entries));
        this.setRightComponent(this.rightComponent);
        this.rightComponent.add((Component)new JScrollPane(this.entryViewer), "Center");
        this.rightComponent.add((Component)this.buttons, "South");
        this.entries.addListSelectionListener(this);
        this.entryViewer.placeComponents();
        this.buttons.placeComponents();
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void registerKeystoreManagerListener(KeystoreManagerListener listener) {
        this.listener = listener;
        this.buttons.registerKeystoreManagerListener(listener);
        this.entryViewer.registerKeystoreManagerListener(listener);
    }

    public synchronized void refresh() throws Exception {
        KeystoreContentPanel.dump("refresh {");
        this.buttons.refresh();
        this.entryViewer.refresh();
        super.repaint();
        KeystoreContentPanel.dump("refresh } OK");
    }

    public synchronized void refresh(Object obj) throws Exception {
        this.keystoreViewAlias = (String)obj;
        String[] entriesAliases = this.keystoreManager.aliases(this.keystoreViewAlias);
        Arrays.sort(entriesAliases, StringComparator.getInstance());
        this.entries.setListData(entriesAliases);
        if (entriesAliases.length > 0) {
            this.entries.setSelectedIndex(0);
            KeyStoreEntry entry = (KeyStoreEntry)this.keystoreManager.readEntry(this.keystoreViewAlias, entriesAliases[0]);
            this.entryViewer.refresh(entry);
            this.listener.selectedKeystoreEntry(entriesAliases[0]);
            this.buttons.refresh(new String[]{this.keystoreViewAlias, entriesAliases[0]});
        } else {
            this.entryViewer.refresh(null);
            this.buttons.refresh(new String[]{this.keystoreViewAlias});
        }
        this.refresh();
    }

    public synchronized void valueChanged(ListSelectionEvent e) {
        KeystoreContentPanel.dump("valueChanged {");
        String selectedEntry = (String)this.entries.getSelectedValue();
        if (selectedEntry != null) {
            try {
                KeystoreContentPanel.dump("  entry: " + selectedEntry);
                KeystoreContentPanel.dump("  view : " + this.keystoreViewAlias);
                KeyStoreEntry entry = (KeyStoreEntry)this.keystoreManager.readEntry(this.keystoreViewAlias, selectedEntry);
                this.entryViewer.refresh(entry);
                this.listener.selectedKeystoreEntry(selectedEntry);
            }
            catch (Throwable e1) {
                JOptionPane.showMessageDialog(this.frame, e1.toString(), "KeystoreContentPanel.valueChanged(): ", 0);
            }
        }
        KeystoreContentPanel.dump("valueChanged } OK");
    }

    private static final void dump(Object msg) {
    }
}

