/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.admin.gui;

import com.sap.engine.services.keystore.admin.gui.KeystoreGUIComponent;
import com.sap.engine.services.keystore.admin.gui.KeystoreManagerListener;
import com.sap.engine.services.keystore.impl.KeyStoreEntry;
import iaik.security.cipher.SecretKey;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class EntryViewer
extends JPanel
implements KeystoreGUIComponent {
    private JTextArea textArea = new JTextArea();
    private KeyStoreEntry entry = null;
    private Frame frame = null;

    public EntryViewer() {
        this.textArea.setEditable(false);
        this.textArea.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ""));
    }

    public void registerKeystoreManagerListener(KeystoreManagerListener listener) {
    }

    public synchronized void refresh() throws Exception {
        if (this.entry != null) {
            this.textArea.setText(this.getKeystoreEntryInfo());
            this.textArea.setCaretPosition(0);
            this.textArea.setEnabled(true);
        } else {
            this.textArea.setText("<no data>");
            this.textArea.setEnabled(false);
        }
    }

    public synchronized void refresh(Object keystoreEntryInstance) throws Exception {
        this.entry = (KeyStoreEntry)keystoreEntryInstance;
        this.refresh();
    }

    public void placeComponents() {
        this.setLayout(new BorderLayout());
        this.add(this.textArea);
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    private String getKeystoreEntryInfo() throws Exception {
        String result = "";
        String offset = "      ";
        try {
            Date creationDate = this.entry.getCreationDate();
            if (this.entry.isKeyEntry()) {
                Key key = this.entry.getKey();
                if (key instanceof PrivateKey) {
                    result = result + "PRIVATE ";
                } else if (key instanceof PublicKey) {
                    result = result + "PUBLIC ";
                } else if (key instanceof SecretKey) {
                    result = result + "SECRET ";
                }
                result = result + "KEY";
                result = result + "\n" + offset + "[ creationDate ]: " + creationDate;
                result = result + this.getKeyInfo(offset, this.entry.getKey());
                Certificate[] chain = this.entry.getCertificateChain();
                if (chain.length == 1) {
                    X509Certificate xcert = (X509Certificate)chain[0];
                    result = xcert.getIssuerDN().equals(xcert.getSubjectDN()) ? result + "\n" + offset + "[ selfSigned ]: " + this.getCertificateInfo(offset + offset, xcert) : result + "\n" + offset + "[ signedWith ]: " + this.getCertificateInfo(offset + offset, xcert);
                } else {
                    int i = 0;
                    while (i < chain.length) {
                        X509Certificate xcert = (X509Certificate)chain[i];
                        result = result + "\n" + offset + "CA[" + i + "]: " + this.getCertificateInfo(offset + offset, xcert);
                        ++i;
                    }
                }
            } else {
                X509Certificate xcert = (X509Certificate)this.entry.getCertificate();
                result = result + "CERTIFICATE";
                result = result + "\n" + offset + "[ creationDate ]: " + creationDate;
                result = result + this.getCertificateInfo(offset, xcert);
            }
        }
        catch (Exception e) {
            return e.toString();
        }
        return result;
    }

    private String getKeyInfo(String offset, Key key) {
        String result = "";
        result = result + "\n" + offset + "[ algorithm ]: " + key.getAlgorithm();
        result = result + "\n" + offset + "[ format ]: " + key.getFormat();
        return result;
    }

    private String getCertificateInfo(String offset, X509Certificate cert) {
        String result = "";
        result = result + "\n" + offset + "[ DN ]: " + cert.getSubjectDN();
        result = result + "\n" + offset + "[ issuerDN ]: " + cert.getIssuerDN();
        result = result + "\n" + offset + "[ validNotBefore ]: " + cert.getNotBefore();
        result = result + "\n" + offset + "[ validNotAfter ]: " + cert.getNotAfter();
        result = result + "\n" + offset + "[ signAlgorithm ]: " + cert.getSignatureAlgorithm();
        result = result + "\n" + offset + "[ fingerprint ]: " + EntryViewer.toString(cert.getFingerprint());
        try {
            V3Extension subjectKeyID = cert.getExtension(SubjectKeyIdentifier.oid);
            result = subjectKeyID != null ? result + "\n" + offset + "[ subjectKeyIdentifier ]: " + subjectKeyID.toString() : result + "\n" + offset + "[ subjectKeyIdentifier ]: <none>";
        }
        catch (Exception e) {
            result = result + "\n" + offset + "[ subjectKeyIdentifier ]: [error]: " + e.toString();
        }
        result = result + "\n" + offset + "[ publicKey ]: " + this.getKeyInfo(offset + offset, cert.getPublicKey());
        return result;
    }

    public static String toString(byte[] byteArray) {
        return EntryViewer.toString(byteArray, 0, byteArray.length, ":");
    }

    public static String toString(byte[] byteArray, int off, int len, String delimiter) {
        if (byteArray.length < off + len) {
            len = byteArray.length - off;
        }
        StringBuffer sb = new StringBuffer(2 * len);
        boolean first = true;
        int i = 0;
        while (i < len) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(EntryViewer.toString(byteArray[off + i]));
            ++i;
        }
        return sb.toString();
    }

    public static String toString(byte b) {
        StringBuffer sb = new StringBuffer(2);
        int h = (b & 0xF0) >> 4;
        int l = b & 0xF;
        sb.append(new Character(h > 9 ? (char)(65 + h - 10) : (char)(48 + h)));
        sb.append(new Character(l > 9 ? (char)(65 + l - 10) : (char)(48 + l)));
        return sb.toString();
    }
}

