/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.admin.gui;

import com.sap.engine.frame.client.ClientFactory;
import com.sap.engine.frame.core.thread.ClientThreadContext;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.services.keystore.admin.cert.CertificateCoder;
import com.sap.engine.services.keystore.admin.gui.MultipleEntriesSelector;
import com.sap.engine.services.keystore.admin.gui.SubjectPropertiesTableModel;
import com.sap.engine.services.keystore.interfaces.KeyStoreProvider;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerManagement;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AVA;
import iaik.asn1.structures.Name;
import iaik.asn1.structures.RDN;
import iaik.x509.X509Certificate;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class EntryCreateDialog
extends JDialog
implements ActionListener {
    private CertificateCoder certCoder;
    private Calendar calendar;
    private DateFormat dateFormat;
    private JTable subjectPanel;
    static final String[] s_KeyItems = new String[]{"1024", "512"};
    static final String[] s_AlgorithmNames = new String[]{"RSA", "DH", "DSA"};
    private Frame frame = null;
    private JTextField validityStart = new JTextField();
    private JTextField validityEnd = new JTextField();
    private JTextField alias = new JTextField("");
    private JButton generateButton = new JButton("Generate");
    private JButton exitButton = new JButton("Cancel");
    private JButton selectCAButton = new JButton("Select CA Key");
    private JComboBox keyLengthCombo = new JComboBox<String>(s_KeyItems);
    private JComboBox algorithmCombo = new JComboBox<String>(s_AlgorithmNames);
    private JCheckBox checkStore = new JCheckBox();
    private JPanel issuerPanel = new JPanel();
    private JPanel upperPanel = new JPanel();
    private JScrollPane issuerScrollPane = null;
    private JPanel mainPane = new JPanel();
    private Map objectIds = new HashMap();
    JComboBox comboBox = new JComboBox();
    TableColumn keysColumn = null;
    private KeystoreManagerManagement keystoreManager = null;
    private String writeKeystoreAlias = null;
    private String readKeystoreAlias = null;
    private KeyStore writeKeystore = null;
    private KeyStore readKeystore = null;
    private String caKeyAlias = null;

    public EntryCreateDialog(Frame frame, KeystoreManagerManagement keystoreManager, String currentKeystoreViewAlias) throws Exception {
        super(frame, true);
        try {
            KeyStore result1;
            KeyStore result;
            this.keystoreManager = keystoreManager;
            this.writeKeystoreAlias = currentKeystoreViewAlias;
            EntryCreateDialog entryCreateDialog = this;
            synchronized (entryCreateDialog) {
                result = KeyStoreProvider.getKeyStore(this.writeKeystoreAlias);
            }
            this.writeKeystore = result;
            this.readKeystoreAlias = currentKeystoreViewAlias;
            EntryCreateDialog entryCreateDialog2 = this;
            synchronized (entryCreateDialog2) {
                result1 = KeyStoreProvider.getKeyStore(this.writeKeystoreAlias);
            }
            this.readKeystore = result1;
            this.objectIds.put("streetAddress", ObjectID.streetAddress);
            this.objectIds.put("title", ObjectID.title);
            this.objectIds.put("initials", ObjectID.initials);
            this.objectIds.put("postalAddress", ObjectID.postalAddress);
            this.objectIds.put("surname", ObjectID.surName);
            this.objectIds.put("givenName", ObjectID.givenName);
            this.objectIds.put("generationQualifier", ObjectID.generationQualifier);
            this.objectIds.put("uniqueIdentifier", ObjectID.uniqueIdentifier);
            this.objectIds.put("dnQualifier", ObjectID.dnQualifier);
            this.objectIds.put("pseudonym", ObjectID.pseudonym);
            this.objectIds.put("emailAddress", ObjectID.emailAddress);
            this.alias.setPreferredSize(new Dimension(100, 20));
            this.alias.setMinimumSize(new Dimension(100, 20));
            this.mainPane.setLayout(new GridBagLayout());
            this.subjectPanel = new JTable(new SubjectPropertiesTableModel(this));
            this.keysColumn = this.subjectPanel.getColumnModel().getColumn(0);
            Object[] keys = this.objectIds.keySet().toArray();
            Arrays.sort(keys);
            this.comboBox.addItem("");
            int i = 0;
            while (i < keys.length) {
                this.comboBox.addItem(keys[i]);
                ++i;
            }
            this.algorithmCombo.setEditable(false);
            this.algorithmCombo.addActionListener(this);
            this.checkStore.setSelected(false);
            this.keysColumn.setCellEditor(new DefaultCellEditor(this.comboBox));
            JScrollPane subjectScrollPane = new JScrollPane(this.subjectPanel);
            subjectScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Subject Properties "));
            this.issuerScrollPane = new JScrollPane(new JPanel());
            this.issuerScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Issuer Info "));
            this.issuerScrollPane.add(new JLabel("Self Signed"));
            this.upperPanel.setLayout(new GridBagLayout());
            this.upperPanel.add((Component)subjectScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.upperPanel.add((Component)this.issuerScrollPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.generateButton.addActionListener(this);
            this.selectCAButton.addActionListener(this);
            this.exitButton.addActionListener(this);
            this.mainPane.add((Component)this.upperPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            JPanel attributesPanel = new JPanel();
            attributesPanel.setLayout(new GridBagLayout());
            this.calendar = Calendar.getInstance();
            this.dateFormat = DateFormat.getInstance();
            String time = this.dateFormat.format(this.calendar.getTime());
            this.validityStart.setText(time);
            this.calendar.add(1, 1);
            time = this.dateFormat.format(this.calendar.getTime());
            this.validityEnd.setText(time);
            this.keyLengthCombo.setEditable(true);
            attributesPanel.add((Component)new JLabel("Entry Name"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            attributesPanel.add((Component)this.alias, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            attributesPanel.add((Component)new JLabel("Valid From"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            attributesPanel.add((Component)this.validityStart, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            attributesPanel.add((Component)new JLabel("Valid To"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            attributesPanel.add((Component)this.validityEnd, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            attributesPanel.add((Component)new JLabel("Key Length"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            attributesPanel.add((Component)this.keyLengthCombo, new GridBagConstraints(3, 1, 1, 1, 0.1, 0.1, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
            attributesPanel.add((Component)new JLabel("Algorithm"), new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            attributesPanel.add((Component)this.algorithmCombo, new GridBagConstraints(3, 2, 1, 1, 0.1, 0.1, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
            attributesPanel.add((Component)new JLabel("Store Certificate"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            attributesPanel.add((Component)this.checkStore, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            attributesPanel.add((Component)this.selectCAButton, new GridBagConstraints(4, 0, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            attributesPanel.add((Component)this.generateButton, new GridBagConstraints(4, 1, 1, 1, 0.1, 0.1, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
            attributesPanel.add((Component)this.exitButton, new GridBagConstraints(4, 2, 1, 1, 0.1, 0.1, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
            this.mainPane.add((Component)attributesPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().add(this.mainPane);
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setSize(700, 400);
            int pos_x = (int)((double)d.width - this.getSize().getWidth());
            int pos_y = (int)((double)d.height - this.getSize().getHeight());
            ((Component)this).setLocation(pos_x / 2, pos_y / 2);
            ((Component)this).setVisible(true);
        }
        catch (Exception e) {
            this.dumpErrorMessage("Init component:", e);
            throw e;
        }
    }

    public final String getTitle() {
        return " Key and Certificate Generation ";
    }

    void selectCA() {
        try {
            try {
                MultipleEntriesSelector selector = new MultipleEntriesSelector(this.frame, "Select CA key entry: ", null, this.keystoreManager, false, 0);
                this.mainPane.setCursor(Cursor.getPredefinedCursor(3));
                this.readKeystoreAlias = selector.getSelectedView();
                this.caKeyAlias = this.readKeystoreAlias == null || selector.getSelectedEntries() == null ? "" : selector.getSelectedEntries()[0];
                Properties issuer = null;
                this.upperPanel.invalidate();
                this.upperPanel.remove(this.issuerScrollPane);
                if (!this.caKeyAlias.equals("")) {
                    try {
                        KeyStore result;
                        EntryCreateDialog entryCreateDialog = this;
                        synchronized (entryCreateDialog) {
                            result = KeyStoreProvider.getKeyStore(this.readKeystoreAlias);
                        }
                        this.readKeystore = result;
                    }
                    catch (Exception e) {
                        this.dumpErrorMessage("Cannot get a keystore view: ", e);
                        Object var7_10 = null;
                        this.mainPane.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    issuer = this.getCertificateInfo(this.caKeyAlias);
                    this.issuerPanel = new JPanel();
                    this.issuerPanel.setLayout(new GridBagLayout());
                    int counter = 0;
                    Enumeration<?> e = issuer.propertyNames();
                    while (e.hasMoreElements()) {
                        String s = (String)e.nextElement();
                        this.issuerPanel.add((Component)new JLabel(s), new GridBagConstraints(0, counter, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                        this.issuerPanel.add((Component)new JLabel(issuer.getProperty(s)), new GridBagConstraints(1, counter, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                        ++counter;
                    }
                } else {
                    this.issuerPanel = new JPanel();
                    this.issuerPanel.add(new JLabel("Self Signed"));
                    this.caKeyAlias = "";
                }
                this.issuerScrollPane = new JScrollPane(this.issuerPanel);
                this.issuerScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Issuer info "));
                this.upperPanel.add((Component)this.issuerScrollPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
                this.upperPanel.validate();
            }
            catch (Exception e) {
                this.dumpErrorMessage("Error:", e);
                Object var7_12 = null;
                this.mainPane.setCursor(Cursor.getDefaultCursor());
            }
            Object var7_11 = null;
            this.mainPane.setCursor(Cursor.getDefaultCursor());
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            this.mainPane.setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
    }

    void generate() {
        String commonName;
        if (this.alias.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(this.frame, "Key alias not entered!", "Error!", 0);
            return;
        }
        TableCellEditor subjectEditor = this.subjectPanel.getCellEditor();
        if (subjectEditor != null) {
            subjectEditor.stopCellEditing();
        }
        if ((commonName = (String)this.subjectPanel.getValueAt(5, 1)).trim().equals("")) {
            JOptionPane.showMessageDialog(this.frame, "Common Name not set!", "Error!", 0);
            this.subjectPanel.clearSelection();
            this.subjectPanel.changeSelection(5, 1, true, true);
            return;
        }
        try {
            try {
                this.mainPane.setCursor(Cursor.getPredefinedCursor(3));
                int keySize = 0;
                try {
                    keySize = Integer.valueOf((String)this.keyLengthCombo.getSelectedItem());
                }
                catch (NumberFormatException e) {
                    throw new NumberFormatException("ID21180: Invalid key length.");
                }
                String algorithmName = null;
                switch (this.algorithmCombo.getSelectedIndex()) {
                    case 0: {
                        algorithmName = "RSA";
                        break;
                    }
                    case 1: {
                        algorithmName = "DH";
                        break;
                    }
                    case 2: {
                        algorithmName = "DSA";
                    }
                }
                Calendar date1 = Calendar.getInstance();
                Calendar date2 = Calendar.getInstance();
                try {
                    DateFormat dateParser = DateFormat.getInstance();
                    dateParser.setLenient(false);
                    date1.setTime(dateParser.parse(this.validityStart.getText()));
                    date2.setTime(dateParser.parse(this.validityEnd.getText()));
                }
                catch (ParseException pe) {
                    JOptionPane.showMessageDialog(this.frame, "Incorrect date!", "Error!", 0);
                    Object var13_11 = null;
                    this.mainPane.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                this.certCoder = new CertificateCoder(this.readKeystore, this.writeKeystore, algorithmName, keySize, date1, date2);
                if (this.checkStore.isSelected()) {
                    this.certCoder.storeCertificate(true);
                }
                this.certCoder.setCAAlias(this.caKeyAlias);
                this.certCoder.setAlias(this.alias.getText().trim());
                String subjectValue = (String)this.subjectPanel.getValueAt(0, 1);
                if (!subjectValue.trim().equals("")) {
                    this.certCoder.assertSubjectValue(ObjectID.country, subjectValue);
                }
                if (!(subjectValue = (String)this.subjectPanel.getValueAt(1, 1)).trim().equals("")) {
                    this.certCoder.assertSubjectValue(ObjectID.stateOrProvince, subjectValue);
                }
                if (!(subjectValue = (String)this.subjectPanel.getValueAt(2, 1)).trim().equals("")) {
                    this.certCoder.assertSubjectValue(ObjectID.locality, subjectValue);
                }
                if (!(subjectValue = (String)this.subjectPanel.getValueAt(3, 1)).trim().equals("")) {
                    this.certCoder.assertSubjectValue(ObjectID.organization, subjectValue);
                }
                if (!(subjectValue = (String)this.subjectPanel.getValueAt(4, 1)).trim().equals("")) {
                    this.certCoder.assertSubjectValue(ObjectID.organizationalUnit, subjectValue);
                }
                this.certCoder.assertSubjectValue(ObjectID.commonName, this.subjectPanel.getValueAt(5, 1));
                if (this.subjectPanel.getRowCount() > 7) {
                    int rows = this.subjectPanel.getRowCount() - 1;
                    int i = 6;
                    while (i < rows) {
                        String temp = (String)this.subjectPanel.getValueAt(i, 0);
                        ObjectID oid = (ObjectID)this.objectIds.get(temp);
                        this.certCoder.assertSubjectValue(oid, this.subjectPanel.getValueAt(i, 1));
                        ++i;
                    }
                }
                this.certCoder.generateSignature();
                ((Component)this).setVisible(false);
            }
            catch (Exception e) {
                this.dumpErrorMessage("Unable to generate entry!", e);
                Object var13_13 = null;
                this.mainPane.setCursor(Cursor.getDefaultCursor());
            }
            Object var13_12 = null;
            this.mainPane.setCursor(Cursor.getDefaultCursor());
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.mainPane.setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.algorithmCombo)) {
            if (this.algorithmCombo.getSelectedItem().toString().equals("DH")) {
                this.generateButton.setEnabled(this.caKeyAlias != null);
            } else {
                this.generateButton.setEnabled(true);
            }
        } else if (event.getSource().equals(this.exitButton)) {
            ((Component)this).setVisible(false);
        }
        if (event.getSource().equals(this.selectCAButton)) {
            this.selectCA();
            if (this.algorithmCombo.getSelectedItem().toString().equals("DH")) {
                this.generateButton.setEnabled(this.caKeyAlias != null);
            } else {
                this.generateButton.setEnabled(true);
            }
        } else if (event.getSource().equals(this.generateButton)) {
            this.generate();
        }
    }

    private Properties getCertificateInfo(String certName) {
        Properties p = new Properties();
        try {
            Certificate[] chain = this.readKeystore.getCertificateChain(certName);
            X509Certificate cert = new X509Certificate(chain[0].getEncoded());
            Name dn = (Name)cert.getSubjectDN();
            AVA ava = null;
            Enumeration e = dn.elements();
            while (e.hasMoreElements()) {
                Enumeration en = ((RDN)e.nextElement()).elements();
                while (en.hasMoreElements()) {
                    ava = (AVA)en.nextElement();
                    p.setProperty(ava.getType().getName(), (String)ava.getValue());
                }
            }
        }
        catch (KeyStoreException e) {
            this.dumpErrorMessage("Can not get certificate info!", e);
        }
        catch (CertificateEncodingException cee) {
            this.dumpErrorMessage("Can not get certificate info!", new KeyStoreException("ID21107: Certificate encoding error."));
        }
        catch (CertificateException ce) {
            this.dumpErrorMessage("Can not get certificate info!", new KeyStoreException("ID21107: Certificate error."));
        }
        return p;
    }

    private void dumpErrorMessage(String message, Exception e) {
        String show = e.getClass().getName();
        int position = show.lastIndexOf(".") + 1;
        int end = show.lastIndexOf("Exception");
        StringBuffer buffer = new StringBuffer(show.length() - position);
        buffer.append(show.charAt(position));
        ++position;
        end = end < 0 ? show.length() : end;
        while (position < end) {
            if (Character.isUpperCase(show.charAt(position))) {
                buffer.append(" ");
                buffer.append(Character.toLowerCase(show.charAt(position)));
            } else {
                buffer.append(show.charAt(position));
            }
            ++position;
        }
        buffer.append(":\n");
        buffer.append(e.getMessage());
        JOptionPane.showMessageDialog(this.frame, buffer.toString(), message, 0);
    }

    private void dumpErrorMessage(String message) {
        JOptionPane.showMessageDialog(this.frame, "Error!!!", message, 0);
    }

    private String getCurrentUser() throws Exception {
        ClientThreadContext threadContext = ClientFactory.getThreadContextFactory().getThreadContext();
        SecurityContextObject contextObject = (SecurityContextObject)((Object)threadContext.getContextObject("security"));
        if (contextObject != null) {
            if (contextObject.getSession() != null) {
                return "{" + contextObject.getSession().getPrincipal().toString() + "}: ";
            }
            return "{NULL session}: ";
        }
        return "{NULL context Object}: ";
    }
}

