/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.admin.cert;

import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AVA;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.asn1.structures.RDN;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Random;

public class CertificateCoder {
    private X509Certificate x509;
    private Name issuer;
    private Name subject;
    private PrivateKey signKey;
    private KeyPairGenerator generator;
    private KeyPair keyPair;
    private String alias;
    private String caalias;
    private Certificate[] certchain;
    private boolean storeCertificate = false;
    private KeyStore readKeystore = null;
    private KeyStore writeKeystore = null;
    private AlgorithmID algorithmID = null;

    public CertificateCoder(KeyStore readKeystore, KeyStore writeKeystore, String algorithm, int keySize, Calendar fromDate, Calendar toDate) throws KeyStoreException, IOException, NoSuchAlgorithmException, InvalidKeyException {
        this.readKeystore = readKeystore;
        this.writeKeystore = writeKeystore;
        this.x509 = new X509Certificate();
        this.generator = KeyPairGenerator.getInstance(algorithm);
        this.generator.initialize(keySize);
        this.keyPair = this.generator.generateKeyPair();
        byte[] bytes = new byte[4];
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(bytes);
        this.x509.setSerialNumber(new BigInteger(1, bytes));
        this.issuer = new Name();
        this.subject = new Name();
        this.x509.setValidNotBefore(fromDate.getTime());
        this.x509.setValidNotAfter(toDate.getTime());
        this.x509.setPublicKey(this.keyPair.getPublic());
        try {
            this.x509.addExtension((V3Extension)new SubjectKeyIdentifier(this.keyPair.getPublic()));
        }
        catch (X509ExtensionException e) {
            throw new KeyStoreException(e.toString());
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (CodingException e) {
            throw new KeyStoreException(e.toString());
        }
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setCAAlias(String caalias) {
        this.caalias = caalias;
    }

    public void assertIssuerValue(ObjectID oid, Object value) {
        this.issuer.addRDN(oid, value);
    }

    public void assertSubjectValue(ObjectID oid, Object value) {
        this.subject.addRDN(oid, value);
    }

    public byte[] getBytes() throws CertificateEncodingException {
        return this.x509.getEncoded();
    }

    public void generateSignature() throws KeyStoreException {
        try {
            ByteArrayInputStream input = null;
            CertificateFactory cf = null;
            java.security.cert.X509Certificate cert = null;
            X509Certificate issuerCert = null;
            Certificate[] subjectCertChain = null;
            this.x509.setSubjectDN((Principal)this.subject);
            if (this.caalias == null || this.caalias.length() == 0) {
                this.signKey = this.keyPair.getPrivate();
                this.x509.setIssuerDN((Principal)this.subject);
            } else {
                this.signKey = (PrivateKey)this.readKeystore.getKey(this.caalias, new char[0]);
                this.certchain = this.readKeystore.getCertificateChain(this.caalias);
                issuerCert = new X509Certificate(this.certchain[0].getEncoded());
                this.setIssuer((Name)issuerCert.getSubjectDN());
                this.x509.setIssuerDN((Principal)this.issuer);
            }
            this.algorithmID = this.signKey.getAlgorithm().equals("DSA") ? AlgorithmID.dsaWithSHA : (this.signKey.getAlgorithm().equals("DH") ? AlgorithmID.dhKeyAgreement : AlgorithmID.md5WithRSAEncryption);
            this.x509.sign(this.algorithmID, this.signKey);
            input = new ByteArrayInputStream(this.x509.getEncoded());
            cf = CertificateFactory.getInstance("X.509");
            cert = (java.security.cert.X509Certificate)cf.generateCertificate(input);
            input.close();
            if (this.certchain == null) {
                this.writeKeystore.setKeyEntry(this.alias, this.keyPair.getPrivate(), new char[0], new Certificate[]{cert});
            } else {
                subjectCertChain = new Certificate[this.certchain.length + 1];
                System.arraycopy(this.certchain, 0, subjectCertChain, 1, this.certchain.length);
                subjectCertChain[0] = cert;
                this.writeKeystore.setKeyEntry(this.alias, this.keyPair.getPrivate(), new char[0], subjectCertChain);
            }
            if (this.storeCertificate) {
                this.writeKeystore.setCertificateEntry(this.alias + "-cert", cert);
            }
        }
        catch (KeyStoreException kse) {
            kse.printStackTrace();
            throw kse;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KeyStoreException("ID21140: " + e);
        }
    }

    public void setIssuer(Name name) {
        AVA ava = null;
        Enumeration e = name.elements();
        while (e.hasMoreElements()) {
            Enumeration en = ((RDN)e.nextElement()).elements();
            while (en.hasMoreElements()) {
                ava = (AVA)en.nextElement();
                this.assertIssuerValue(ava.getType(), ava.getValue());
            }
        }
    }

    public void storeCertificate(boolean value) {
        this.storeCertificate = value;
    }
}

