/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.admin.cert;

import com.sap.engine.lib.security.Base64;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.pkcs.pkcs10.CertificateRequest;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class CSRCoder {
    private CertificateRequest request = null;
    private Certificate[] chain = null;
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;
    private KeyStore readKeystore = null;
    private Name name;
    private AlgorithmID algorithm = AlgorithmID.md5WithRSAEncryption;

    public CSRCoder(String alias, KeyStore readKeystore) throws Exception {
        this.readKeystore = readKeystore;
        this.privateKey = (PrivateKey)readKeystore.getKey(alias, new char[0]);
        this.chain = readKeystore.getCertificateChain(alias);
        this.publicKey = this.chain[0].getPublicKey();
        this.name = (Name)((X509Certificate)this.chain[0]).getSubjectDN();
    }

    public void setCertificationRequestNameProperty(ObjectID oid, Object value) {
        this.name.addRDN(oid, value);
    }

    public void generateRequest(OutputStream out) throws Exception {
        this.request = new CertificateRequest(this.publicKey, this.name);
        if (this.privateKey.getAlgorithm().equals("DSA")) {
            this.algorithm = AlgorithmID.dsaWithSHA;
        }
        this.request.sign(this.algorithm, this.privateKey);
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        this.request.writeTo((OutputStream)bytestream);
        byte[] data = Base64.encode(bytestream.toByteArray());
        out.write("-----BEGIN NEW CERTIFICATE REQUEST-----\n".getBytes());
        out.write(data);
        out.write("\n-----END NEW CERTIFICATE REQUEST-----\n\n".getBytes());
        out.close();
    }
}

