/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.shellcmd;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jndi.implclient.ClientContext;
import com.sap.engine.services.jndi.shellcmd.ServCLUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;

public class PrintNamingServ
implements Command {
    private PrintStream writer;
    private PrintStream errorStream;
    private static ServCLUtils utl = new ServCLUtils();

    public void exec(Environment env, InputStream is, OutputStream os, String[] s) {
        this.errorStream = new PrintStream(env.getErrorStream());
        this.writer = new PrintStream(os);
        if (s.length > 0 && (s[0].equalsIgnoreCase("-h") || s[0].equalsIgnoreCase("-help") || s[0].equals("-?"))) {
            this.writer.println(this.getHelpMessage());
        } else {
            try {
                if (ServCLUtils.ctx == null) {
                    this.writer.println("Connecting... ");
                    Properties p = new Properties();
                    ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                    ServCLUtils.ctx = new InitialDirContext(p);
                    this.writer.println("ok.");
                }
                ((ClientContext)ServCLUtils.ctx.lookup("")).print(this.writer);
            }
            catch (NamingException eNaming) {
                this.errorStream.println("[Shell -> LSR] NamingException");
                this.errorStream.println("[Shell -> LSR] Reason : " + eNaming.getExplanation());
            }
        }
    }

    public String getName() {
        return "LSR";
    }

    public String getGroup() {
        return "NAMING";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        return "  Displays the containers in the database as a tree." + ServCLUtils.newLineSeparator + "    Usage: LSR";
    }
}

