/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.shellcmd;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jndi.implclient.ClientContext;
import com.sap.engine.services.jndi.shellcmd.ServCLUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class ListNamingServ
implements Command {
    private PrintStream writer;
    private PrintStream errorStream;
    private static ServCLUtils utl = new ServCLUtils();

    public void exec(Environment env, InputStream is, OutputStream os, String[] s) {
        this.errorStream = new PrintStream(env.getErrorStream());
        this.writer = new PrintStream(os);
        if (s.length > 0 && (s[0].equalsIgnoreCase("-h") || s[0].equalsIgnoreCase("-help") || s[0].equals("-?"))) {
            this.writer.println(this.getHelpMessage());
            return;
        }
        if (s.length > 2) {
            this.writer.println(this.getHelpMessage());
            return;
        }
        try {
            Object ctx;
            String loc = null;
            boolean listClassNames = false;
            int i = 0;
            while (i < s.length) {
                if (s[i].equalsIgnoreCase("-C")) {
                    listClassNames = true;
                } else {
                    loc = s[i];
                }
                ++i;
            }
            if (loc == null) {
                loc = ServCLUtils.relativePath;
            }
            loc = utl.modifyPath(loc);
            this.writer.println("[Shell -> LSN] Location : " + loc);
            if (ServCLUtils.ctx == null) {
                this.writer.println("Connecting... ");
                Properties p = new Properties();
                ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                ServCLUtils.ctx = new InitialDirContext(p);
                this.writer.println("ok.");
            }
            if ((ctx = ServCLUtils.ctx.lookup(loc)) instanceof Context || ctx instanceof DirContext) {
                ((ClientContext)ServCLUtils.ctx.lookup(loc)).lsn(this.writer, listClassNames);
            } else {
                this.errorStream.println("[Shell -> LSN] '" + loc + "' is not a context !");
            }
        }
        catch (NamingException eNaming) {
            this.errorStream.println("[Shell -> LSN] NamingException");
            this.errorStream.println("[Shell -> LSN] Reason : " + eNaming.getExplanation());
        }
    }

    public String getName() {
        return "LSN";
    }

    public String getGroup() {
        return "NAMING";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        return "  Displays the naming system as a tree." + ServCLUtils.newLineSeparator + "    Usage: LSN [location] [-c]" + ServCLUtils.newLineSeparator + "    Parameters:" + ServCLUtils.newLineSeparator + "      [location] - the path to print." + ServCLUtils.newLineSeparator + "      [-c] - output class names" + ServCLUtils.newLineSeparator + "      If location is not specified, prints the working context.";
    }
}

