/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.shellcmd;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jndi.shellcmd.ServCLUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;

public class JNDISearchServ
implements Command {
    private PrintStream writer;
    private PrintStream errorStream;
    private static ServCLUtils utl = new ServCLUtils();

    public void exec(Environment env, InputStream is, OutputStream os, String[] s) {
        this.errorStream = new PrintStream(env.getErrorStream());
        this.writer = new PrintStream(os);
        try {
            String loc = new String("");
            if (s.length == 1) {
                if (s[0].equalsIgnoreCase("-h") || s[0].equalsIgnoreCase("-help") || s[0].equals("-?")) {
                    this.writer.println(this.getHelpMessage());
                    return;
                }
            } else {
                this.writer.println(this.getHelpMessage());
                return;
            }
            loc = s[0];
            if (ServCLUtils.ctx == null) {
                this.writer.println("Trying to connect... ");
                Properties p = new Properties();
                ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                ServCLUtils.ctx = new InitialDirContext(p);
                this.writer.println("Connected.");
            }
            loc = utl.modifyPath(loc);
            this.writer.println("[Shell -> SEARCH] Location : " + loc);
            if (ServCLUtils.ctx.lookup(loc) instanceof DirContext || ServCLUtils.ctx.lookup(loc) instanceof Context) {
                NamingEnumeration<SearchResult> ne = ServCLUtils.ctx.search(loc, (Attributes)ServCLUtils.attributes);
                this.writer.println(ServCLUtils.newLineSeparator + "[Shell -> SEARCH] Found :");
                while (ne.hasMore()) {
                    SearchResult sr = ne.next();
                    this.writer.println("+ " + sr.getName() + ServCLUtils.newLineSeparator + "  [Class name] " + sr.getClassName() + ServCLUtils.newLineSeparator + "  [Attributes] " + sr.getAttributes());
                }
            } else {
                this.writer.println(ServCLUtils.newLineSeparator + "[JNDIShell] Not a subcontext !");
            }
        }
        catch (NamingException eNaming) {
            this.errorStream.println("[Shell -> SEARCH] NamingException");
            this.errorStream.println("[Shell -> SEARCH] Reason : " + eNaming.getExplanation());
        }
    }

    public String getName() {
        return "SEARCH";
    }

    public String getGroup() {
        return "NAMING";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        return "  Searches a location for matches with the attributes from ATTR." + ServCLUtils.newLineSeparator + "    Usage: SEARCH <location>" + ServCLUtils.newLineSeparator + "    Parameters:" + ServCLUtils.newLineSeparator + "      <location> - the path to the location.";
    }
}

