/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.shellcmd;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jndi.shellcmd.ServCLUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;

public class JNDIRSubServ
implements Command {
    private PrintStream writer;
    private PrintStream errorStream;
    private static ServCLUtils utl = new ServCLUtils();

    public void exec(Environment env, InputStream is, OutputStream os, String[] s) {
        block7: {
            this.errorStream = new PrintStream(env.getErrorStream());
            this.writer = new PrintStream(os);
            if (s.length == 0 || s[0].equalsIgnoreCase("-h") || s[0].equalsIgnoreCase("-help") || s[0].equals("-?")) {
                this.writer.println(this.getHelpMessage());
                return;
            }
            try {
                if (s.length == 1) {
                    String loc = s[0];
                    loc = utl.modifyPath(loc);
                    this.writer.println("[Shell -> RSUB] Location : " + loc);
                    if (loc.equals(ServCLUtils.relativePath)) {
                        this.errorStream.println("[Shell -> RSUB] Can not destroy the working context !");
                        this.errorStream.println("[Shell -> RSUB] Change the context with CD and try again !");
                    } else {
                        if (ServCLUtils.ctx == null) {
                            this.writer.println("Trying to connect... ");
                            Properties p = new Properties();
                            ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                            ServCLUtils.ctx = new InitialDirContext(p);
                            this.writer.println("Connected.");
                        }
                        ServCLUtils.ctx.destroySubcontext(loc);
                        this.writer.println("[Shell -> RSUB] Destroyed : " + loc);
                        this.writer.println();
                    }
                    break block7;
                }
                this.writer.println(this.getHelpMessage());
                return;
            }
            catch (NamingException eNaming) {
                this.errorStream.println("[Shell -> RSUB] NamingException");
                this.errorStream.println("[Shell -> RSUB] Reason : " + eNaming.getExplanation());
            }
        }
    }

    public String getName() {
        return "RSUB";
    }

    public String getGroup() {
        return "NAMING";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        return "  Removes a subcontext." + ServCLUtils.newLineSeparator + "    Usage: RSUB <location>" + ServCLUtils.newLineSeparator + "    Parameters:" + ServCLUtils.newLineSeparator + "      <location> - the name of the subcontext.";
    }
}

