/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.shellcmd;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jndi.shellcmd.ServCLUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class JNDIMAttrServ
implements Command {
    private PrintStream writer;
    private PrintStream errorStream;
    private static ServCLUtils utl = new ServCLUtils();

    public void exec(Environment env, InputStream is, OutputStream os, String[] s) {
        this.errorStream = new PrintStream(env.getErrorStream());
        this.writer = new PrintStream(os);
        if (s.length == 0 || s[0].equalsIgnoreCase("-h") || s[0].equalsIgnoreCase("-help") || s[0].equals("-?")) {
            this.writer.println(this.getHelpMessage());
            return;
        }
        try {
            String loc = new String("");
            int mode = 1;
            int i = 0;
            while (i < s.length) {
                if (s[i].equalsIgnoreCase("-a")) {
                    mode = 1;
                } else if (s[i].equalsIgnoreCase("-rm")) {
                    mode = 3;
                } else if (s[i].equalsIgnoreCase("-rp")) {
                    mode = 2;
                } else {
                    loc = s[i];
                    if (s.length > i + 1) {
                        this.writer.println(this.getHelpMessage());
                        return;
                    }
                }
                ++i;
            }
            loc = utl.modifyPath(loc);
            this.writer.println("[Shell -> MATTR] Location : " + loc);
            if (ServCLUtils.ctx == null) {
                this.writer.println("Trying to connect... ");
                Properties p = new Properties();
                ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                ServCLUtils.ctx = new InitialDirContext(p);
                this.writer.println("Connected.");
            }
            ServCLUtils.ctx.modifyAttributes(loc, mode, (Attributes)ServCLUtils.attributes);
            this.writer.println("[Shell -> MATTR] Modified : " + loc);
            this.writer.println();
        }
        catch (NamingException eNaming) {
            this.errorStream.println("[Shell -> MATTR] NamingException");
            this.errorStream.println("[Shell -> MATTR] Reason : " + eNaming.getExplanation());
        }
    }

    public String getName() {
        return "MATTR";
    }

    public String getGroup() {
        return "NAMING";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        return "  Modifies attributes using the attributes from ATTR." + ServCLUtils.newLineSeparator + "    Usage: MATTR <-a|-rp|-rm> <location>" + ServCLUtils.newLineSeparator + "      Parameters:" + ServCLUtils.newLineSeparator + "        <-a>  - Adds the attributes. Default." + ServCLUtils.newLineSeparator + "        <-rp> - Replaces the attributes." + ServCLUtils.newLineSeparator + "        <-rm> - Removes the attributes." + ServCLUtils.newLineSeparator + "        <location> - the name of the item";
    }
}

