/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.shellcmd;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jndi.PermissionAdministrator;
import com.sap.engine.services.jndi.gui.AccessListObject;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;

public class JNDILsecServ
implements Command {
    private PrintStream writer;
    private PrintStream errorStream;
    private static final String[] permsNames = new String[]{"AllOps:    ", "GetInitCtx:"};

    public void exec(Environment env, InputStream is, OutputStream os, String[] s) {
        this.errorStream = new PrintStream(env.getErrorStream());
        this.writer = new PrintStream(os);
        if (s.length > 0 && (s[0].equalsIgnoreCase("-h") || s[0].equalsIgnoreCase("-help") || s[0].equals("-?"))) {
            this.writer.println(this.getHelpMessage());
        } else {
            try {
                this.writer.println("[Shell -> LSEC] Getting permissions...");
                this.writer.println();
                this.printSecurity();
                this.writer.println();
            }
            catch (RemoteException eRemote) {
                this.errorStream.println("[Shell -> LSEC] RemoteException: " + eRemote.toString());
            }
        }
    }

    private void printSecurity() throws RemoteException {
        AccessListObject[][] users = (AccessListObject[][])new PermissionAdministrator().getPermissions();
        int i = 0;
        while (i < users.length) {
            int j = 0;
            while (j < 2) {
                this.writer.print(" ");
                ++j;
            }
            this.writer.print(permsNames[i]);
            this.writer.print(" [");
            int j2 = 0;
            while (j2 < users[i].length) {
                if (j2 > 0) {
                    this.writer.print(", ");
                }
                this.writer.print(users[i][j2].getName() + (users[i][j2].isUser() ? "" : "(group)"));
                ++j2;
            }
            this.writer.println("] ");
            ++i;
        }
    }

    public String getName() {
        return "LSEC";
    }

    public String getGroup() {
        return "NAMING";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        return "  Lists the security permissions for all contexts.\r\n    Usage: LSEC ";
    }
}

