/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.shellcmd;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jndi.shellcmd.ServCLUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class JNDIDelTreeServ
implements Command {
    private PrintStream writer;
    private PrintStream errorStream;
    private static ServCLUtils utl = new ServCLUtils();

    public void exec(Environment env, InputStream is, OutputStream os, String[] s) {
        block9: {
            this.errorStream = new PrintStream(env.getErrorStream());
            this.writer = new PrintStream(os);
            if (s.length == 0 || s[0].equalsIgnoreCase("-h") || s[0].equalsIgnoreCase("-help") || s[0].equals("-?")) {
                this.writer.println(this.getHelpMessage());
                return;
            }
            if (s.length == 1) {
                try {
                    String loc = s[0];
                    loc = utl.modifyPath(loc);
                    this.writer.println("[Shell -> DELTREE] Location : " + loc);
                    if (ServCLUtils.ctx == null) {
                        this.writer.println("Trying to connect... ");
                        Properties p = new Properties();
                        ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                        ServCLUtils.ctx = new InitialDirContext(p);
                        this.writer.println("Connected.");
                    }
                    if (loc.equals("/")) {
                        this.errorStream.println("[Shell -> DELTREE] NamingException");
                        this.errorStream.println("[Shell -> DELTREE] Reason : Can not delete the root context");
                        return;
                    }
                    Object obj = ServCLUtils.ctx.lookup(loc);
                    if (obj != null) {
                        if (obj instanceof Context || obj instanceof DirContext) {
                            this.deleteSubTree(loc);
                            ServCLUtils.ctx.destroySubcontext(loc);
                            this.writer.println("[Shell -> DELTREE] Deleted : " + loc);
                            this.writer.println();
                        }
                        break block9;
                    }
                    this.writer.println("[Shell -> DELTREE] The location specified is not a context : " + loc);
                    this.writer.println();
                }
                catch (NamingException eNaming) {
                    this.errorStream.println("[Shell -> DELTREE] NamingException");
                    this.errorStream.println("[Shell -> DELTREE] Reason : " + eNaming.getExplanation());
                }
            } else {
                this.writer.println(this.getHelpMessage());
                return;
            }
        }
    }

    private void deleteSubTree(String location) throws NamingException {
        NamingEnumeration<NameClassPair> namingEnumeration = ServCLUtils.ctx.list(location);
        while (namingEnumeration.hasMore()) {
            NameClassPair item = namingEnumeration.next();
            if (utl.isContext(item.getClassName())) {
                this.deleteSubTree(location + "/" + item.getName());
                ServCLUtils.ctx.destroySubcontext(location + "/" + item.getName());
                continue;
            }
            ServCLUtils.ctx.unbind(location + "/" + item.getName());
        }
    }

    public String getName() {
        return "DELTREE";
    }

    public String getGroup() {
        return "NAMING";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        return "  Deletes all entities under the specified context." + ServCLUtils.newLineSeparator + "    Usage: DELTREE <location>" + ServCLUtils.newLineSeparator + "    Parameters:" + ServCLUtils.newLineSeparator + "      <location> - the path to the location.";
    }
}

