/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.shellcmd;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jndi.shellcmd.ServCLUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class JNDICdServ
implements Command {
    private PrintStream writer;
    private PrintStream errorStream;
    private static ServCLUtils utl = new ServCLUtils();

    public void exec(Environment env, InputStream is, OutputStream os, String[] s) {
        block7: {
            this.errorStream = new PrintStream(env.getErrorStream());
            this.writer = new PrintStream(os);
            if (s.length > 0 && (s[0].equalsIgnoreCase("-h") || s[0].equalsIgnoreCase("-help") || s[0].equals("-?"))) {
                this.writer.println(this.getHelpMessage());
                return;
            }
            if (s.length == 1) {
                try {
                    String loc = s[0];
                    if (ServCLUtils.ctx == null) {
                        this.writer.println("Trying to connect... ");
                        Properties p = new Properties();
                        ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                        ServCLUtils.ctx = new InitialDirContext(p);
                        this.writer.println("Connected.");
                    }
                    loc = utl.modifyPath(loc);
                    this.writer.println("[Shell -> CD] Location : " + loc);
                    Object obj = ServCLUtils.ctx.lookup(loc);
                    if (obj == null) break block7;
                    if (obj instanceof Context || obj instanceof DirContext) {
                        ServCLUtils.relativePath = loc;
                        this.writer.println("[Shell -> CD] Changed.");
                        break block7;
                    }
                    this.errorStream.println("[Shell -> CD] '" + loc + "' is not a context !");
                }
                catch (NamingException eNaming) {
                    this.errorStream.println("[Shell -> CD] NamingException");
                    this.errorStream.println("[Shell -> CD] Reason : " + eNaming.getExplanation());
                }
            } else {
                this.writer.println(this.getHelpMessage());
                return;
            }
        }
    }

    public String getName() {
        return "CD";
    }

    public String getGroup() {
        return "NAMING";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        return "  Changes the current context." + ServCLUtils.newLineSeparator + "    Usage: CD <location>" + ServCLUtils.newLineSeparator + "    Parameters:" + ServCLUtils.newLineSeparator + "      <location> - the path to the location.";
    }
}

