/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.pool;

import com.sap.engine.services.jndi.cache.ObjectItem;
import com.sap.engine.services.jndi.persistent.exceptions.IllegalArgumentException;

public final class ObjectItemPool {
    private int initialSize;
    private int resizeStep = 100;
    private int pos;
    private ObjectItem[] arrayOfObjects;

    public ObjectItemPool(int initSize, int step) {
        if (step < 1 || initSize < 1) {
            throw new IllegalArgumentException(IllegalArgumentException.WRONG_INIT_SIZE_OR_RESIZE_PARAMETER, new Object[]{new Integer(initSize), new Integer(step)});
        }
        this.initialSize = initSize;
        this.resizeStep = step;
        this.arrayOfObjects = new ObjectItem[this.initialSize];
        int i = 0;
        while (i < this.initialSize) {
            this.arrayOfObjects[i] = new ObjectItem();
            ++i;
        }
        this.pos = this.initialSize - 1;
    }

    public synchronized ObjectItem getObject() {
        return new ObjectItem();
    }

    public synchronized void releaseObject(ObjectItem obj) {
    }

    public synchronized void setResizeStep(int step) {
        if (step < 1) {
            throw new IllegalArgumentException(IllegalArgumentException.WRONG_RESIZE_PARAMETER, new Object[]{new Integer(step)});
        }
        this.resizeStep = step;
    }

    public int getResizeStep() {
        return this.resizeStep;
    }

    public synchronized void setInitialSize(int initSize) {
        if (initSize < 1) {
            throw new IllegalArgumentException(IllegalArgumentException.WRONG_INIT_SIZE_PARAMETER, new Object[]{new Integer(initSize)});
        }
        this.initialSize = initSize;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void release() {
        int i = 0;
        while (i < this.pos) {
            this.arrayOfObjects[i] = null;
            ++i;
        }
    }

    public synchronized void forceShrink() {
        int usedElements = this.arrayOfObjects.length - this.pos - 1;
        if (usedElements >= this.initialSize) {
            if (this.pos >= 0) {
                this.arrayOfObjects = new ObjectItem[usedElements];
                this.pos = -1;
            }
        } else if (this.arrayOfObjects.length != this.initialSize) {
            ObjectItem[] tempArr = new ObjectItem[this.initialSize];
            int newPos = this.initialSize - usedElements - 1;
            if (newPos <= this.pos) {
                System.arraycopy(this.arrayOfObjects, 0, tempArr, 0, newPos + 1);
            } else {
                if (this.pos >= 0) {
                    System.arraycopy(this.arrayOfObjects, 0, tempArr, 0, this.pos + 1);
                }
                int i = this.pos + 1;
                while (i < newPos) {
                    tempArr[i] = new ObjectItem();
                    ++i;
                }
            }
            this.arrayOfObjects = tempArr;
            this.pos = newPos;
        }
    }

    private void autoResize() {
        ObjectItem[] tempArr = new ObjectItem[this.arrayOfObjects.length + this.resizeStep];
        int i = 0;
        while (i < this.resizeStep) {
            tempArr[i] = new ObjectItem();
            ++i;
        }
        this.arrayOfObjects = tempArr;
        this.pos = this.resizeStep - 1;
    }
}

