/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.pool;

import com.sap.engine.services.jndi.cache.HName;
import com.sap.engine.services.jndi.persistent.exceptions.IllegalArgumentException;

public final class HNamePool {
    private int initialSize;
    private int resizeStep = 100;
    private int pos;
    private HName[] arrayOfHNames;

    public HNamePool(int initSize, int step) {
        if (step < 1 || initSize < 1) {
            throw new IllegalArgumentException(IllegalArgumentException.WRONG_INIT_SIZE_OR_RESIZE_PARAMETER, new Object[]{new Integer(initSize), new Integer(step)});
        }
        this.initialSize = initSize;
        this.resizeStep = step;
        this.arrayOfHNames = new HName[this.initialSize];
        int i = 0;
        while (i < this.initialSize) {
            this.arrayOfHNames[i] = new HName();
            ++i;
        }
        this.pos = this.initialSize - 1;
    }

    public synchronized HName getObject() {
        return new HName();
    }

    public synchronized void releaseObject(HName obj) {
    }

    public synchronized void setResizeStep(int step) {
        if (step < 1) {
            throw new IllegalArgumentException(IllegalArgumentException.WRONG_RESIZE_PARAMETER, new Object[]{new Integer(step)});
        }
        this.resizeStep = step;
    }

    public int getResizeStep() {
        return this.resizeStep;
    }

    public synchronized void setInitialSize(int initSize) {
        if (initSize < 1) {
            throw new IllegalArgumentException(IllegalArgumentException.WRONG_INIT_SIZE_PARAMETER, new Object[]{new Integer(initSize)});
        }
        this.initialSize = initSize;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void release() {
        int i = 0;
        while (i < this.pos) {
            this.arrayOfHNames[i] = null;
            ++i;
        }
    }

    public synchronized void forceShrink() {
        int usedElements = this.arrayOfHNames.length - this.pos - 1;
        if (usedElements >= this.initialSize) {
            if (this.pos >= 0) {
                this.arrayOfHNames = new HName[usedElements];
                this.pos = -1;
            }
        } else if (this.arrayOfHNames.length != this.initialSize) {
            HName[] tempArr = new HName[this.initialSize];
            int newPos = this.initialSize - usedElements - 1;
            if (newPos <= this.pos) {
                System.arraycopy(this.arrayOfHNames, 0, tempArr, 0, newPos + 1);
            } else {
                if (this.pos >= 0) {
                    System.arraycopy(this.arrayOfHNames, 0, tempArr, 0, this.pos + 1);
                }
                int i = this.pos + 1;
                while (i < newPos) {
                    tempArr[i] = new HName();
                    ++i;
                }
            }
            this.arrayOfHNames = tempArr;
            this.pos = newPos;
        }
    }

    private void autoResize() {
        HName[] tempArr = new HName[this.arrayOfHNames.length + this.resizeStep];
        int i = 0;
        while (i < this.resizeStep) {
            tempArr[i] = new HName();
            ++i;
        }
        this.arrayOfHNames = tempArr;
        this.pos = this.resizeStep - 1;
    }
}

