/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.persistentimpl.memory;

import com.sap.engine.lib.lang.Convert;
import com.sap.engine.lib.util.ConcurrentHashMapLongObject;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.services.jndi.Constants;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.cache.CacheCommunicatorImpl;
import com.sap.engine.services.jndi.cluster.DirObject;
import com.sap.engine.services.jndi.implserver.ServerContextImpl;
import com.sap.engine.services.jndi.persistent.JNDIHandle;
import com.sap.engine.services.jndi.persistent.JNDIHandleEnumeration;
import com.sap.engine.services.jndi.persistent.JNDIPersistentRepository;
import com.sap.engine.services.jndi.persistent.Serializator;
import com.sap.engine.services.jndi.persistent.exceptions.JNDIException;
import com.sap.engine.services.jndi.persistentimpl.memory.Container;
import com.sap.engine.services.jndi.persistentimpl.memory.IDGenerator;
import com.sap.engine.services.jndi.persistentimpl.memory.JNDIHandleImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.StringTokenizer;

public class JNDIMemoryImpl
implements JNDIPersistentRepository,
Serializable {
    static final long serialVersionUID = 5826569922198173170L;
    static JNDIHandle root = null;
    private CacheCommunicatorImpl communicator = null;
    static ConcurrentHashMapLongObject containersById = new ConcurrentHashMapLongObject();
    static ConcurrentHashMapObjectObject containersByName = new ConcurrentHashMapObjectObject();
    static boolean opened = false;
    static int clusterId = 0;
    static final int MAX_INIT_SIZE = 1000;
    static IDGenerator cidsR = new IDGenerator(1000, 1000, 1000);
    static IDGenerator oidsR = new IDGenerator(1000, 1000, 1000);
    static IDGenerator cids = new IDGenerator(1000, 1000, 1000);
    static IDGenerator oids = new IDGenerator(1000, 1000, 1000);
    static int oidInitNumber = 1000;
    static int cidInitNumber = 1000;
    static int oidInitCounter = 1000;
    static int cidInitCounter = 1000;

    public void open() throws JNDIException {
        if (opened) {
            return;
        }
        opened = true;
    }

    public void close() throws JNDIException {
        opened = false;
    }

    public JNDIMemoryImpl() {
        if (root == null) {
            try {
                root = this.createContainer("root", new byte[0], false);
            }
            catch (JNDIException e) {
                JNDIFrame.log.logCatching((Throwable)((Object)e));
            }
        }
    }

    public void setCommunicator(CacheCommunicatorImpl cc) {
        this.communicator = cc;
        clusterId = CacheCommunicatorImpl.clContext.getClusterMonitor().getCurrentParticipant().getClusterId();
    }

    private long getNewRCID() {
        return JNDIMemoryImpl.twoIntsToLong(cidsR.getID(), clusterId);
    }

    private long getNewROID() {
        return JNDIMemoryImpl.twoIntsToLong(oidsR.getID(), clusterId);
    }

    public JNDIPersistentRepository getNewConnection() throws JNDIException {
        this.dump(" ---- new connection ");
        JNDIMemoryImpl memory = new JNDIMemoryImpl();
        memory.setCommunicator(this.communicator);
        return memory;
    }

    Container getContainer(long cid) {
        return (Container)containersById.get(cid);
    }

    Container getContainer(JNDIHandle jh) {
        return this.getContainer(jh.getContainerID());
    }

    public JNDIHandle createContainer(String name, byte[] data, boolean toReplicate) throws JNDIException {
        long cid = -1L;
        try {
            CacheCommunicatorImpl.monitor.tryToAccess();
            if (toReplicate) {
                cid = this.getNewRCID();
                Container c = new Container(name, cid);
                c.setData(data);
                JNDIMemoryImpl jNDIMemoryImpl = this;
                synchronized (jNDIMemoryImpl) {
                    containersByName.put(name, c);
                    containersById.put(cid, c);
                }
                this.sendObject(cid, name, "", data, 0L, 4, (byte)2, 0, null);
            } else {
                cid = cids.getID();
                Container c = new Container(name, cid);
                c.setData(data);
                JNDIMemoryImpl jNDIMemoryImpl = this;
                synchronized (jNDIMemoryImpl) {
                    containersByName.put(name, c);
                    containersById.put(cid, c);
                }
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            CacheCommunicatorImpl.monitor.endAccess();
            throw throwable;
        }
        CacheCommunicatorImpl.monitor.endAccess();
        return new JNDIHandleImpl(cid, -1L);
    }

    public JNDIHandle createNamedContainer(String name, byte[] data, boolean toReplicate) throws JNDIException {
        return this.createContainer(name, data, toReplicate);
    }

    public void modifyContainer(JNDIHandle handle, byte[] data, boolean toReplicate) throws JNDIException {
        try {
            CacheCommunicatorImpl.monitor.tryToAccess();
            if (toReplicate) {
                JNDIMemoryImpl jNDIMemoryImpl = this;
                synchronized (jNDIMemoryImpl) {
                    Container c = (Container)containersById.remove(handle.getContainerID());
                    containersByName.remove(c.getContainerName());
                    c.setData(data);
                    containersById.put(c.getId(), c);
                    containersByName.put(c.getContainerName(), c);
                }
                this.sendObject(handle.getContainerID(), "", "", data, 0L, 7, (byte)2, 0, null);
            } else {
                JNDIMemoryImpl jNDIMemoryImpl = this;
                synchronized (jNDIMemoryImpl) {
                    Container c = (Container)containersById.remove(handle.getContainerID());
                    containersByName.remove(c.getContainerName());
                    c.setData(data);
                    containersById.put(c.getId(), c);
                    containersByName.put(c.getContainerName(), c);
                }
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            CacheCommunicatorImpl.monitor.endAccess();
            throw throwable;
        }
        CacheCommunicatorImpl.monitor.endAccess();
    }

    public void deleteContainer(JNDIHandle handle, boolean toReplicate) throws JNDIException {
        try {
            JNDIMemoryImpl jNDIMemoryImpl;
            CacheCommunicatorImpl.monitor.tryToAccess();
            if (toReplicate) {
                jNDIMemoryImpl = this;
                synchronized (jNDIMemoryImpl) {
                    Container c = (Container)containersById.remove(handle.getContainerID());
                    containersByName.remove(c.getContainerName());
                }
                this.sendObject(handle.getContainerID(), "", "", new byte[0], 0L, 5, (byte)2, 0, null);
            } else {
                jNDIMemoryImpl = this;
                synchronized (jNDIMemoryImpl) {
                    Container c = (Container)containersById.remove(handle.getContainerID());
                    containersByName.remove(c.getContainerName());
                }
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            CacheCommunicatorImpl.monitor.endAccess();
            throw throwable;
        }
        CacheCommunicatorImpl.monitor.endAccess();
        int[] ids = JNDIMemoryImpl.longTo2Ints(handle.getContainerID());
        if (ids[1] == clusterId) {
            cidsR.releaseID(ids[0]);
        } else if (ids[1] == 0) {
            cids.releaseID(ids[0]);
        }
    }

    public byte[] readContainer(JNDIHandle handle) throws JNDIException {
        Container c = this.getContainer(handle);
        return c.getData();
    }

    public void renameContainer(JNDIHandle container, String newname) throws JNDIException {
    }

    public String getContainerName(JNDIHandle container) throws JNDIException {
        return this.getContainer((long)container.getContainerID()).name;
    }

    public JNDIHandle getRootContainer() throws JNDIException {
        return root;
    }

    public JNDIHandle bindObject(JNDIHandle container, String name, byte[] data, short typeOfOperation) throws JNDIException {
        long oid = -1L;
        Container c = this.getContainer(container);
        try {
            if (c != null) {
                try {
                    CacheCommunicatorImpl.monitor.tryToAccess();
                    if (typeOfOperation == 2 || typeOfOperation == 4) {
                        oid = this.getNewROID();
                        c.append(name, data, oid, typeOfOperation);
                        this.sendObject(container.getContainerID(), this.getContainerName(container), name, data, oid, 2, (byte)typeOfOperation, 0, null);
                    } else {
                        oid = oids.getID();
                        c.append(name, data, oid, typeOfOperation);
                    }
                    Object var9_7 = null;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    CacheCommunicatorImpl.monitor.endAccess();
                    throw throwable;
                }
            } else {
                this.dump("JNDI -- Container is null !!!!!!");
                return null;
            }
            CacheCommunicatorImpl.monitor.endAccess();
        }
        catch (Exception e) {
            JNDIFrame.log.logCatching(e);
            throw new JNDIException(JNDIException.CAN_NOT_BIND_OBJECT, new Object[]{name}, e);
        }
        return new JNDIHandleImpl(c.getId(), oid);
    }

    public void sendObject(long containerID, String containerName, String objectName, byte[] data, long objectID, int type_, byte operationType, int clusterId, ByteArrayOutputStream collectedMsgs) {
        int j;
        int type = type_;
        long[] id = new long[]{containerID};
        byte[] cid = Convert.longArrToByteArr(id);
        long[] id2 = new long[]{objectID};
        byte[] oid = Convert.longArrToByteArr(id2);
        byte[] objectName_ = objectName.getBytes();
        int[] size1 = new int[]{objectName_.length};
        byte[] sizen = Convert.intArrToByteArr(size1);
        byte sizenLength = (byte)sizen.length;
        byte[] containerName_ = containerName.getBytes();
        int[] size2 = new int[]{containerName_.length};
        byte[] sizenc = Convert.intArrToByteArr(size2);
        byte sizencLength = (byte)sizenc.length;
        byte cidSize = (byte)cid.length;
        byte oidSize = (byte)oid.length;
        int i = 1;
        byte[] message = new byte[cid.length + oid.length + sizen.length + objectName_.length + sizenc.length + containerName_.length + data.length + 7];
        message[0] = cidSize;
        if (cid.length > 0) {
            j = 0;
            while (j < cid.length) {
                message[i] = cid[j];
                ++i;
                ++j;
            }
        }
        message[i] = oidSize;
        ++i;
        if (oid.length > 0) {
            j = 0;
            while (j < oid.length) {
                message[i] = oid[j];
                ++i;
                ++j;
            }
        }
        message[i] = sizencLength;
        ++i;
        if (sizenc.length > 0) {
            j = 0;
            while (j < sizenc.length) {
                message[i] = sizenc[j];
                ++i;
                ++j;
            }
        }
        if (containerName_.length > 0) {
            j = 0;
            while (j < containerName_.length) {
                message[i] = containerName_[j];
                ++i;
                ++j;
            }
        }
        message[i] = sizenLength;
        ++i;
        if (sizen.length > 0) {
            j = 0;
            while (j < sizen.length) {
                message[i] = sizen[j];
                ++i;
                ++j;
            }
        }
        if (objectName_.length > 0) {
            j = 0;
            while (j < objectName_.length) {
                message[i] = objectName_[j];
                ++i;
                ++j;
            }
        }
        if (data.length > 0) {
            j = 0;
            while (j < data.length) {
                message[i] = data[j];
                ++i;
                ++j;
            }
        }
        message[i] = operationType;
        if (this.communicator != null) {
            if (clusterId == 0) {
                this.communicator.sendToAll(message, type, message.length);
            } else {
                if (collectedMsgs.size() + message.length > Constants.REPLICATION_MESSAGE_SIZE && collectedMsgs.size() > 0) {
                    byte[] bigMsg = collectedMsgs.toByteArray();
                    this.communicator.sendToServer(clusterId, bigMsg, 15, bigMsg.length);
                    collectedMsgs.reset();
                }
                int[] sizeT = new int[]{type};
                byte[] typeInBytes = Convert.intArrToByteArr(sizeT);
                byte sizeTypeLength = (byte)typeInBytes.length;
                collectedMsgs.write(sizeTypeLength);
                try {
                    collectedMsgs.write(typeInBytes);
                }
                catch (IOException e) {
                    JNDIFrame.log.logCatching(e);
                }
                int[] sizeM = new int[]{message.length};
                byte[] sizeMsg = Convert.intArrToByteArr(sizeM);
                byte sizeMsgLength = (byte)sizeMsg.length;
                collectedMsgs.write(sizeMsgLength);
                try {
                    collectedMsgs.write(sizeMsg);
                }
                catch (IOException e) {
                    JNDIFrame.log.logCatching(e);
                }
                try {
                    collectedMsgs.write(message);
                }
                catch (IOException e) {
                    JNDIFrame.log.logCatching(e);
                }
            }
        }
    }

    public boolean replicateObjectBind(String containerName, String objectName, byte[] data, long oid, short operationType) throws JNDIException {
        block18: {
            try {
                Container c;
                Serializable serializable;
                if (oidInitNumber > -1) {
                    this.communicator.replicationCounter.inc();
                    int[] ids = JNDIMemoryImpl.longTo2Ints(oid);
                    if (ids[1] == clusterId) {
                        serializable = this;
                        synchronized (serializable) {
                            if (ids[0] < oidInitNumber) {
                                oidInitNumber = ids[0];
                            } else if (ids[0] >= oidInitCounter) {
                                oidInitCounter = ids[0] + 1;
                            }
                        }
                    }
                }
                if ((c = this.getContainerByName(containerName)) != null) {
                    serializable = ServerContextImpl.getLockObject(c.getId());
                    synchronized (serializable) {
                        JNDIHandle j = c.getJNDIHandle(objectName);
                        if (j == null) {
                            c.append(objectName, data, oid, operationType);
                            ServerContextImpl.increaseNumberOfBindings();
                        }
                        break block18;
                    }
                }
                try {
                    this.buildSubContextsStructure(containerName);
                }
                catch (JNDIException e) {
                    JNDIFrame.log.logCatching((Throwable)((Object)e));
                    return false;
                }
                Container container = this.getContainerByName(containerName);
                JNDIHandle j = container.getJNDIHandle(objectName);
                if (j == null) {
                    container.append(objectName, data, oid, operationType);
                    ServerContextImpl.increaseNumberOfBindings();
                }
            }
            catch (Exception e) {
                JNDIFrame.log.logCatching(e);
                return false;
            }
        }
        return true;
    }

    public boolean replicateObjectRebind(String containerName, String objectName, byte[] data, long objectId, short operationType) throws JNDIException {
        block7: {
            try {
                Container c = this.getContainerByName(containerName);
                if (c == null) break block7;
                Long l = ServerContextImpl.getLockObject(c.getId());
                synchronized (l) {
                    JNDIHandle j = c.getJNDIHandle(objectName);
                    if (j != null) {
                        c.modify(j, data);
                        if (this.getObjectType(j) != operationType) {
                            c.setTypeOf(j, operationType);
                        }
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            catch (Exception e) {
                JNDIFrame.log.logCatching(e);
            }
        }
        return true;
    }

    public boolean replicateContainer(String name, byte[] data, long cid) {
        JNDIMemoryImpl jNDIMemoryImpl;
        Long l = ServerContextImpl.getLockObject(cid);
        synchronized (l) {
            Container c = this.getContainerByName(name);
            if (c == null) {
                c = new Container(name, cid);
                c.setData(data);
                c.setid(cid);
                jNDIMemoryImpl = this;
                synchronized (jNDIMemoryImpl) {
                    containersById.put(cid, c);
                    containersByName.put(name, c);
                }
            }
            ServerContextImpl.decreaseNumberOfBindings();
        }
        if (cidInitNumber > -1) {
            this.communicator.replicationCounter.inc();
            int[] ids = JNDIMemoryImpl.longTo2Ints(cid);
            if (ids[1] == clusterId) {
                jNDIMemoryImpl = this;
                synchronized (jNDIMemoryImpl) {
                    if (ids[0] <= cidInitNumber) {
                        cidInitNumber = ids[0];
                    } else if (ids[0] >= cidInitCounter) {
                        cidInitCounter = ids[0] + 1;
                    }
                }
            }
        }
        return true;
    }

    public boolean replicateContainerDelete(long cid) {
        Container c;
        Long l = ServerContextImpl.getLockObject(cid);
        synchronized (l) {
            try {
                c = (Container)containersById.remove(cid);
                if (c != null) {
                    containersByName.remove(c.getContainerName());
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                ServerContextImpl.unlockObject(cid);
                throw throwable;
            }
            ServerContextImpl.unlockObject(cid);
        }
        ServerContextImpl.increaseNumberOfBindings();
        if (c != null) {
            int[] ids = JNDIMemoryImpl.longTo2Ints(cid);
            if (ids[1] == clusterId) {
                cidsR.releaseID(ids[0]);
            } else if (ids[1] == 0) {
                cids.releaseID(ids[0]);
            }
            return true;
        }
        return false;
    }

    public void replicateLinkObjectToContainer(String containerName, String objectId, long idToLink) throws JNDIException {
        Container c = this.getContainerByName(containerName);
        if (c != null) {
            Long l = ServerContextImpl.getLockObject(c.cid);
            synchronized (l) {
                c = this.getContainerByName(containerName);
                if (c != null) {
                    long oid = new Long(objectId);
                    c.createLink(new JNDIHandleImpl(c.getId(), oid), idToLink);
                }
            }
        }
    }

    public void replicateModifyContainer(long containerId, byte[] data) {
        Container c = this.getContainer(containerId);
        if (c != null) {
            Long l = ServerContextImpl.getLockObject(c.cid);
            synchronized (l) {
                c = this.getContainer(containerId);
                if (c != null) {
                    c.setData(data);
                }
            }
        }
    }

    public void replicateRemoveLinkedContainer(long containerId, long objectId) throws JNDIException {
        Container c = this.getContainer(containerId);
        if (c != null) {
            Long l = ServerContextImpl.getLockObject(c.cid);
            synchronized (l) {
                c = this.getContainer(containerId);
                if (c != null) {
                    c.removeLink(new JNDIHandleImpl(containerId, objectId));
                }
            }
        }
    }

    public void replicateRenameObject(String containerName, String newObjectName, long objectId) {
        block6: {
            try {
                Container c = this.getContainerByName(containerName);
                if (c == null) break block6;
                Long l = ServerContextImpl.getLockObject(c.cid);
                synchronized (l) {
                    c = this.getContainerByName(containerName);
                    if (c != null) {
                        c.rename(new JNDIHandleImpl(c.getId(), objectId), newObjectName);
                    }
                }
            }
            catch (Exception e) {
                JNDIFrame.log.logCatching(e);
            }
        }
    }

    public void replicateUnbindObject(String containerName, long objectId) {
        block9: {
            try {
                Container c = this.getContainerByName(containerName);
                if (c == null) break block9;
                Long l = ServerContextImpl.getLockObject(c.cid);
                synchronized (l) {
                    c = this.getContainerByName(containerName);
                    if (c != null) {
                        c.deleteObject(new JNDIHandleImpl(c.getId(), objectId));
                        ServerContextImpl.decreaseNumberOfBindings();
                        int[] ids = JNDIMemoryImpl.longTo2Ints(objectId);
                        if (ids[1] == clusterId) {
                            oidsR.releaseID(ids[0]);
                        } else if (ids[1] == 0) {
                            oids.releaseID(ids[0]);
                        }
                    }
                }
            }
            catch (Exception e) {
                JNDIFrame.log.logCatching(e);
            }
        }
    }

    public void initIDGenerator() {
        cidsR = new IDGenerator(cidInitCounter, cidInitCounter, cidInitNumber);
        oidsR = new IDGenerator(cidInitCounter, oidInitCounter, oidInitNumber);
        cidInitNumber = -1;
        oidInitNumber = -1;
    }

    public int toSendGlobalObjects(int clusterId, JNDIHandle j) throws JNDIException {
        ByteArrayOutputStream collectedMsgs = new ByteArrayOutputStream();
        int numberOfSentObjects = this.replicateAll(clusterId, j, collectedMsgs);
        if (collectedMsgs.size() != 0) {
            byte[] bigMsg = collectedMsgs.toByteArray();
            this.communicator.sendToServer(clusterId, bigMsg, 15, bigMsg.length);
            collectedMsgs.reset();
        }
        return numberOfSentObjects;
    }

    public int replicateAll(int clusterId, JNDIHandle j, ByteArrayOutputStream collectedMsgs) throws JNDIException {
        JNDIHandle root = j;
        int currentItterationCounter = 0;
        if (j == null) {
            root = this.getRootContainer();
        }
        JNDIHandleEnumeration je = this.listObjects(root, "");
        while (je.hasMoreElements()) {
            JNDIHandle h = je.nextObject();
            short type = this.getObjectType(h);
            if (type == 2 || type == 4) {
                this.sendObject(h.getContainerID(), this.getContainerName(new JNDIHandleImpl(h.getContainerID(), -1L)), this.getObjectName(h), this.readObject(h), h.getObjectID(), 2, (byte)type, clusterId, collectedMsgs);
                ++currentItterationCounter;
                if (this.getLinkedContainer(h) == null) continue;
                JNDIHandle lc = this.getLinkedContainer(h);
                this.sendObject(lc.getContainerID(), this.getContainerName(lc), "", this.readContainer(lc), 0L, 4, (byte)2, clusterId, collectedMsgs);
                ++currentItterationCounter;
                this.sendObject(h.getContainerID(), this.getContainerName(new JNDIHandleImpl(h.getContainerID(), -1L)), new Long(h.getObjectID()).toString(), new byte[0], lc.getContainerID(), 6, (byte)2, clusterId, collectedMsgs);
                currentItterationCounter += this.replicateAll(clusterId, this.getLinkedContainer(h), collectedMsgs);
                continue;
            }
            if (this.getLinkedContainer(h) == null) continue;
            currentItterationCounter += this.replicateAll(clusterId, this.getLinkedContainer(h), collectedMsgs);
        }
        return currentItterationCounter;
    }

    public void buildSubContextsStructure(String nameStructure) throws JNDIException {
        JNDIHandle containerHandle = this.getRootContainer();
        JNDIHandleEnumeration je = this.listObjects(containerHandle, "root");
        JNDIHandle h = je.nextObject();
        Container c = this.getContainer(this.getLinkedContainer(h));
        String objectName = "";
        String containerName = "";
        StringTokenizer st = new StringTokenizer(nameStructure.substring(1), "/");
        long oid = 0L;
        long cid = 0L;
        while (st.hasMoreElements()) {
            objectName = st.nextToken();
            if (c == null) continue;
            if (c.getObject(objectName) == null) {
                oid = oids.getID();
                c.append(objectName, DirObject.getNewDirObject(null, null), oid, (short)3);
                cid = cids.getID();
                containerName = containerName + "/" + objectName;
                Container newc = new Container(containerName, cid);
                newc.setData(Serializator.toByteArray(new Properties()));
                newc.setid(cid);
                JNDIMemoryImpl jNDIMemoryImpl = this;
                synchronized (jNDIMemoryImpl) {
                    containersByName.put(containerName, newc);
                    containersById.put(cid, newc);
                }
                c.createLink(new JNDIHandleImpl(c.getId(), oid), cid);
                c = newc;
                continue;
            }
            c = this.getContainer(this.getLinkedContainer(c.getJNDIHandle(objectName)));
            containerName = containerName + "/" + objectName;
        }
    }

    public void unbindObject(JNDIHandle container, String name, short typeOfOperation) throws JNDIException {
        block9: {
            try {
                Container c = this.getContainer(container.getContainerID());
                if (c == null) break block9;
                JNDIHandle j = c.getJNDIHandle(name);
                try {
                    CacheCommunicatorImpl.monitor.tryToAccess();
                    if (typeOfOperation == 2 || typeOfOperation == 4) {
                        c.deleteObject(j);
                        this.sendObject(j.getContainerID(), c.getContainerName(), "", new byte[0], j.getObjectID(), 10, (byte)typeOfOperation, 0, null);
                    } else {
                        c.deleteObject(j);
                    }
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    CacheCommunicatorImpl.monitor.endAccess();
                    throw throwable;
                }
                CacheCommunicatorImpl.monitor.endAccess();
                int[] ids = JNDIMemoryImpl.longTo2Ints(j.getObjectID());
                if (ids[1] == clusterId) {
                    oidsR.releaseID(ids[0]);
                } else if (ids[1] == 0) {
                    oids.releaseID(ids[0]);
                }
            }
            catch (Exception e) {
                JNDIFrame.log.logCatching(e);
                throw new JNDIException(JNDIException.CAN_NOT_UNBIND_OBJECT, new Object[]{name}, e);
            }
        }
    }

    public void unbindObject(JNDIHandle objectHandle, short typeOfOperation) throws JNDIException {
        block9: {
            String name = this.getObjectName(objectHandle);
            try {
                Container c = this.getContainer(objectHandle.getContainerID());
                if (c == null) break block9;
                try {
                    CacheCommunicatorImpl.monitor.tryToAccess();
                    if (typeOfOperation == 2 || typeOfOperation == 4) {
                        c.deleteObject(objectHandle);
                        this.sendObject(objectHandle.getContainerID(), c.getContainerName(), "", new byte[0], objectHandle.getObjectID(), 10, (byte)typeOfOperation, 0, null);
                    } else {
                        c.deleteObject(objectHandle);
                    }
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    CacheCommunicatorImpl.monitor.endAccess();
                    throw throwable;
                }
                CacheCommunicatorImpl.monitor.endAccess();
                int[] ids = JNDIMemoryImpl.longTo2Ints(objectHandle.getObjectID());
                if (ids[1] == clusterId) {
                    oidsR.releaseID(ids[0]);
                } else if (ids[1] == 0) {
                    oids.releaseID(ids[0]);
                }
            }
            catch (Exception e) {
                JNDIFrame.log.logCatching(e);
                throw new JNDIException(JNDIException.CAN_NOT_UNBIND_OBJECT, new Object[]{name}, e);
            }
        }
    }

    public void rebindObject(JNDIHandle container, String name, byte[] newData, short typeOfOperation) throws JNDIException {
        block6: {
            try {
                Container c = this.getContainer(container.getContainerID());
                if (c == null) break block6;
                JNDIHandle j = c.getJNDIHandle(name);
                try {
                    CacheCommunicatorImpl.monitor.tryToAccess();
                    if (typeOfOperation == 2 || typeOfOperation == 4) {
                        c.modify(j, newData);
                        this.sendObject(j.getContainerID(), c.getContainerName(), this.getObjectName(j), newData, j.getObjectID(), 3, (byte)typeOfOperation, 0, null);
                    } else {
                        c.modify(j, newData);
                    }
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    CacheCommunicatorImpl.monitor.endAccess();
                    throw throwable;
                }
                CacheCommunicatorImpl.monitor.endAccess();
                {
                }
            }
            catch (Exception e) {
                JNDIFrame.log.logCatching(e);
                throw new JNDIException(JNDIException.CAN_NOT_REBIND_OBJECT, new Object[]{name}, e);
            }
        }
    }

    public void rebindObject(JNDIHandle objectHandle, byte[] newData, short typeOfOperation) throws JNDIException {
        block6: {
            String name = this.getObjectName(objectHandle);
            try {
                Container c = this.getContainer(objectHandle.getContainerID());
                if (c == null) break block6;
                try {
                    CacheCommunicatorImpl.monitor.tryToAccess();
                    if (typeOfOperation == 2 || typeOfOperation == 4) {
                        c.modify(objectHandle, newData);
                        this.sendObject(objectHandle.getContainerID(), c.getContainerName(), this.getObjectName(objectHandle), newData, objectHandle.getObjectID(), 3, (byte)typeOfOperation, 0, null);
                    } else {
                        c.modify(objectHandle, newData);
                    }
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    CacheCommunicatorImpl.monitor.endAccess();
                    throw throwable;
                }
                CacheCommunicatorImpl.monitor.endAccess();
                {
                }
            }
            catch (Exception e) {
                JNDIFrame.log.logCatching(e);
                throw new JNDIException(JNDIException.CAN_NOT_REBIND_OBJECT, new Object[]{name}, e);
            }
        }
    }

    public void renameObject(JNDIHandle container, String name, String newName, short typeOfOperation) throws JNDIException {
        block6: {
            try {
                Container c = this.getContainer(container.getContainerID());
                if (c == null) break block6;
                JNDIHandle j = c.getJNDIHandle(name);
                try {
                    CacheCommunicatorImpl.monitor.tryToAccess();
                    if (typeOfOperation == 2 || typeOfOperation == 4) {
                        c.rename(j, newName);
                        this.sendObject(j.getContainerID(), c.getContainerName(), newName, new byte[0], j.getObjectID(), 9, (byte)typeOfOperation, 0, null);
                    } else {
                        c.rename(j, newName);
                    }
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    CacheCommunicatorImpl.monitor.endAccess();
                    throw throwable;
                }
                CacheCommunicatorImpl.monitor.endAccess();
                {
                }
            }
            catch (Exception e) {
                JNDIFrame.log.logCatching(e);
                throw new JNDIException(JNDIException.CAN_NOT_RENAME_OBJECT, new Object[]{name}, e);
            }
        }
    }

    public void renameObject(JNDIHandle objectHandle, String newName, short typeOfOperation) throws JNDIException {
        block6: {
            String name = this.getObjectName(objectHandle);
            try {
                Container c = this.getContainer(objectHandle.getContainerID());
                if (c == null) break block6;
                try {
                    CacheCommunicatorImpl.monitor.tryToAccess();
                    if (typeOfOperation == 2 || typeOfOperation == 4) {
                        c.rename(objectHandle, newName);
                        this.sendObject(objectHandle.getContainerID(), c.getContainerName(), newName, new byte[0], objectHandle.getObjectID(), 9, (byte)typeOfOperation, 0, null);
                    } else {
                        c.rename(objectHandle, newName);
                    }
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    CacheCommunicatorImpl.monitor.endAccess();
                    throw throwable;
                }
                CacheCommunicatorImpl.monitor.endAccess();
                {
                }
            }
            catch (Exception e) {
                JNDIFrame.log.logCatching(e);
                throw new JNDIException(JNDIException.CAN_NOT_RENAME_OBJECT, new Object[]{name}, e);
            }
        }
    }

    public byte[] readObject(JNDIHandle container, String name) throws JNDIException {
        Container c = this.getContainer(container.getContainerID());
        if (c != null) {
            JNDIHandle j = c.getJNDIHandle(name);
            return c.readObject(j);
        }
        return null;
    }

    public byte[] readObject(JNDIHandle objectHandle) throws JNDIException {
        if (objectHandle == null) {
            return null;
        }
        Container c = this.getContainer(objectHandle.getContainerID());
        if (c != null) {
            return c.readObject(objectHandle);
        }
        return null;
    }

    public JNDIHandleEnumeration listObjects(JNDIHandle container, String name) throws JNDIException {
        Container c = this.getContainer(container.getContainerID());
        if (c != null) {
            return c.getAllByName(name);
        }
        return null;
    }

    public String getObjectName(JNDIHandle object) throws JNDIException {
        Container c = this.getContainer(object.getContainerID());
        if (c != null) {
            return c.getNameOf(object);
        }
        return null;
    }

    public short getObjectType(JNDIHandle object) throws JNDIException {
        Container c = this.getContainer(object.getContainerID());
        if (c != null) {
            return c.getTypeOf(object);
        }
        return -1;
    }

    public long getObjectId(JNDIHandle object) throws JNDIException {
        Container c = this.getContainer(object.getContainerID());
        if (c != null) {
            return c.getIdOf(object);
        }
        return -1L;
    }

    public Container getContainerByName(String name) {
        return (Container)containersByName.get(name);
    }

    public JNDIHandle findObject(JNDIHandle containerHandle, String name) throws JNDIException {
        JNDIHandleEnumeration he = this.listObjects(containerHandle, name);
        if (he != null && he.hasMoreElements()) {
            int[] ids;
            JNDIHandle object = he.nextObject();
            if (this.getObjectType(object) == 4 && (ids = JNDIMemoryImpl.longTo2Ints(object.getObjectID()))[1] != clusterId && ids[1] != 0) {
                if (CacheCommunicatorImpl.clContext.getClusterMonitor().getParticipant(ids[1]) == null) {
                    try {
                        CacheCommunicatorImpl.monitor.tryToAccess();
                        Container c = this.getContainer(containerHandle);
                        c.deleteObject(object);
                        this.sendObject(object.getContainerID(), c.getContainerName(), "", new byte[0], object.getObjectID(), 10, (byte)4, 0, null);
                        object = null;
                        Object var8_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        CacheCommunicatorImpl.monitor.endAccess();
                        throw throwable;
                    }
                    CacheCommunicatorImpl.monitor.endAccess();
                    {
                    }
                }
            }
            return object;
        }
        return null;
    }

    public void moveObject(JNDIHandle container, String name, JNDIHandle newContainer, String newName, short typeOfOperation) throws JNDIException {
        try {
            Container oldc = this.getContainer(container);
            Container newc = this.getContainer(newContainer);
            if (oldc != null && newc != null) {
                JNDIHandle object = oldc.getJNDIHandle(name);
                byte[] data = this.readObject(object);
                JNDIHandle newObject = this.bindObject(newContainer, newName, data, typeOfOperation);
                JNDIHandle linkedContainer = this.getLinkedContainer(object);
                if (linkedContainer != null) {
                    this.linkObjectToContainer(newObject, linkedContainer, typeOfOperation);
                }
                this.unbindObject(container, name, typeOfOperation);
            }
        }
        catch (Exception e) {
            JNDIFrame.log.logCatching(e);
            throw new JNDIException(JNDIException.CAN_NOT_MOVE_OBJECT, new Object[]{name}, e);
        }
    }

    public void moveObject(JNDIHandle objectHandle, JNDIHandle newContainer, String newName, short typeOfOperation) throws JNDIException {
    }

    public void linkObjectToContainer(JNDIHandle objectHandle, JNDIHandle containerHandle, short typeOfOperation) throws JNDIException {
        long cid = objectHandle.getContainerID();
        Container c = this.getContainer(cid);
        if (c != null) {
            try {
                CacheCommunicatorImpl.monitor.tryToAccess();
                if (typeOfOperation == 2 || typeOfOperation == 4) {
                    c.createLink(objectHandle, containerHandle.getContainerID());
                    this.sendObject(cid, c.getContainerName(), new Long(objectHandle.getObjectID()).toString(), new byte[0], containerHandle.getContainerID(), 6, (byte)typeOfOperation, 0, null);
                } else {
                    c.createLink(objectHandle, containerHandle.getContainerID());
                }
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                CacheCommunicatorImpl.monitor.endAccess();
                throw throwable;
            }
            CacheCommunicatorImpl.monitor.endAccess();
            {
            }
        }
    }

    public synchronized void removeLinkedContainer(JNDIHandle objectHandle, short typeOfOperation) throws JNDIException {
        Container c = this.getContainer(objectHandle.getContainerID());
        try {
            CacheCommunicatorImpl.monitor.tryToAccess();
            if (typeOfOperation == 2 || typeOfOperation == 4) {
                c.removeLink(objectHandle);
                this.sendObject(objectHandle.getContainerID(), "", "", new byte[0], objectHandle.getObjectID(), 8, (byte)typeOfOperation, 0, null);
            } else {
                c.removeLink(objectHandle);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            CacheCommunicatorImpl.monitor.endAccess();
            throw throwable;
        }
        CacheCommunicatorImpl.monitor.endAccess();
    }

    public JNDIHandle getLinkedContainer(JNDIHandle objectHandle) throws JNDIException {
        Container c = this.getContainer(objectHandle.getContainerID());
        return c.getLinkedContainer(objectHandle);
    }

    public JNDIHandle createHandle() throws JNDIException {
        return new JNDIHandleImpl(-1L, -1L);
    }

    public void printAll() {
        System.out.println(" *** Persistent base *** ");
        Object[] containers = containersById.getAllValues();
        int i = 0;
        while (i < containers.length) {
            Container c = (Container)containers[i];
            System.out.print(c.name + " " + c.cid + " [ ");
            c.printAll();
            System.out.println(" ]");
            ++i;
        }
    }

    private String datadesc(JNDIHandle j) throws JNDIException {
        try {
            switch (this.getObjectType(j)) {
                case 2: {
                    return "O-REPLO";
                }
                case 3: {
                    return "O-LOCO";
                }
                case 4: {
                    return "O-REPLREM";
                }
            }
        }
        catch (ClassCastException c) {
            return "NCLU";
        }
        return "UNK";
    }

    private void printRec(JNDIHandle cont, int level, PrintStream out) throws JNDIException {
        JNDIHandleEnumeration je = this.listObjects(cont, "");
        while (je.hasMoreElements()) {
            int i;
            JNDIHandle j = je.nextObject();
            if (this.getLinkedContainer(j) != null) {
                i = 0;
                while (i < level + 1) {
                    out.print("   ");
                    ++i;
                }
                out.println("[CONT " + this.getObjectName(j) + " " + ((JNDIHandleImpl)this.getLinkedContainer((JNDIHandle)j)).cid + "]" + (this.datadesc(j).equals("O-LOCO") ? "CO-LOCC" : "CO-REPLC"));
                this.printRec(this.getLinkedContainer(j), level + 1, out);
                continue;
            }
            i = 0;
            while (i < level + 1) {
                out.print("   ");
                ++i;
            }
            out.println("*(" + this.getObjectName(j) + " " + ((JNDIHandleImpl)j).oid + ")" + this.datadesc(j));
        }
    }

    public void printTree(PrintStream out) throws JNDIException {
        out.println("*** TREE *** ");
        out.println("[CONT root " + ((JNDIHandleImpl)this.getRootContainer()).cid + "]" + "ROOT_CONTEXT");
        this.printRec(this.getRootContainer(), 0, out);
    }

    public boolean getLastSerilaizationType() {
        return false;
    }

    protected void dump(String s) {
    }

    public JNDIHandle createContianerHandle(JNDIHandle j) {
        return null;
    }

    public static final long twoIntsToLong(int a, int b) {
        return (long)b << 32 | (long)a;
    }

    public static final int[] longTo2Ints(long a) {
        int[] rez = new int[]{(byte)a & 0xFF | ((byte)(a >> 8) & 0xFF) << 8 | ((byte)(a >> 16) & 0xFF) << 16 | (byte)(a >> 24) << 24, ((byte)(a >> 32) & 0xFF) << 32 | ((byte)(a >> 40) & 0xFF) << 40 | ((byte)(a >> 48) & 0xFF) << 48 | (byte)(a >> 56) << 56};
        return rez;
    }
}

